/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.settings;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.FileSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.WrongGrassFolderException;
import es.unex.sextante.gui.exceptions.WrongGrassWinShellException;
import es.unex.sextante.gui.grass.GrassAlgorithmProvider;
import es.unex.sextante.gui.settings.SettingPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class SextanteGrassSettingsPanel
extends SettingPanel {
    public static final int MAJOR_MIN = 6;
    public static final int MAJOR_MAX = 6;
    public static final int MINOR_MIN = 4;
    public static final int MINOR_MAX = 4;
    private JCheckBox jActivateCheckBox;
    private JCheckBox jPortableCheckBox;
    private JLabel jLabelGrassFolder;
    private FileSelectionPanel jGrassFolder;
    private JLabel jLabelWinShell;
    private FileSelectionPanel jWinShellFile;
    private JLabel jLabelUpdate;
    private JButton jButtonUpdate;
    private JCheckBox jCheckBoxLatLon;
    private JCheckBox jCheckBox3DV;
    private JCheckBox jCheckBoxNoVectBBox;
    private JCheckBox jCheckBoxInPolylines;
    private JCheckBox jCheckBoxCleanPolygons;
    private JCheckBox jCheckBoxSextanteNull;
    private JCheckBox jCheckBoxCompatibility;

    @Override
    protected void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, -1.0, 3.0}, {3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -1.0, -3.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.jActivateCheckBox = new JCheckBox(Sextante.getText((String)"ActivateProvider") + " GRASS GIS");
        String sActivate = SextanteGUI.getSettingParameterValue("GrassActivate");
        boolean bActivate = Boolean.parseBoolean(sActivate);
        this.jActivateCheckBox.setSelected(bActivate);
        this.add((Component)this.jActivateCheckBox, "1, 1");
        this.add((Component)new JSeparator(0), "1, 2, 2, 2");
        this.jPortableCheckBox = new JCheckBox(Sextante.getText((String)"Portable"));
        String sActivatePortable = SextanteGUI.getSettingParameterValue("GrassPortable");
        boolean bActivatePortable = Boolean.parseBoolean(sActivatePortable);
        this.jPortableCheckBox.setEnabled(bActivate);
        this.jPortableCheckBox.setSelected(bActivatePortable);
        this.add((Component)this.jPortableCheckBox, "1, 3");
        this.jLabelGrassFolder = new JLabel();
        this.jLabelGrassFolder.setEnabled(bActivate);
        if (bActivatePortable) {
            this.jLabelGrassFolder.setEnabled(false);
        }
        this.add((Component)this.jLabelGrassFolder, "1, 4");
        this.jLabelGrassFolder.setText(Sextante.getText((String)"GRASS_folder"));
        this.jGrassFolder = new FileSelectionPanel(true, true, (String[])null, Sextante.getText((String)"selector_choose_folder"));
        this.jGrassFolder.getTextField().setEnabled(bActivate);
        this.jGrassFolder.getButton().setEnabled(bActivate);
        if (bActivatePortable) {
            this.jGrassFolder.getTextField().setEnabled(false);
            this.jGrassFolder.getButton().setEnabled(false);
        }
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        this.jGrassFolder.setFilepath(sFolder);
        this.add((Component)this.jGrassFolder, "2, 4");
        this.jLabelWinShell = new JLabel();
        this.jLabelWinShell.setEnabled(bActivate && Sextante.isWindows());
        if (bActivatePortable) {
            this.jLabelWinShell.setEnabled(false);
        }
        this.add((Component)this.jLabelWinShell, "1, 5");
        this.jLabelWinShell.setText("Windows " + Sextante.getText((String)"grass_windows_shell"));
        this.jWinShellFile = new FileSelectionPanel(true, true, new String[]{"sh.exe", null}, Sextante.getText((String)"selector_choose_file"));
        this.jWinShellFile.getTextField().setEnabled(bActivate && Sextante.isWindows());
        this.jWinShellFile.getButton().setEnabled(bActivate && Sextante.isWindows());
        if (bActivatePortable) {
            this.jWinShellFile.getTextField().setEnabled(false);
            this.jWinShellFile.getButton().setEnabled(false);
        }
        String sScriptsFolder = SextanteGUI.getSettingParameterValue("GrassWinShell");
        this.jWinShellFile.setFilepath(sScriptsFolder);
        this.add((Component)this.jWinShellFile, "2, 5");
        this.add((Component)new JSeparator(0), "1, 6, 2, 6");
        this.jLabelUpdate = new JLabel();
        this.jLabelUpdate.setText(Sextante.getText((String)"update_library"));
        this.jLabelUpdate.setEnabled(bActivate);
        this.add((Component)this.jLabelUpdate, "1, 7");
        this.jButtonUpdate = new JButton(Sextante.getText((String)"load_GRASS_modules"));
        this.jButtonUpdate.setEnabled(bActivate);
        this.add((Component)this.jButtonUpdate, "2, 7");
        this.add((Component)new JSeparator(0), "1, 8, 2, 8");
        this.jCheckBoxLatLon = new JCheckBox(Sextante.getText((String)"GRASS_lat_lon_mode"));
        this.jCheckBoxLatLon.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassLatLonMode")));
        this.add((Component)this.jCheckBoxLatLon, "1, 9, 2, 9");
        this.jCheckBox3DV = new JCheckBox();
        this.jCheckBox3DV.setText(Sextante.getText((String)"grass_input_3d"));
        this.jCheckBox3DV.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("Grass3DVMode")));
        this.add((Component)this.jCheckBox3DV, "1, 10, 2, 10");
        this.jCheckBoxNoVectBBox = new JCheckBox(Sextante.getText((String)"grass_no_vect_bbox"));
        this.jCheckBoxNoVectBBox.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassNoVectBBox")));
        this.add((Component)this.jCheckBoxNoVectBBox, "1, 11, 2, 11");
        this.jCheckBoxInPolylines = new JCheckBox();
        this.jCheckBoxInPolylines.setText(Sextante.getText((String)"grass_import_polylines"));
        this.jCheckBoxInPolylines.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassInPolylines")));
        this.add((Component)this.jCheckBoxInPolylines, "1, 12, 2, 12");
        this.jCheckBoxCleanPolygons = new JCheckBox();
        this.jCheckBoxCleanPolygons.setText(Sextante.getText((String)"grass_clean_polygons"));
        this.jCheckBoxCleanPolygons.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassCleanPolygons")));
        this.add((Component)this.jCheckBoxCleanPolygons, "1, 13, 2, 13");
        this.jCheckBoxSextanteNull = new JCheckBox();
        this.jCheckBoxSextanteNull.setText(Sextante.getText((String)"grass_use_sextante_null"));
        this.jCheckBoxSextanteNull.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassUseSextanteNull")));
        this.add((Component)this.jCheckBoxSextanteNull, "1, 14, 2, 14");
        this.jCheckBoxCompatibility = new JCheckBox();
        this.jCheckBoxCompatibility.setText(Sextante.getText((String)"grass_compatibility_mode"));
        this.jCheckBoxCompatibility.setSelected(new Boolean(SextanteGUI.getSettingParameterValue("GrassCompatibilityMode")));
        this.add((Component)this.jCheckBoxCompatibility, "1, 15, 2, 15");
        URL res = this.getClass().getClassLoader().getResource("images/grass.smlogo.gif");
        if (res != null) {
            ImageIcon logo = new ImageIcon(res);
            JLabel logoLabel = new JLabel(logo);
            logoLabel.setIconTextGap(4);
            logoLabel.setVerticalTextPosition(3);
            logoLabel.setText("<html><i><a href=http://grass.osgeo.org/>http://grass.osgeo.org/</a></i></html>");
            this.add((Component)logoLabel, "1, 17, 2, 17");
        }
        this.jActivateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SextanteGrassSettingsPanel.this.setCursor(new Cursor(3));
                SextanteGUI.setSettingParameterValue("GrassActivate", new Boolean(SextanteGrassSettingsPanel.this.jActivateCheckBox.isSelected()).toString());
                SextanteGUI.updateAlgorithmProvider(GrassAlgorithmProvider.class);
                boolean active = SextanteGrassSettingsPanel.this.jActivateCheckBox.isSelected();
                SextanteGrassSettingsPanel.this.jPortableCheckBox.setEnabled(active);
                SextanteGrassSettingsPanel.this.jLabelGrassFolder.setEnabled(active);
                SextanteGrassSettingsPanel.this.jGrassFolder.getTextField().setEnabled(active);
                SextanteGrassSettingsPanel.this.jGrassFolder.getButton().setEnabled(active);
                if (Sextante.isWindows()) {
                    SextanteGrassSettingsPanel.this.jLabelWinShell.setEnabled(active);
                    SextanteGrassSettingsPanel.this.jWinShellFile.getTextField().setEnabled(active);
                    SextanteGrassSettingsPanel.this.jWinShellFile.getButton().setEnabled(active);
                }
                SextanteGrassSettingsPanel.this.jLabelUpdate.setEnabled(active);
                SextanteGrassSettingsPanel.this.jButtonUpdate.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxLatLon.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBox3DV.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxNoVectBBox.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxInPolylines.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxCleanPolygons.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxSextanteNull.setEnabled(active);
                SextanteGrassSettingsPanel.this.jCheckBoxCompatibility.setEnabled(active);
                SextanteGrassSettingsPanel.this.jActivateCheckBox.getParent().repaint();
                active = SextanteGrassSettingsPanel.this.jPortableCheckBox.isSelected();
                if (active) {
                    SextanteGrassSettingsPanel.this.jLabelGrassFolder.setEnabled(false);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getTextField().setEnabled(false);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getButton().setEnabled(false);
                    if (Sextante.isWindows()) {
                        SextanteGrassSettingsPanel.this.jLabelWinShell.setEnabled(false);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getTextField().setEnabled(false);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getButton().setEnabled(false);
                    }
                }
                SextanteGrassSettingsPanel.this.setCursor(new Cursor(0));
            }
        });
        this.jPortableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean active;
                SextanteGrassSettingsPanel.this.setCursor(new Cursor(3));
                SextanteGUI.setSettingParameterValue("GrassPortable", new Boolean(SextanteGrassSettingsPanel.this.jPortableCheckBox.isSelected()).toString());
                SextanteGUI.checkDir(Sextante.PORTABLE_GRASS_FOLDER, true, "GRASS GIS");
                String sPath = new String(SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_GRASS_FOLDER);
                SextanteGUI.setSettingParameterValue("GrassBinariesFolder", sPath);
                SextanteGrassSettingsPanel.this.jGrassFolder.setFilepath(sPath);
                if (Sextante.isWindows()) {
                    SextanteGUI.checkFile(Sextante.PORTABLE_MSYS_FILE, false, "GRASS GIS shell scripts");
                    sPath = SextanteGUI.getSextanteInstallPath() + File.separator + Sextante.PORTABLE_MSYS_FILE;
                    SextanteGUI.setSettingParameterValue("GrassWinShell", sPath);
                    SextanteGrassSettingsPanel.this.jWinShellFile.setFilepath(sPath);
                }
                if (active = SextanteGrassSettingsPanel.this.jPortableCheckBox.isSelected()) {
                    SextanteGrassSettingsPanel.this.jLabelGrassFolder.setEnabled(false);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getTextField().setEnabled(false);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getButton().setEnabled(false);
                    if (Sextante.isWindows()) {
                        SextanteGrassSettingsPanel.this.jLabelWinShell.setEnabled(false);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getTextField().setEnabled(false);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getButton().setEnabled(false);
                    }
                } else {
                    SextanteGrassSettingsPanel.this.jLabelGrassFolder.setEnabled(true);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getTextField().setEnabled(true);
                    SextanteGrassSettingsPanel.this.jGrassFolder.getButton().setEnabled(true);
                    if (Sextante.isWindows()) {
                        SextanteGrassSettingsPanel.this.jLabelWinShell.setEnabled(true);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getTextField().setEnabled(true);
                        SextanteGrassSettingsPanel.this.jWinShellFile.getButton().setEnabled(true);
                    }
                }
                SextanteGrassSettingsPanel.this.setCursor(new Cursor(0));
            }
        });
        this.jButtonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SextanteGrassSettingsPanel.this.jButtonSetupGRASSActionPerformed(evt);
            }
        });
    }

    @Override
    public HashMap<String, String> getValues() {
        String shellPath;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("GrassActivate", new Boolean(this.jActivateCheckBox.isSelected()).toString());
        map.put("GrassPortable", new Boolean(this.jPortableCheckBox.isSelected()).toString());
        String GrassPath = this.jWinShellFile.getFilepath();
        if (GrassPath != null) {
            map.put("GrassBinariesFolder", this.jGrassFolder.getFilepath());
        }
        if (Sextante.isWindows() && (shellPath = this.jWinShellFile.getFilepath()) != null) {
            map.put("GrassWinShell", shellPath);
        }
        map.put("GrassLatLonMode", new Boolean(this.jCheckBoxLatLon.isSelected()).toString());
        map.put("Grass3DVMode", new Boolean(this.jCheckBox3DV.isSelected()).toString());
        map.put("GrassNoVectBBox", new Boolean(this.jCheckBoxNoVectBBox.isSelected()).toString());
        map.put("GrassInPolylines", new Boolean(this.jCheckBoxInPolylines.isSelected()).toString());
        map.put("GrassCleanPolygons", new Boolean(this.jCheckBoxCleanPolygons.isSelected()).toString());
        map.put("GrassUseSextanteNull", new Boolean(this.jCheckBoxSextanteNull.isSelected()).toString());
        map.put("GrassCompatibilityMode", new Boolean(this.jCheckBoxCompatibility.isSelected()).toString());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSetupGRASSActionPerformed(ActionEvent evt) {
        HashMap<String, String> map = this.getValues();
        SextanteGUI.setSettings(map);
        GrassAlgorithmProvider.deleteDescriptionFiles();
        GrassAlgorithmProvider.deleteAlgorithms();
        boolean failed = false;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.checkGrassFolder();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (WrongGrassFolderException e) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_binaries_folder"), Sextante.getText((String)"grass_error_title"), 0);
            this.jGrassFolder.setFilepath("");
            failed = true;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (Sextante.isWindows() && !failed) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.checkGrassWinShell(this.jWinShellFile.getFilepath()) > 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_warning_missing_cmd"), Sextante.getText((String)"grass_warning_title"), 2);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            catch (WrongGrassWinShellException e) {
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_win_shell_binary") + "\n" + Sextante.getText((String)"grass_shell_url"), Sextante.getText((String)"grass_error_title"), 0);
                failed = true;
                GrassAlgorithmProvider.deleteAlgorithms();
                SextanteGUI.getGUIFactory().updateToolbox();
                this.jWinShellFile.setFilepath("");
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (!SextanteGrassSettingsPanel.isSupported() && !failed) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_warning_version"), Sextante.getText((String)"grass_warning_title"), 2);
        }
        int num_algs = 0;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            num_algs = GrassAlgorithmProvider.createAlgorithmsDescriptionFiles();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception e) {
            this.setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_setup"), "", 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (num_algs > 0) {
            SextanteGUI.updateAlgorithmProvider(GrassAlgorithmProvider.class);
            HashMap algs2 = (HashMap)Sextante.getAlgorithms().get("GRASS");
            int iNumAlgs = 0;
            if (algs2 != null) {
                iNumAlgs = algs2.size();
            }
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_info_setup_success") + " " + iNumAlgs + ". ", Sextante.getText((String)"grass_info_title"), 1);
        }
    }

    private void checkGrassFolder() throws WrongGrassFolderException {
        String grassFolder = this.jGrassFolder.getFilepath();
        String[] check_modules = new String[]{"g.region", "g.remove", "r.in.gdal", "r.info", "r.null", "r.out.gdal", "v.in.ogr", "v.info", "v.out.ogr", null};
        if (grassFolder == null) {
            throw new WrongGrassFolderException();
        }
        if (grassFolder.length() < 2) {
            throw new WrongGrassFolderException();
        }
        if (grassFolder.trim().equals("")) {
            throw new WrongGrassFolderException();
        }
        File check = new File(grassFolder);
        if (!check.exists()) {
            throw new WrongGrassFolderException();
        }
        check = new File(grassFolder + File.separator + "etc" + File.separator + "VERSIONNUMBER");
        if (!check.exists()) {
            throw new WrongGrassFolderException();
        }
        int i = 0;
        while (check_modules[i] != null) {
            check = Sextante.isUnix() || Sextante.isMacOSX() ? new File(grassFolder + File.separator + "bin" + File.separator + check_modules[i]) : new File(grassFolder + File.separator + "bin" + File.separator + check_modules[i] + ".exe");
            if (!check.exists()) {
                throw new WrongGrassFolderException();
            }
            ++i;
        }
    }

    private int checkGrassWinShell(String grassWinShell) throws WrongGrassWinShellException {
        int num_missing = 0;
        String[] check_commands = new String[]{"which", "gawk.exe", "cut.exe", "grep.exe", "basename.exe", "sed.exe", "install.exe", "curl.exe", "bc.exe", "wc.exe", "paste.exe", "head.exe", "tail.exe", "cat.exe", "expr.exe", "xargs.exe", "ls.exe", "sort.exe", "cs2cs.exe", "gdalwarp.exe", "unzip.exe"};
        if (grassWinShell == null) {
            throw new WrongGrassWinShellException();
        }
        if (grassWinShell.length() < 2) {
            throw new WrongGrassWinShellException();
        }
        if (grassWinShell.trim().equals("")) {
            throw new WrongGrassWinShellException();
        }
        File check = new File(grassWinShell);
        if (!check.exists()) {
            throw new WrongGrassWinShellException();
        }
        String shToolsPath = grassWinShell;
        shToolsPath = shToolsPath.substring(0, shToolsPath.lastIndexOf(File.separator));
        String GrassPath = this.jGrassFolder.getFilepath();
        GrassPath = GrassPath + File.separator + "bin";
        for (String element : check_commands) {
            boolean missing = false;
            File check_sh = new File(shToolsPath + File.separator + element);
            File check_grass = new File(GrassPath + File.separator + element);
            if (!check_sh.exists() && !check_grass.exists()) {
                missing = true;
            }
            if (!missing) continue;
            Sextante.addWarningToLog((String)("SEXTANTE GRASS interface: External command " + element + " not found in either '" + shToolsPath + "' or '" + GrassPath + "'"));
            ++num_missing;
        }
        return num_missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getGrassMajorVersion() {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            File file = new File(sFolder + File.separator + "etc" + File.separator + "VERSIONNUMBER");
            isr = new InputStreamReader(new FileInputStream(file));
            br = new BufferedReader(isr);
            String sLine = br.readLine();
            String[] sNumbers = sLine.split("\\.");
            String sMajor = sNumbers[0];
            int n = Integer.parseInt(sMajor);
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                br.close();
                isr.close();
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getGrassMinorVersion() {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            File file = new File(sFolder + File.separator + "etc" + File.separator + "VERSIONNUMBER");
            isr = new InputStreamReader(new FileInputStream(file));
            br = new BufferedReader(isr);
            String sLine = br.readLine();
            String[] sNumbers = sLine.split("\\.");
            String sMinor = sNumbers[1];
            int n = Integer.parseInt(sMinor);
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                br.close();
                isr.close();
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    public static boolean isSupported() {
        if (SextanteGrassSettingsPanel.getGrassMajorVersion() < 6 || SextanteGrassSettingsPanel.getGrassMajorVersion() > 6) {
            return false;
        }
        return SextanteGrassSettingsPanel.getGrassMinorVersion() >= 4 && SextanteGrassSettingsPanel.getGrassMinorVersion() <= 4;
    }
}

