/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.geoprocess.algorithm.dissolve.DissolveAlgorithm;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;

public class DissolveParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JComboBox layersCombo = null;
    private JComboBox fieldsCombo = null;
    private JCheckBox selectionOnly = null;
    private JCheckBox adjacentOnly = null;
    private final String[] columnNames = new String[]{"Min", "Max", "Sum", "Avg", "Field ID"};
    private final int[] columnWidths = new int[]{35, 35, 35, 35, 334};
    private TableContainer table = null;
    private AlgorithmOutputPanel algorithmOutputPanel = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 8, 0);
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("Input_layer"), this.getLayersCombo()), gbc);
        gbc.gridy = 1;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("Field"), this.getFieldsCombo()), gbc);
        gbc.gridy = 2;
        this.add(this.getSelectionCheck(), gbc);
        gbc.gridy = 3;
        this.add(this.getAdjacentCheck(), gbc);
        gbc.gridy = 4;
        this.add(new JLabel(GeoProcessLocator.getGeoProcessManager().getTranslation("summary_function")), gbc);
        gbc.gridy = 5;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 12, 0);
        gbc.weighty = 1.0;
        this.add((Component)this.getRadioButtonTable(), gbc);
        gbc.gridy = 6;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
        this.initTable();
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new BorderLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out = ooSet.getOutput("RESULT");
                this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
                this.outputPanel.add((Component)new JLabel(" " + GeoProcessLocator.getGeoProcessManager().getTranslation("Dissolve") + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Vectorial") + "]               "), "West");
                this.outputPanel.add((Component)this.outputChannelSelectionPanel, "Center");
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.algorithmOutputPanel == null) {
            this.algorithmOutputPanel = new AlgorithmOutputPanel();
        }
        return this.algorithmOutputPanel;
    }

    public JPanel getComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 5);
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(180, 18));
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getLayersCombo() {
        if (this.layersCombo == null) {
            this.layersCombo = new JComboBox();
            this.layersCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersCombo.setModel(comboModel);
            this.layersCombo.addActionListener(this);
        }
        return this.layersCombo;
    }

    public JComboBox getFieldsCombo() {
        if (this.fieldsCombo == null) {
            this.fieldsCombo = new JComboBox();
            this.fieldsCombo.setPreferredSize(new Dimension(0, 18));
            List<String> fieldList = this.getFieldList();
            this.fieldsCombo.removeAllItems();
            for (int i = 0; i < fieldList.size(); ++i) {
                this.fieldsCombo.addItem(fieldList.get(i));
            }
        }
        return this.fieldsCombo;
    }

    public JCheckBox getSelectionCheck() {
        if (this.selectionOnly == null) {
            this.selectionOnly = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Selected_geometries"));
        }
        return this.selectionOnly;
    }

    public JCheckBox getAdjacentCheck() {
        if (this.adjacentOnly == null) {
            this.adjacentOnly = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("adjacent_geometries_only"));
        }
        return this.adjacentOnly;
    }

    public TableContainer getRadioButtonTable() {
        if (this.table == null) {
            this.table = new TableContainer(this.columnNames, this.columnWidths, null);
            this.table.setModel("ARGBBandSelectorModel");
            this.table.setControlVisible(false);
            this.table.initialize();
        }
        return this.table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLayersCombo()) {
            List<String> fieldList = this.getFieldList();
            this.getFieldsCombo().removeAllItems();
            for (int i = 0; i < fieldList.size(); ++i) {
                this.getFieldsCombo().addItem(fieldList.get(i));
            }
            this.initTable();
        }
    }

    private void initTable() {
        try {
            this.getRadioButtonTable().removeAllRows();
            for (int i = 0; i < this.getSelectedVectorLayer().getFieldCount(); ++i) {
                if (!Number.class.isAssignableFrom(this.getSelectedVectorLayer().getFieldType(i))) continue;
                this.addTableRow(this.getSelectedVectorLayer().getFieldName(i));
            }
        }
        catch (NotInitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addTableRow(String fieldName) throws NotInitializeException {
        Object[] row = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), fieldName};
        this.getRadioButtonTable().addRow(row);
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("FIELD").setParameterValue((Object)this.fieldsCombo.getSelectedIndex());
            params.getParameter("SELECTED_GEOM").setParameterValue((Object)this.getSelectionCheck().isSelected());
            params.getParameter("DISSOLV_ADJ").setParameterValue((Object)this.getAdjacentCheck().isSelected());
            params.getParameter("FUNCTION_LIST").setParameterValue((Object)this.getValues());
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private String getValues() {
        String str = "";
        try {
            for (int i = 0; i < this.getRadioButtonTable().getRowCount(); ++i) {
                str = str + (String)this.getRadioButtonTable().getModel().getValueAt(i, 4) + ",";
                for (int j = 0; j < this.getRadioButtonTable().getModel().getColumnCount() - 1; ++j) {
                    if (!((Boolean)this.getRadioButtonTable().getModel().getValueAt(i, j)).booleanValue()) continue;
                    str = str + DissolveAlgorithm.Summary[j] + ",";
                }
                str = str.substring(0, str.length() - 1) + ";";
            }
        }
        catch (NotInitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return str.equals("") ? str : str.substring(0, str.length() - 1);
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layersCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    public List<String> getFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        return Arrays.asList(layer.getFieldNames());
    }
}

