/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circlecr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class CircleCDEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter center;
    protected EditingServiceParameter diameter;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;

    public CircleCDEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.center = new DefaultEditingServiceParameter("center", "center", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.diameter = new DefaultEditingServiceParameter("diameter", "diameter", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
    }

    public DefaultDrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        if (this.values != null && this.values.get(this.center) != null && this.values.get(this.diameter) == null) {
            Point centerPoint = (Point)this.values.get(this.center);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Point oppositePosition = GeometryUtils.createPoint((double)(centerPoint.getX() - (mousePosition.getX() - centerPoint.getX())), (double)(centerPoint.getY() - (mousePosition.getY() - centerPoint.getY())));
                Line line = editingProviderServices.createLine(oppositePosition, mousePosition, subtype);
                Circle circle = editingProviderServices.createCircle(centerPoint, mousePosition.distance((Geometry)centerPoint), subtype);
                geometries.addStatus((Geometry)centerPoint, auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)circle, polygonSymbolEditing, "");
                geometries.addStatus((Geometry)circle, previewSymbol, "");
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
            return geometries;
        }
        return null;
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.center) == null) {
            return this.center;
        }
        if (this.values.get(this.diameter) == null) {
            return this.diameter;
        }
        return null;
    }

    public void stop() {
        this.values.clear();
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.center) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.diameter) {
            if (value instanceof Point) {
                Double radiusValue = null;
                try {
                    radiusValue = ((Point)value).distance((Geometry)((Point)this.values.get(this.center)));
                }
                catch (Exception e) {
                    throw new InvalidEntryException((Throwable)e);
                }
                if (radiusValue != null) {
                    this.values.put(param, radiusValue * 2.0);
                    return;
                }
            } else if (value instanceof Double && (Double)value - 0.01 > 0.0) {
                this.values.put(param, value);
                return;
            }
        }
        throw new InvalidEntryException(null);
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.center);
        list.add(this.diameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public Geometry finish() throws FinishServiceException {
        Point centerPoint = (Point)this.values.get(this.center);
        double diameterValue = (Double)this.values.get(this.diameter);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            Circle circle = editingProviderServices.createCircle(centerPoint, diameterValue / 2.0, subtype);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circle);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-circle-cd";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

