/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.handler.Handler;
import org.gvsig.fmap.geom.jts.aggregate.AbstractAggregate;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Primitive;

public abstract class AbstractMultiPrimitive
extends AbstractAggregate
implements MultiPrimitive {
    private static final long serialVersionUID = -5993428771359742467L;

    public AbstractMultiPrimitive(int type, int subtype) {
        super(type, subtype);
    }

    public void addPrimitive(Primitive primitive) {
        Geometry geom = this.fixPrimitive(primitive);
        if (geom != null) {
            if (geom instanceof MultiPrimitive) {
                for (int i = 0; i < ((MultiPrimitive)geom).getPrimitivesNumber(); ++i) {
                    this.addPrimitive(((MultiPrimitive)geom).getPrimitiveAt(i));
                }
            } else {
                this.primitives.add((Primitive)geom);
            }
        }
    }

    public void addPrimitives(Aggregate aggregate) {
        for (Geometry primitive : aggregate) {
            this.addPrimitive((Primitive)primitive);
        }
    }

    public void addPrimitives(Complex complex) {
        for (Geometry primitive : complex) {
            if (!GeometryUtils.isSubtype((int)this.getType(), (int)primitive.getType())) continue;
            this.addPrimitive((Primitive)primitive);
        }
    }

    public void addPrimitives(Geometry geometry) {
        if (geometry instanceof Primitive) {
            this.addPrimitive((Primitive)geometry);
        } else if (geometry instanceof Complex) {
            this.addPrimitives((Complex)geometry);
        } else {
            this.addPrimitives((Aggregate)geometry);
        }
    }

    protected abstract Geometry fixPrimitive(Primitive var1);

    protected Geometry clonePrimitives(AbstractMultiPrimitive clone) {
        clone.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            clone.addPrimitive((Primitive)primitive.cloneGeometry());
        }
        return clone;
    }

    public Handler[] getHandlers(int type) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (Primitive primitive : this.primitives) {
            Handler[] primitiveHandlers = primitive.getHandlers(type);
            for (int i = 0; i < primitiveHandlers.length; ++i) {
                handlers.add(primitiveHandlers[i]);
            }
        }
        return handlers.toArray(new Handler[handlers.size()]);
    }

    public Geometry union() throws GeometryOperationException, GeometryOperationNotSupportedException {
        try {
            Primitive result = null;
            MultiPrimitive invalidResult = null;
            for (Primitive primitive : this.primitives) {
                if (primitive.isValid()) {
                    if (result == null) {
                        result = primitive;
                        continue;
                    }
                    result = result.union((Geometry)primitive);
                    continue;
                }
                if (invalidResult == null) {
                    GeometryManager geomManager = GeometryLocator.getGeometryManager();
                    invalidResult = geomManager.createMultiPrimitive(primitive.getGeometryType());
                }
                invalidResult.addPrimitive(primitive);
            }
            if (invalidResult == null) {
                return result;
            }
            invalidResult.addPrimitives(result);
            return invalidResult;
        }
        catch (CreateGeometryException ex) {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            throw new GeometryOperationException(this.getGeometryType().getType(), geomManager.getGeometryOperationCode("Union"), (Exception)((Object)ex));
        }
    }

    public Geometry intersection() throws GeometryOperationException, GeometryOperationNotSupportedException {
        Primitive result = null;
        for (Primitive primitive : this.primitives) {
            if (result == null) {
                result = primitive;
                continue;
            }
            result.intersection((Geometry)primitive);
        }
        return result;
    }
}

