/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPrimitive;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SurfaceSplitOperation;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;

public abstract class AbstractMultiSurface
extends AbstractMultiPrimitive
implements MultiSurface {
    private static final long serialVersionUID = 5487551987271993628L;

    public AbstractMultiSurface(int type, int subtype) {
        super(type, subtype);
    }

    public AbstractMultiSurface(int subtype) {
        super(9, subtype);
    }

    public Surface getSurfaceAt(int index) {
        return (Surface)this.getPrimitiveAt(index);
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return new DefaultGeneralPathX(this.getPathIterator(affineTransform), false, 0.0);
    }

    @Override
    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        MultiSurfaceIterator pi = new MultiSurfaceIterator(at);
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public Geometry split(Geometry splitter) {
        SurfaceSplitOperation op = new SurfaceSplitOperation();
        return op.split(this, splitter);
    }

    protected class MultiSurfaceIterator
    extends GeneralPathXIterator {
        private AffineTransform at;
        private boolean done;
        private int index;
        private List<PathIterator> iterators;

        public MultiSurfaceIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            this.iterators = new ArrayList<PathIterator>(AbstractMultiSurface.this.primitives.size());
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            for (Primitive primitive : AbstractMultiSurface.this.primitives) {
                if (primitive.isEmpty()) continue;
                this.iterators.add(primitive.getPathIterator(at));
            }
            this.done = this.iterators.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            PathIterator pathIteratorPrimitive = this.iterators.get(this.index);
            pathIteratorPrimitive.next();
            if (pathIteratorPrimitive.isDone()) {
                ++this.index;
                this.done = this.index == AbstractMultiSurface.this.primitives.size();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }
    }
}

