/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiLine;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;

public class MultiLine2D
extends AbstractMultiLine {
    private static final long serialVersionUID = 13422301639354098L;

    public MultiLine2D() {
        super(0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        for (Line2D line : this.primitives) {
            MultiPoint points = line.toPoints();
            multiPoint.ensureCapacity(multiPoint.getPrimitivesNumber() + points.getPrimitivesNumber());
            for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(points.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        return this;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        for (Line2D line : this.primitives) {
            MultiPolygon polygons = line.toPolygons();
            multiPolygon.ensureCapacity(multiPolygon.getPrimitivesNumber() + polygons.getPrimitivesNumber());
            for (int i = 0; i < polygons.getPrimitivesNumber(); ++i) {
                multiPolygon.addSurface((Surface)((Polygon)polygons.getPrimitiveAt(i)));
            }
        }
        return multiPolygon;
    }

    public Geometry cloneGeometry() {
        MultiLine2D clone = new MultiLine2D();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 2;
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Line2D) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 0) {
            try {
                return primitive.toLines();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to lines";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 2D primitives can be fixed to MultiLine2D";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2D result = new MultiLine2D();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2D result = new MultiLine2D();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(joinStyle, distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(joinStyle, distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }
}

