/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPoint2DM
extends AbstractMultiPoint {
    private static final long serialVersionUID = -2230359991187613190L;

    public MultiPoint2DM() {
        super(2);
    }

    public Geometry cloneGeometry() {
        MultiPoint2DM clone = new MultiPoint2DM();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 3;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new AbstractMultiPoint.PointIterator(null), false, 0.0);
    }

    public MultiPoint toPoints() throws GeometryException {
        return this;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2DM multiLine = new MultiLine2DM();
        Line2DM line = new Line2DM();
        line.ensureCapacity(this.primitives.size());
        for (Point2DM point : this.primitives) {
            line.addVertex(point);
        }
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        Polygon2DM polygon = new Polygon2DM();
        polygon.ensureCapacity(this.primitives.size());
        for (Point2DM point : this.primitives) {
            polygon.addVertex(point);
        }
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Point2DM) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 2) {
            try {
                return primitive.toPoints();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to lines";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 2DM primitives can be fixed to MultiPoint2DM";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2DM) {
            return point;
        }
        return new Point2DM(point.getX(), point.getY(), 0.0);
    }
}

