/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.json;

import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.util.IsApplicable;

public class GeometryJsonSerializer
implements JsonManager.JsonSerializer,
IsApplicable {
    public Class getObjectClass() {
        return Geometry.class;
    }

    public Object toObject(JsonObject json) {
        try {
            String wkt = json.getString("wkt");
            Geometry geom = GeometryLocator.getGeometryManager().createFrom(wkt);
            return geom;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't retrieve a Geometry from JsonObject.", ex);
        }
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class(Geometry.class);
        this.addAll(builder, value);
        return builder;
    }

    private void addAll(JsonObjectBuilder target, Object source) {
        Geometry geom = (Geometry)source;
        target.add("wkt", geom.convertToWKTQuietly());
    }

    public boolean isApplicable(Object ... args) {
        if (args[0] instanceof Geometry) {
            return true;
        }
        if (!(args[0] instanceof JsonObject)) {
            return false;
        }
        JsonObject json = (JsonObject)args[0];
        String className = json.getString("__classname__", null);
        return StringUtils.equalsIgnoreCase((CharSequence)className, (CharSequence)Geometry.class.getName());
    }
}

