/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.EnvelopeNotInitializedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultEnvelope
implements Envelope,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEnvelope.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "Envelope";
    protected static final String LOWERCORNER_FIELD = "lowerCorner";
    protected static final String UPPERCORNER_FIELD = "upperCorner";
    protected Point min;
    protected Point max;
    protected boolean isEmpty;
    protected IProjection projection;
    private Polygon jtsGeom = null;
    protected static GeometryManager manager = GeometryLocator.getGeometryManager();

    public DefaultEnvelope() {
        this.isEmpty = true;
    }

    public DefaultEnvelope(IProjection projection) {
        this();
        this.projection = projection;
    }

    public DefaultEnvelope(Point min, Point max, IProjection projection) {
        this.min = min;
        this.max = max;
        this.isEmpty = false;
        this.projection = projection;
    }

    public String toString() {
        if (this.isEmpty) {
            return "POLYGON()";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("POLYGON ((");
        builder.append(this.min.getX());
        builder.append(" ");
        builder.append(this.min.getY());
        builder.append(", ");
        builder.append(this.min.getX());
        builder.append(" ");
        builder.append(this.max.getY());
        builder.append(", ");
        builder.append(this.max.getX());
        builder.append(" ");
        builder.append(this.max.getY());
        builder.append(", ");
        builder.append(this.max.getX());
        builder.append(" ");
        builder.append(this.min.getY());
        builder.append(", ");
        builder.append(this.min.getX());
        builder.append(" ");
        builder.append(this.min.getY());
        builder.append("))");
        return builder.toString();
    }

    public double getCenter(int dimension) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        return (this.min.getCoordinateAt(dimension) + this.max.getCoordinateAt(dimension)) * 0.5;
    }

    public double getLength(int dimension) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        if (this.max.getCoordinateAt(dimension) > this.min.getCoordinateAt(dimension)) {
            return this.max.getCoordinateAt(dimension) - this.min.getCoordinateAt(dimension);
        }
        return this.min.getCoordinateAt(dimension) - this.max.getCoordinateAt(dimension);
    }

    public Point getLowerCorner() {
        return this.min;
    }

    public double getMaximum(int dimension) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        return this.max.getCoordinateAt(dimension);
    }

    public double getMinimum(int dimension) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        return this.min.getCoordinateAt(dimension);
    }

    public Point getUpperCorner() {
        return this.max;
    }

    public Geometry getGeometry() {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        try {
            if (this.min.getX() == this.max.getX() && this.min.getY() == this.max.getY()) {
                Point point = this.min.clone();
                point.setProjection(this.projection);
                return point;
            }
            if (this.min.getX() == this.max.getX() || this.min.getY() == this.max.getY()) {
                Line line = manager.createLine(0);
                line.addVertex(this.min.clone());
                line.addVertex(this.max.clone());
                line.setProjection(this.projection);
                return line;
            }
            org.gvsig.fmap.geom.primitive.Polygon polygon = manager.createPolygon(0);
            polygon.addVertex(this.min.clone());
            polygon.addVertex(manager.createPoint(this.getMaximum(0), this.getMinimum(1), 0));
            polygon.addVertex(this.max.clone());
            polygon.addVertex(manager.createPoint(this.getMinimum(0), this.getMaximum(1), 0));
            polygon.addVertex(this.min.clone());
            polygon.setProjection(this.projection);
            return polygon;
        }
        catch (Exception e) {
            LOG.warn("Error creting the geometry from envelope", (Throwable)e);
            return null;
        }
    }

    public Geometry getBox2D() {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        try {
            org.gvsig.fmap.geom.primitive.Polygon polygon = manager.createPolygon(0);
            polygon.addVertex(this.min.clone());
            polygon.addVertex(manager.createPoint(this.getMaximum(0), this.getMinimum(1), 0));
            polygon.addVertex(this.max.clone());
            polygon.addVertex(manager.createPoint(this.getMinimum(0), this.getMaximum(1), 0));
            polygon.addVertex(this.min.clone());
            polygon.setProjection(this.projection);
            return polygon;
        }
        catch (Exception e) {
            LOG.warn("Error creting the geometry from envelope", (Throwable)e);
            return null;
        }
    }

    public boolean contains(Envelope envelope) {
        if (this.isEmpty) {
            return false;
        }
        if (envelope == null || envelope.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            if (!(this.getMinimum(i) > envelope.getMinimum(i)) && !(this.getMaximum(i) < envelope.getMaximum(i))) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(Envelope envelope) {
        if (this.isEmpty) {
            return false;
        }
        if (envelope == null || envelope.isEmpty()) {
            return false;
        }
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (this.getMinimum(i) > envelope.getMaximum(i)) {
                return false;
            }
            if (!(this.getMaximum(i) < envelope.getMinimum(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other != null && !(other instanceof Envelope)) {
            return false;
        }
        Envelope otherEnv = (Envelope)other;
        if (this.isEmpty && otherEnv.isEmpty()) {
            return true;
        }
        if (otherEnv.getDimension() != this.getDimension()) {
            return false;
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            if (otherEnv.getMinimum(i) != this.getMinimum(i)) {
                return false;
            }
            if (otherEnv.getMaximum(i) == this.getMaximum(i)) continue;
            return false;
        }
        return true;
    }

    public void setLowerCorner(Point lowerCorner) {
        this.min = lowerCorner;
        if (this.max != null) {
            this.isEmpty = false;
        }
        this.min.setProjectionIffNull(this.projection);
        this.jtsGeom = null;
    }

    public void setUpperCorner(Point upperCorner) {
        this.max = upperCorner;
        if (this.min != null) {
            this.isEmpty = false;
        }
        this.max.setProjectionIffNull(this.projection);
        this.jtsGeom = null;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultEnvelope.class, PERSISTENCE_DEFINITION_NAME, "DefaultEnvelope persistence definition", null, null);
            definition.addDynFieldObject(LOWERCORNER_FIELD).setClassOfValue(Point.class).setMandatory(true);
            definition.addDynFieldObject(UPPERCORNER_FIELD).setClassOfValue(Point.class).setMandatory(true);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setLowerCorner((Point)state.get(LOWERCORNER_FIELD));
        this.setUpperCorner((Point)state.get(UPPERCORNER_FIELD));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(LOWERCORNER_FIELD, (Object)this.min);
        state.set(UPPERCORNER_FIELD, (Object)this.max);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultEnvelope other = (DefaultEnvelope)super.clone();
        other.setProjection(this.getProjection());
        if (!this.isEmpty) {
            other.max = this.max.cloneGeometry();
            other.min = this.min.cloneGeometry();
        }
        return other;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void add(Geometry geometry) {
        if (geometry == null) {
            return;
        }
        this.add(geometry.getEnvelope());
    }

    public void clear() {
        this.isEmpty = true;
    }

    public boolean intersects(Geometry geometry) {
        if (geometry instanceof GeometryJTS) {
            return this.getJTS().intersects(((GeometryJTS)geometry).getJTS());
        }
        return false;
    }

    public void centerTo(Point p) {
        try {
            Point loweCorner = manager.createPoint(p.getX() - this.getLength(0) / 2.0, p.getY() - this.getLength(1) / 2.0, 0);
            Point upperCorner = manager.createPoint(p.getX() + this.getLength(0) / 2.0, p.getY() + this.getLength(1) / 2.0, 0);
            this.setLowerCorner(loweCorner);
            this.setUpperCorner(upperCorner);
        }
        catch (CreateGeometryException e) {
            LOG.error("Error creating corners to center the envelope", (Throwable)e);
        }
    }

    private com.vividsolutions.jts.geom.Geometry getJTS() {
        if (this.jtsGeom == null) {
            ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
            coordinates.add(new Coordinate(this.min.getX(), this.min.getY()));
            coordinates.add(new Coordinate(this.getMaximum(0), this.getMinimum(1)));
            coordinates.add(new Coordinate(this.max.getX(), this.max.getY()));
            coordinates.add(new Coordinate(this.getMinimum(0), this.getMaximum(1)));
            coordinates.add(new Coordinate(this.min.getX(), this.min.getY()));
            this.jtsGeom = JTSUtils.createJTSPolygon(this.getProjection(), coordinates);
        }
        return this.jtsGeom;
    }

    public IProjection getProjection() {
        return this.projection;
    }

    public void setProjectionIffNull(IProjection projection) {
        if (this.projection == null) {
            this.projection = projection;
        }
    }

    public void setProjection(IProjection projection) {
        this.projection = projection;
    }

    public boolean isCollapsed() {
        switch (this.getDimension()) {
            case 3: {
                return this.isCollapsed(1);
            }
        }
        return this.isCollapsed(0);
    }

    public boolean isCollapsed(int subtype) {
        if (this.isEmpty) {
            return true;
        }
        switch (subtype) {
            case 3: {
                int m = this.getDimension() - 1;
                if (this.getLength(m) != 0.0) {
                    return false;
                }
            }
            case 1: 
            case 2: {
                if (this.getLength(2) == 0.0) break;
                return false;
            }
        }
        if (this.getLength(0) != 0.0) {
            return false;
        }
        return this.getLength(1) == 0.0;
    }

    public boolean hasZ() {
        return false;
    }

    public boolean hasM() {
        return false;
    }
}

