/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;

public class Line3D
extends BaseLine3D
implements Line {
    private static final long serialVersionUID = -3687720909186456046L;

    public Line3D() {
        super(18);
    }

    public Line3D(Coordinate[] coordinates) {
        super(18, coordinates);
    }

    public Line3D(ArrayListCoordinateSequence coordinates) {
        super(18, coordinates);
    }

    public Line cloneGeometry() {
        Line3D clone = new Line3D(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Line clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), this.coordinates, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed(0.0)) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, joinStyle, distance);
        }
        return JTSUtils.offsetOpenLine(this.getProjection(), this.coordinates, joinStyle, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Line3D) {
            Line3D other = (Line3D)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) == coordinate.getOrdinate(2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Line c = this.cloneGeometry();
        return c;
    }
}

