/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.AbstractSpline;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseSpline2D
extends AbstractSpline {
    private static final long serialVersionUID = -8257006501866486625L;

    public BaseSpline2D(int type) {
        super(type, 0);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseSpline2D(int type, Coordinate[] coordinates) {
        super(type, 0);
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
        this.anyVertex = coordinates.length < 1 ? new Point2D(0.0, 0.0) : new Point2D(coordinates[0].x, coordinates[0].y);
    }

    public BaseSpline2D(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 0);
        this.coordinates = coordinates;
        this.anyVertex = this.coordinates.isEmpty() ? new Point2D(0.0, 0.0) : new Point2D(coordinates.getX(0), coordinates.getY(0));
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point2D(x, y));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Can't add x,y,z coordinate to SPLine2D.";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected ArrayListCoordinateSequence getSplineCoordinates() {
        ArrayListCoordinateSequence splineCoordinates = new ArrayListCoordinateSequence();
        int num = this.coordinates.size();
        double[] px = new double[num];
        double[] py = new double[num];
        for (int i = 0; i < num; ++i) {
            Coordinate coord = (Coordinate)this.coordinates.get(i);
            px[i] = coord.x;
            py[i] = coord.y;
        }
        AbstractSpline.Spline splineX = new AbstractSpline.Spline(px);
        AbstractSpline.Spline splineY = new AbstractSpline.Spline(py);
        splineCoordinates.add(this.coordinates.get(0));
        for (int i = 0; i < this.coordinates.size() - 1; ++i) {
            int t = 1;
            while ((double)t <= 30.0) {
                if ((double)t == 30.0 && i == this.coordinates.size() - 2) {
                    splineCoordinates.add(new Coordinate(px[px.length - 1], py[px.length - 1]));
                } else {
                    double x1 = splineX.fn(i, (double)t / 30.0);
                    double y1 = splineY.fn(i, (double)t / 30.0);
                    splineCoordinates.add(new Coordinate(x1, y1));
                }
                ++t;
            }
        }
        return splineCoordinates;
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2D) {
            return point;
        }
        return new Point2D(point.getX(), point.getY());
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        Coordinate[] theCoordinates = this.getSplineCoordinates().toCoordinateArray();
        multiPoint.ensureCapacity(theCoordinates.length);
        for (Coordinate coordinate : theCoordinates) {
            multiPoint.addPoint(new Point2D(this.getProjection(), coordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        Line2D line = new Line2D(this.getSplineCoordinates().toCoordinateArray());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        Polygon2D polygon = new Polygon2D(this.getSplineCoordinates().toCoordinateArray());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    public Point getVertex(int index) {
        Point2D vertex = new Point2D(this.getProjection(), (Coordinate)this.coordinates.get(index));
        this.anyVertex = vertex;
        return vertex;
    }
}

