/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.ring;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.GeometryJTS2;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Ring;

public class Ring2D
extends BaseLine2D
implements Ring,
GeometryJTS2 {
    private static final long serialVersionUID = 6640426694359410404L;

    public Ring2D() {
        super(20);
    }

    public Ring2D(Coordinate[] coordinates) {
        super(20, coordinates);
    }

    public Ring2D(ArrayListCoordinateSequence coordinates) {
        super(20, coordinates);
    }

    public Geometry cloneGeometry() {
        Ring2D clone = new Ring2D(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public MultiLine toLines() throws GeometryException {
        MultiLine2D multiLine = new MultiLine2D();
        multiLine.addPrimitive(new Line2D(this.coordinates.toCoordinateArray()));
        return multiLine;
    }

    @Override
    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2D multiPolygon = new MultiPolygon2D();
        multiPolygon.addPrimitive(new Polygon2D(this.coordinates.toCoordinateArray()));
        return multiPolygon;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        this.closePrimitive();
        return JTSUtils.createJTSLinearRing(this.getProjection(), this.coordinates);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters();
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring2D(coords);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        LinearRing jtsRing = (LinearRing)this.getJTS();
        GeometryFactory factory = jtsRing.getFactory();
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(factory.getPrecisionModel(), bufParams);
        Coordinate[] coordinates = jtsRing.getCoordinates();
        Coordinate[] coords = ocb.getRingCurve(coordinates, 1, distance);
        return new Ring2D(coords);
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        if (this.coordinates.size() >= 2 && !this.isClosed(0.0)) {
            this.forceClose(0.0);
        }
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Ring2D ring = new Ring2D(coordinates2D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, 0.0));
        }
        Ring2DM ring = new Ring2DM(coordinates2DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, 0.0));
        }
        Ring3D ring = new Ring3D(coordinates3D);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, 0.0, 0.0));
        }
        Ring3DM ring = new Ring3DM(coordinates3DM);
        ring.setProjection(this.getProjection());
        return ring;
    }

    @Override
    public org.locationtech.jts.geom.Geometry getJTS2() {
        this.closePrimitive();
        return JTSUtils2.createJTSLinearRing(this.getProjection(), this.coordinates);
    }
}

