/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.BaseCircle2DZ;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;

public class Circle2DZ
extends BaseCircle2DZ
implements Circle {
    private static final long serialVersionUID = 4678092839213094025L;

    public Circle2DZ() {
        super(11, 1);
    }

    public Circle2DZ(Point center, double radius) {
        super(11, 1, center, radius);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        ArrayListCoordinateSequence coordinates = this.getJTSCoordinates();
        return JTSUtils.createJTSPolygon(this.getProjection(), coordinates);
    }

    public Geometry cloneGeometry() {
        Circle2DZ clone = new Circle2DZ();
        clone.setPoints((Point)((PointJTS)((PointJTS)this.center).cloneGeometry()), this.radius);
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Point getRectangleCorner() {
        return new Point3D(this.center.getX() - this.radius, this.center.getY() - this.radius, ((Point3D)this.center).getZ());
    }

    public double getRectangleHeight() {
        return this.radius * 2.0;
    }

    public double getRectangleWidth() {
        return this.radius * 2.0;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return new Circle2DZ((PointJTS)((PointJTS)this.center).cloneGeometry(), this.radius + distance);
    }
}

