/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;

final class SplitEdge
extends Edge {
    SplitEdge(Coordinate[] pts, Label label) {
        super(pts, label);
    }

    private int[] getLabelLocations() {
        int[] locations = new int[3];
        Label lbl = this.getLabel();
        locations[0] = lbl.getLocation(0, 0);
        locations[1] = lbl.getLocation(0, 1);
        locations[2] = lbl.getLocation(0, 2);
        return locations;
    }

    public boolean isShellEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 2 && loc[2] == 0;
    }

    public boolean isHoleEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 0 && loc[2] == 2;
    }

    public boolean isInteriorEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 0 && loc[2] == 0;
    }

    public String toString() {
        Coordinate[] coords;
        StringBuilder sb = new StringBuilder("Edge[label=");
        sb.append(this.getLabel()).append(", ");
        for (Coordinate coord : coords = this.getCoordinates()) {
            sb.append(coord.x).append(",").append(coord.y).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

