/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPrimitive;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.complex.DefaultComplex;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinateSequence;
import org.gvsig.fmap.geom.jts.mgeom.MGeometryFactory;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils2;
import org.gvsig.fmap.geom.jts.util.OpenJUMPUtils;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.future.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTSUtils {
    public static final Logger logger = LoggerFactory.getLogger(JTSUtils.class);
    private static final GeometryFactory factory = new GeometryFactory();
    private static final GeometryFactory mfactory = new MyMGeometryFactory();

    public static Point createPoint(GeometryType type, IProjection proj, Coordinate coordinate) throws CreateGeometryException {
        Point p;
        switch (type.getSubType()) {
            case 0: {
                p = new Point2D(proj, coordinate);
                break;
            }
            case 2: {
                p = new Point2DM(proj, coordinate);
                break;
            }
            case 1: {
                p = new Point3D(proj, coordinate);
                break;
            }
            case 3: {
                p = new Point3DM(proj, coordinate);
                break;
            }
            default: {
                p = (Point)type.create();
                for (int i = 0; i < p.getDimension(); ++i) {
                    p.setCoordinateAt(i, coordinate.getOrdinate(i));
                }
                p.setProjection(proj);
            }
        }
        return p;
    }

    public static GeometryFactory getFactory(CoordinateSequence coordinates) {
        GeometryFactory theFactory = factory;
        if (coordinates.size() > 0 && coordinates.getCoordinate(0) instanceof MCoordinate) {
            theFactory = mfactory;
        }
        return theFactory;
    }

    public static GeometryFactory getFactory(Coordinate coordinate) {
        GeometryFactory theFactory = factory;
        if (coordinate instanceof MCoordinate) {
            theFactory = mfactory;
        }
        return theFactory;
    }

    public static GeometryFactory getFactory(Coordinate[] coordinates) {
        GeometryFactory theFactory = factory;
        if (coordinates.length > 0 && coordinates[0] instanceof MCoordinate) {
            theFactory = mfactory;
        }
        return theFactory;
    }

    public static LineString createJTSLineString(IProjection proj, CoordinateSequence coordinates) {
        return (LineString)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.getFactory(coordinates).createLineString(coordinates));
    }

    public static LinearRing createJTSLinearRing(IProjection proj, CoordinateSequence coordinates) {
        GeometryFactory fact = JTSUtils.getFactory(coordinates);
        return (LinearRing)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)fact.createLinearRing(CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)fact.getCoordinateSequenceFactory(), (CoordinateSequence)coordinates)));
    }

    public static LinearRing createJTSLinearRing(IProjection proj, Coordinate[] coordinates) {
        GeometryFactory fact = JTSUtils.getFactory(coordinates);
        CoordinateSequenceFactory coordinateSequenceFactory = fact.getCoordinateSequenceFactory();
        return (LinearRing)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)fact.createLinearRing(CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)coordinateSequenceFactory, (CoordinateSequence)coordinateSequenceFactory.create(coordinates))));
    }

    public static MultiPoint createJTSMultiPoint(IProjection proj, CoordinateSequence coordinates) {
        return (MultiPoint)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.getFactory(coordinates).createMultiPoint(coordinates));
    }

    public static Geometry createGeometry(IProjection proj, com.vividsolutions.jts.geom.Geometry jtsGeom) {
        return JTSUtils.createGeometry(proj, jtsGeom, null);
    }

    public static Geometry createGeometry(IProjection proj, com.vividsolutions.jts.geom.Geometry jtsGeom, GeometryType typeWhenEmpty) {
        Coordinate coordinate;
        if (jtsGeom.isEmpty()) {
            if (typeWhenEmpty == null) {
                return null;
            }
            try {
                return typeWhenEmpty.create();
            }
            catch (CreateGeometryException ex) {
                return null;
            }
        }
        try {
            int srsid;
            if (proj == null && (srsid = jtsGeom.getSRID()) > 0) {
                proj = CRSFactory.getCRS((String)("EPSG:" + srsid));
            }
        }
        catch (Throwable th) {
            logger.debug("Can't retrieve srs from jts geometry", th);
        }
        if (jtsGeom instanceof com.vividsolutions.jts.geom.Point) {
            Coordinate coordinate2 = jtsGeom.getCoordinate();
            if (jtsGeom.getFactory() instanceof MyMGeometryFactory) {
                if (Double.isNaN(coordinate2.z)) {
                    return new Point2DM(proj, coordinate2);
                }
                return new Point3DM(proj, coordinate2);
            }
            if (Double.isNaN(coordinate2.z)) {
                return new Point2D(proj, coordinate2);
            }
            return new Point3D(proj, coordinate2);
        }
        if (jtsGeom instanceof LineString) {
            Coordinate[] coordinates = jtsGeom.getCoordinates();
            coordinate = jtsGeom.getCoordinate();
            LineString lineString = (LineString)jtsGeom;
            if (!lineString.isEmpty()) {
                AbstractLine line = jtsGeom.getFactory() instanceof MGeometryFactory ? (coordinate != null && Double.isNaN(coordinate.z) ? new Line2DM(coordinates) : new Line3DM(coordinates)) : (coordinate != null && Double.isNaN(coordinate.z) ? new Line2D(coordinates) : new Line3D(coordinates));
                line.setProjection(proj);
                return line;
            }
        }
        if (jtsGeom instanceof Polygon && !jtsGeom.isEmpty()) {
            Polygon polygonJTS = (Polygon)jtsGeom;
            Coordinate[] coordinates = polygonJTS.getExteriorRing().getCoordinates();
            Coordinate coordinate3 = jtsGeom.getCoordinate();
            AbstractLine polygon = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate3.z) ? new Polygon2DM(coordinates) : new Polygon3DM(coordinates)) : (Double.isNaN(coordinate3.z) ? new Polygon2D(coordinates) : new Polygon3D(coordinates));
            polygon.setProjection(proj);
            for (int i = 0; i < polygonJTS.getNumInteriorRing(); ++i) {
                LineString ringJTS = polygonJTS.getInteriorRingN(i);
                coordinates = ringJTS.getCoordinates();
                coordinate3 = ringJTS.getCoordinate();
                AbstractLine ring = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate3.z) ? new Ring2DM(coordinates) : new Ring3DM(coordinates)) : (Double.isNaN(coordinate3.z) ? new Ring2D(coordinates) : new Ring3D(coordinates));
                ring.setProjection(proj);
                polygon.addInteriorRing((Ring)ring);
            }
            return polygon;
        }
        if (jtsGeom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)jtsGeom;
            coordinate = collection.getCoordinate();
            AbstractMultiPrimitive multiprimitive = null;
            if (jtsGeom instanceof MultiLineString) {
                multiprimitive = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate.z) ? new MultiLine2DM() : new MultiLine3DM()) : (Double.isNaN(coordinate.z) ? new MultiLine2D() : new MultiLine3D());
            } else if (jtsGeom instanceof MultiPolygon) {
                multiprimitive = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate.z) ? new MultiPolygon2DM() : new MultiPolygon3DM()) : (Double.isNaN(coordinate.z) ? new MultiPolygon2D() : new MultiPolygon3D());
            } else if (jtsGeom instanceof MultiPoint) {
                multiprimitive = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate.z) ? new MultiPoint2DM() : new MultiPoint3DM()) : (Double.isNaN(coordinate.z) ? new MultiPoint2D() : new MultiPoint3D());
            }
            if (multiprimitive != null) {
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    com.vividsolutions.jts.geom.Geometry geometry = collection.getGeometryN(i);
                    multiprimitive.addPrimitive((Primitive)JTSUtils.createGeometry(proj, geometry));
                }
                multiprimitive.setProjection(proj);
                return multiprimitive;
            }
            int subtype = jtsGeom.getFactory() instanceof MyMGeometryFactory ? (Double.isNaN(coordinate.z) ? 2 : 3) : (Double.isNaN(coordinate.z) ? 0 : 1);
            DefaultComplex complex = new DefaultComplex(subtype);
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                com.vividsolutions.jts.geom.Geometry geometry = collection.getGeometryN(i);
                complex.addPrimitive((Primitive)JTSUtils.createGeometry(proj, geometry));
            }
            complex.setProjection(proj);
            return complex;
        }
        return null;
    }

    public static com.vividsolutions.jts.geom.Geometry convertTypes(com.vividsolutions.jts.geom.Geometry g, int sourceType, int destinationType) {
        GeometryFactory theFactory = g.getFactory();
        if ((sourceType == 2 || sourceType == 14 || sourceType == 12 || sourceType == 15 || sourceType == 23 || sourceType == 24) && destinationType == 9) {
            if (g instanceof MultiLineString) {
                Polygon[] poly = new Polygon[((MultiLineString)g).getNumGeometries()];
                for (int i = 0; i < ((MultiLineString)g).getNumGeometries(); ++i) {
                    com.vividsolutions.jts.geom.Geometry lineString = ((MultiLineString)g).getGeometryN(i);
                    poly[i] = JTSUtils.convertLineStringToPolygon((LineString)lineString);
                }
                return theFactory.createMultiPolygon(poly);
            }
            return JTSUtils.convertLineStringToPolygon((LineString)g);
        }
        if ((sourceType == 11 || sourceType == 13 || sourceType == 15 || sourceType == 25) && destinationType == 8 && g instanceof Polygon) {
            Polygon poly = (Polygon)g;
            LinearRing lineString = theFactory.createLinearRing(poly.getCoordinates());
            return theFactory.createMultiLineString(new LineString[]{lineString});
        }
        return g;
    }

    private static Polygon convertLineStringToPolygon(LineString line) {
        Coordinate[] coordinates = line.getCoordinates();
        GeometryFactory theFactory = line.getFactory();
        LinearRing shell = theFactory.createLinearRing(coordinates);
        Polygon pol = theFactory.createPolygon(shell, null);
        return pol;
    }

    public static MCoordinate createMCoordinate(double x, double y, double m) {
        return MCoordinate.create2dWithMeasure(x, y, m);
    }

    public static MCoordinate createMCoordinate(double x, double y, double z, double m) {
        return MCoordinate.create3dWithMeasure(x, y, z, m);
    }

    public static Coordinate getCircumcentre(Point init, Point middle, Point end) {
        Triangle triangle = new Triangle(((PointJTS)init).getJTSCoordinate(), ((PointJTS)middle).getJTSCoordinate(), ((PointJTS)end).getJTSCoordinate());
        return triangle.circumcentre();
    }

    public static LineString createJTSLineStringFromArcPoints(IProjection proj, Point centre, double radius, double startAngle, double endAngle) {
        GeometricShapeFactory shapeFactory = new GeometricShapeFactory();
        shapeFactory.setCentre(((PointJTS)centre).getJTSCoordinate());
        shapeFactory.setSize(radius * 2.0);
        return (LineString)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)shapeFactory.createArc(startAngle, endAngle));
    }

    public static MultiLineString createJTSMultiLineString(IProjection proj, LineString[] lineStrings) {
        GeometryFactory theFactory = factory;
        if (lineStrings.length > 0) {
            theFactory = lineStrings[0].getFactory();
        }
        return (MultiLineString)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)theFactory.createMultiLineString(lineStrings));
    }

    public static Polygon createJTSPolygon(IProjection proj, ArrayListCoordinateSequence coordinates, List<Ring> interiorRings) {
        GeometryFactory theFactory = JTSUtils.getFactory(coordinates);
        LinearRing shell = theFactory.createLinearRing((CoordinateSequence)coordinates);
        LinearRing[] holes = new LinearRing[interiorRings.size()];
        for (int i = 0; i < interiorRings.size(); ++i) {
            Ring ring = interiorRings.get(i);
            holes[i] = (LinearRing)((GeometryJTS)ring).getJTS();
        }
        return (Polygon)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)theFactory.createPolygon(shell, holes));
    }

    public static Polygon createJTSPolygon(IProjection proj, ArrayListCoordinateSequence coordinates) {
        GeometryFactory theFactory = JTSUtils.getFactory(coordinates);
        LinearRing shell = theFactory.createLinearRing((CoordinateSequence)coordinates);
        return (Polygon)JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)theFactory.createPolygon(shell));
    }

    public static MultiPolygon createJTSMultiPolygon(IProjection proj, Polygon[] polygons) {
        GeometryFactory theFactory = factory;
        if (polygons.length > 0) {
            theFactory = polygons[0].getFactory();
        }
        MultiPolygon g = theFactory.createMultiPolygon(polygons);
        JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)g);
        return g;
    }

    public static com.vividsolutions.jts.geom.Geometry setSRID(IProjection proj, com.vividsolutions.jts.geom.Geometry g) {
        try {
            String x = StringUtils.split((String)proj.getAbrev(), (char)':')[1];
            g.setSRID(Integer.valueOf(x).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return g;
    }

    public static Coordinate getPointAtYAxisInEllipse(Point init, Point end, Double ydist) {
        LineSegment segment = new LineSegment(((PointJTS)init).getJTSCoordinate(), ((PointJTS)end).getJTSCoordinate());
        Coordinate middle = segment.midPoint();
        LineSegment midSegment = new LineSegment(middle, ((PointJTS)end).getJTSCoordinate());
        double modulus = midSegment.getLength();
        Coordinate uni = new Coordinate((end.getX() - middle.x) / modulus, (end.getY() - middle.y) / modulus);
        Coordinate perpUni = new Coordinate(-uni.y, uni.x);
        Coordinate point = new Coordinate(middle.x + perpUni.x * ydist, middle.y + perpUni.y * ydist);
        return point;
    }

    public static Coordinate getMidPoint(Point init, Point end) {
        LineSegment segment = new LineSegment(((PointJTS)init).getJTSCoordinate(), ((PointJTS)end).getJTSCoordinate());
        Coordinate middle = segment.midPoint();
        return middle;
    }

    public static com.vividsolutions.jts.geom.Geometry createJTSPoint(IProjection proj, Coordinate coordinate) {
        return JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.getFactory(coordinate).createPoint(coordinate));
    }

    public static com.vividsolutions.jts.geom.Geometry createJTSPolygon(IProjection proj, Coordinate[] coordinates) {
        return JTSUtils.setSRID(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.getFactory(coordinates).createPolygon(coordinates));
    }

    public static BufferParameters getBufferParameters() {
        BufferParameters bufParams = new BufferParameters();
        bufParams.setSingleSided(true);
        bufParams.setEndCapStyle(2);
        bufParams.setJoinStyle(1);
        return bufParams;
    }

    public static BufferParameters getBufferParameters(int joinStyle, int endCapStyle) {
        BufferParameters bufParams = new BufferParameters();
        bufParams.setSingleSided(true);
        bufParams.setEndCapStyle(endCapStyle);
        bufParams.setJoinStyle(joinStyle);
        bufParams.setQuadrantSegments(JTSUtils.calculateQuadrantSegments(joinStyle));
        return bufParams;
    }

    public static int calculateQuadrantSegments(int joinStyle) throws IllegalArgumentException {
        int quadrantSegments = 8;
        switch (joinStyle) {
            case 1: {
                quadrantSegments = 8;
                break;
            }
            case 2: {
                quadrantSegments = 5;
                break;
            }
            case 3: {
                quadrantSegments = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid jointStyle " + joinStyle);
            }
        }
        return quadrantSegments;
    }

    public static Geometry offsetClosedLine(IProjection proj, ArrayListCoordinateSequence coordinates, double distance) {
        Polygon jtsGeom = JTSUtils.createJTSPolygon(proj, coordinates);
        com.vividsolutions.jts.geom.Geometry geomJTS = jtsGeom.buffer(distance);
        return JTSUtils.jtsPolygonToJtsMultiLineString(geomJTS, proj);
    }

    public static Geometry offsetClosedLine(IProjection proj, ArrayListCoordinateSequence coordinates, int joinStyle, double distance) {
        Polygon jtsGeom = JTSUtils.createJTSPolygon(proj, coordinates);
        com.vividsolutions.jts.geom.Geometry geomJTS = jtsGeom.buffer(distance, JTSUtils.calculateQuadrantSegments(joinStyle), 2);
        return JTSUtils.jtsPolygonToJtsMultiLineString(geomJTS, proj);
    }

    protected static Geometry jtsPolygonToJtsMultiLineString(com.vividsolutions.jts.geom.Geometry geomJTS, IProjection proj) {
        if (geomJTS instanceof Polygon) {
            Polygon polygonJTS = (Polygon)geomJTS;
            LineString shell = polygonJTS.getExteriorRing();
            int numHoles = polygonJTS.getNumInteriorRing();
            if (numHoles > 0) {
                LineString[] lineStrings = new LineString[numHoles + 1];
                lineStrings[0] = shell;
                for (int i = 0; i < numHoles; ++i) {
                    LineString hole;
                    lineStrings[i + 1] = hole = polygonJTS.getInteriorRingN(i);
                }
                return JTSUtils.createGeometry(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.createJTSMultiLineString(proj, lineStrings));
            }
            return JTSUtils.createGeometry(proj, (com.vividsolutions.jts.geom.Geometry)shell);
        }
        if (geomJTS instanceof MultiPolygon) {
            MultiPolygon multiPolygonJTS = (MultiPolygon)geomJTS;
            ArrayList<LineString> lineStringList = new ArrayList<LineString>();
            for (int i = 0; i < multiPolygonJTS.getNumGeometries(); ++i) {
                Polygon polygonJTS = (Polygon)multiPolygonJTS.getGeometryN(i);
                lineStringList.add(polygonJTS.getExteriorRing());
                int numHoles = polygonJTS.getNumInteriorRing();
                if (numHoles <= 0) continue;
                for (int h = 0; h < numHoles; ++h) {
                    LineString hole = polygonJTS.getInteriorRingN(i);
                    lineStringList.add(hole);
                }
            }
            return JTSUtils.createGeometry(proj, (com.vividsolutions.jts.geom.Geometry)JTSUtils.createJTSMultiLineString(proj, lineStringList.toArray(new LineString[lineStringList.size()])));
        }
        logger.warn("offsetClosedLine does not return or Polygon JTS or MultiPolygon JTS");
        return null;
    }

    public static Geometry offsetRawOpenLine(IProjection proj, ArrayListCoordinateSequence coordinates, double distance) {
        GeometryFactory theFactory = JTSUtils.getFactory(coordinates);
        BufferParameters bufParams = JTSUtils.getBufferParameters();
        LineString jtsGeom = JTSUtils.createJTSLineString(proj, coordinates);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(theFactory.getPrecisionModel(), bufParams);
        Coordinate[] coords = ocb.getOffsetCurve(jtsGeom.getCoordinates(), distance);
        CoordinateSequence coordSequence = theFactory.getCoordinateSequenceFactory().create(coords);
        LineString offsetGeom = JTSUtils.createJTSLineString(proj, coordSequence);
        return JTSUtils.createGeometry(proj, (com.vividsolutions.jts.geom.Geometry)offsetGeom);
    }

    public static double straightLineThroughTwoPointsEquation(double x1, double x2, double y1, double y2, double x) {
        if (x2 - x1 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
    }

    public static Point extractPointFromLine(GeometryJTS geom, double len) {
        GeometryType type;
        com.vividsolutions.jts.geom.Geometry jts = geom.getJTS();
        LinearLocation location = LengthLocationMap.getLocation((com.vividsolutions.jts.geom.Geometry)jts, (double)len);
        LineString lineComp = (LineString)jts.getGeometryN(location.getComponentIndex());
        Coordinate coordinate = lineComp.getCoordinateN(location.getSegmentIndex());
        if (location.getSegmentIndex() < lineComp.getNumPoints() - 1) {
            Coordinate p1 = lineComp.getCoordinateN(location.getSegmentIndex() + 1);
            coordinate = JTSUtils.pointAlongSegmentByFraction(coordinate, p1, location.getSegmentFraction());
        }
        if ((type = geom.getGeometryType()).hasZ() && type.hasM()) {
            return new Point3DM(geom.getProjection(), coordinate);
        }
        if (type.hasZ()) {
            return new Point3D(geom.getProjection(), coordinate);
        }
        if (type.hasM()) {
            return new Point2DM(geom.getProjection(), coordinate);
        }
        return new Point2D(geom.getProjection(), coordinate);
    }

    private static Coordinate pointAlongSegmentByFraction(Coordinate p0, Coordinate p1, double frac) {
        if (frac <= 0.0) {
            return p0;
        }
        if (frac >= 1.0) {
            return p1;
        }
        double x = (p1.x - p0.x) * frac + p0.x;
        double y = (p1.y - p0.y) * frac + p0.y;
        double z = (p1.z - p0.z) * frac + p0.z;
        if (p0 instanceof MCoordinate && p1 instanceof MCoordinate) {
            double m = (((MCoordinate)p1).m - ((MCoordinate)p0).m) * frac + ((MCoordinate)p0).m;
            return new MCoordinate(x, y, z, m);
        }
        return new Coordinate(x, y, z);
    }

    public static double getPathLengthFromLine(GeometryJTS geom, Point point) {
        LocationIndexedLine lil = new LocationIndexedLine(geom.getJTS());
        LinearLocation pointLocation = lil.indexOf(((PointJTS)point).getJTSCoordinate());
        LinearLocation startLocation = lil.getStartIndex();
        com.vividsolutions.jts.geom.Geometry geomJTS = lil.extractLine(startLocation, pointLocation);
        return geomJTS.getLength();
    }

    public static Geometry offsetOpenLine(IProjection proj, ArrayListCoordinateSequence coordinates, int joinStyle, double distance) {
        if (FutureUtils.use((String)"USE_JTS2_OFFSET_OPEN_LINE")) {
            return JTSUtils2.offsetOpenLine(proj, coordinates, joinStyle, distance);
        }
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        return OpenJUMPUtils.offsetCleanOpenLine(proj, coordinates, bufParams, distance);
    }

    public static Geometry offsetOpenLine(IProjection proj, ArrayListCoordinateSequence coordinates, double distance) {
        if (FutureUtils.use((String)"USE_JTS2_OFFSET_OPEN_LINE")) {
            return JTSUtils2.offsetOpenLine(proj, coordinates, distance);
        }
        return OpenJUMPUtils.offsetCleanOpenLine(proj, coordinates, distance);
    }

    private static class MyMGeometryFactory
    extends MGeometryFactory {
        private static final long serialVersionUID = -8174926092714691479L;

        private MyMGeometryFactory() {
        }

        public com.vividsolutions.jts.geom.Point createPoint(CoordinateSequence coordinates) {
            if (!(coordinates instanceof MCoordinateSequence) && coordinates != null) {
                coordinates = new MCoordinateSequence(coordinates);
            }
            return new com.vividsolutions.jts.geom.Point(coordinates, (GeometryFactory)this);
        }

        public LinearRing createLinearRing(CoordinateSequence coordinates) {
            if (!(coordinates instanceof MCoordinateSequence) && coordinates != null) {
                coordinates = new MCoordinateSequence(coordinates);
            }
            return super.createLinearRing(coordinates);
        }

        public LineString createLineString(CoordinateSequence coordinates) {
            if (!(coordinates instanceof MCoordinateSequence) && coordinates != null) {
                coordinates = new MCoordinateSequence(coordinates);
            }
            return super.createLineString(coordinates);
        }

        public MultiPoint createMultiPoint(CoordinateSequence coordinates) {
            if (!(coordinates instanceof MCoordinateSequence) && coordinates != null) {
                coordinates = new MCoordinateSequence(coordinates);
            }
            return super.createMultiPoint(coordinates);
        }
    }
}

