/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Curve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilFunctions {
    private static final Logger logger = LoggerFactory.getLogger(GeometryManager.class);

    public static Arc2D createCircle(Point2D p1, Point2D p2, Point2D p3) {
        double w;
        double A2;
        double A1;
        double xm1 = (p1.getX() + p2.getX()) / 2.0;
        double ym1 = (p1.getY() + p2.getY()) / 2.0;
        double xm2 = (p2.getX() + p3.getX()) / 2.0;
        double ym2 = (p2.getY() + p3.getY()) / 2.0;
        double mP1 = 0.0;
        double mP2 = 0.0;
        boolean bPerp1 = false;
        if (p2.getY() - p1.getY() == 0.0) {
            A1 = ym1;
            bPerp1 = true;
        } else {
            mP1 = (p2.getX() - p1.getX()) / (p1.getY() - p2.getY());
            A1 = ym1 - xm1 * mP1;
        }
        if (p2.getY() - p3.getY() == 0.0) {
            A2 = ym2;
        } else {
            mP2 = (p3.getX() - p2.getX()) / (p2.getY() - p3.getY());
            A2 = ym2 - xm2 * mP2;
        }
        if (mP2 == mP1) {
            return null;
        }
        double xC = (A2 - A1) / (mP1 - mP2);
        double yC = !bPerp1 ? xC * mP1 + A1 : xC * mP2 + A2;
        double Radio = p1.distance(xC, yC);
        double xR = xC - Radio;
        double yR = yC - Radio;
        double h = w = 2.0 * Radio;
        Rectangle2D.Double rBounds = new Rectangle2D.Double(xR, yR, w, h);
        Arc2D.Double resul = new Arc2D.Double(rBounds, 0.0, 360.0, 0);
        return resul;
    }

    public static Arc2D createCircle(Point2D center, double radius) {
        double w;
        double xR = center.getX() - radius;
        double yR = center.getY() - radius;
        double h = w = 2.0 * radius;
        Rectangle2D.Double rBounds = new Rectangle2D.Double(xR, yR, w, h);
        Arc2D.Double resul = new Arc2D.Double(rBounds, 0.0, 360.0, 0);
        return resul;
    }

    public static Shape createEllipse(Point2D init, Point2D end, double ydist) {
        double h = ydist * 2.0;
        double w = init.distance(end);
        double x = init.getX();
        double y = init.getY();
        Ellipse2D.Double result = new Ellipse2D.Double(x, y - h / 2.0, w, h);
        return AffineTransform.getRotateInstance(UtilFunctions.getAngle(init, end), x, y).createTransformedShape(result);
    }

    public static Point2D[] getPerpendicular(Point2D p1, Point2D p2, Point2D perp) {
        if (p2.getY() - p1.getY() == 0.0) {
            return new Point2D[]{new Point2D.Double(perp.getX(), 0.0), new Point2D.Double(perp.getX(), 1.0)};
        }
        double m = (p1.getX() - p2.getX()) / (p2.getY() - p1.getY());
        double b = perp.getY() - m * perp.getX();
        Point2D[] res = new Point2D[]{new Point2D.Double(0.0, m * 0.0 + b), new Point2D.Double(1000.0, m * 1000.0 + b)};
        return res;
    }

    public static Point2D[] getParallel(Point2D p1, Point2D p2, double distance) {
        Point2D[] pParallel = new Point2D[]{UtilFunctions.getPerpendicularPoint(p1, p2, p1, distance), UtilFunctions.getPerpendicularPoint(p1, p2, p2, distance)};
        return pParallel;
    }

    public static Point2D getPerpendicularPoint(Point2D p1, Point2D p2, Point2D perpPoint, double dist) {
        Point2D[] p = UtilFunctions.getPerpendicular(p1, p2, perpPoint);
        Point2D unit = UtilFunctions.getUnitVector(p[0], p[1]);
        return new Point2D.Double(perpPoint.getX() + unit.getX() * dist, perpPoint.getY() + unit.getY() * dist);
    }

    public static Point2D getUnitVector(Point2D p1, Point2D p2) {
        Point2D.Double paux = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        double v = Math.sqrt(Math.pow(((Point2D)paux).getX(), 2.0) + Math.pow(((Point2D)paux).getY(), 2.0));
        paux = new Point2D.Double(((Point2D)paux).getX() / v, ((Point2D)paux).getY() / v);
        return paux;
    }

    public static Point2D getCenter(Point2D p1, Point2D p2, Point2D p3) {
        if (p1.equals(p2) || p2.equals(p3) || p1.equals(p3)) {
            return null;
        }
        Point2D[] perp1 = UtilFunctions.getPerpendicular(p1, p2, new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0));
        Point2D[] perp2 = UtilFunctions.getPerpendicular(p2, p3, new Point2D.Double((p2.getX() + p3.getX()) / 2.0, (p2.getY() + p3.getY()) / 2.0));
        return UtilFunctions.getIntersection(perp1[0], perp1[1], perp2[0], perp2[1]);
    }

    public static Point2D getIntersection(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double m1 = Double.POSITIVE_INFINITY;
        if (p2.getX() - p1.getX() != 0.0) {
            m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        }
        double m2 = Double.POSITIVE_INFINITY;
        if (p4.getX() - p3.getX() != 0.0) {
            m2 = (p4.getY() - p3.getY()) / (p4.getX() - p3.getX());
        }
        if (m1 == Double.POSITIVE_INFINITY && m2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        double b1 = p2.getY() - m1 * p2.getX();
        double b2 = p4.getY() - m2 * p4.getX();
        if (m1 != Double.POSITIVE_INFINITY && m2 != Double.POSITIVE_INFINITY) {
            if (m1 == m2) {
                return null;
            }
            double x = (b2 - b1) / (m1 - m2);
            return new Point2D.Double(x, m1 * x + b1);
        }
        if (m1 == Double.POSITIVE_INFINITY) {
            double x = p1.getX();
            return new Point2D.Double(x, m2 * x + b2);
        }
        if (m2 == Double.POSITIVE_INFINITY) {
            double x = p3.getX();
            return new Point2D.Double(x, m1 * x + b1);
        }
        throw new RuntimeException("BUG!");
    }

    public static double getAngle(Point2D start, Point2D end) {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance(end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double angleDistance(double angle1, double angle2) {
        if (angle1 < angle2) {
            return angle2 - angle1;
        }
        return Math.PI * 2 - angle1 + angle2;
    }

    public static Point2D getPoint(Point2D p1, Point2D p2, double radio) {
        Point2D.Double paux = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        double v = Math.sqrt(Math.pow(((Point2D)paux).getX(), 2.0) + Math.pow(((Point2D)paux).getY(), 2.0));
        paux = new Point2D.Double(((Point2D)paux).getX() / v, ((Point2D)paux).getY() / v);
        Point2D.Double aux1 = new Point2D.Double(p1.getX() + radio * ((Point2D)paux).getX(), p1.getY() + radio * ((Point2D)paux).getY());
        return aux1;
    }

    public static double absoluteAngleDistance(double angle1, double angle2) {
        double d = Math.abs(angle1 - angle2);
        if (d < Math.PI) {
            return d;
        }
        if (angle1 < angle2) {
            angle2 -= Math.PI * 2;
        } else {
            angle1 -= Math.PI * 2;
        }
        return Math.abs(angle1 - angle2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Arc2D createArc(Point2D p1, Point2D p2, Point2D p3) {
        double w;
        double extent;
        double angle1;
        Point2D center = UtilFunctions.getCenter(p1, p2, p3);
        if (center == null) {
            if (!p1.equals(p3)) return null;
            if (p2.equals(p1)) return null;
            center = new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
            angle1 = UtilFunctions.getAngle(center, p1);
            extent = Math.PI * 2;
        } else {
            angle1 = UtilFunctions.getAngle(center, p1);
            double angle2 = UtilFunctions.getAngle(center, p3);
            extent = UtilFunctions.angleDistance(angle1, angle2);
            try {
                GeometryManager manager = GeometryLocator.getGeometryManager();
                Curve line = manager.createCurve(0);
                line.addVertex(p1.getX(), p1.getY());
                line.addVertex(p2.getX(), p2.getY());
                line.addVertex(p3.getX(), p3.getY());
                line.addVertex(p1.getX(), p1.getY());
                extent = !line.isCCW() ? Math.PI * 2 - extent : -extent;
            }
            catch (Exception ex) {
                logger.warn("Can't determine CCW of the Arc", (Throwable)ex);
                extent = -extent;
            }
        }
        double Radio = p1.distance(center);
        double xR = center.getX() - Radio;
        double yR = center.getY() - Radio;
        double h = w = 2.0 * Radio;
        Rectangle2D.Double rBounds = new Rectangle2D.Double(xR, yR, w, h);
        return new Arc2D.Double(rBounds, Math.toDegrees(Math.PI * 2 - angle1), Math.toDegrees(extent), 0);
    }

    public static Arc2D createArc(Point2D center, double radius, double angSt, double angExt) {
        double w;
        double xR = center.getX() - radius;
        double yR = center.getY() - radius;
        double h = w = 2.0 * radius;
        Rectangle2D.Double rBounds = new Rectangle2D.Double(xR, yR, w, h);
        Arc2D.Double resul = new Arc2D.Double(rBounds, Math.toDegrees(Math.PI * 2 - angSt), Math.toDegrees(angExt), 0);
        return resul;
    }

    public static Arc2D createArc2points(Point2D center, Point2D init, Point2D end) {
        double w;
        double angle1 = UtilFunctions.getAngle(center, init);
        double angle2 = UtilFunctions.getAngle(center, end);
        double extent = UtilFunctions.angleDistance(angle1, angle2);
        extent = -extent;
        double Radio = init.distance(center);
        double xR = center.getX() - Radio;
        double yR = center.getY() - Radio;
        double h = w = 2.0 * Radio;
        Rectangle2D.Double rBounds = new Rectangle2D.Double(xR, yR, w, h);
        Arc2D.Double resul = new Arc2D.Double(rBounds, Math.toDegrees(Math.PI * 2 - angle1), Math.toDegrees(extent), 0);
        return resul;
    }

    public static Point2D getPoint(Point2D p1, double an, double radio) {
        double x = radio * Math.cos(an) + p1.getX();
        double y = radio * Math.sin(an) + p1.getY();
        Point2D.Double p = new Point2D.Double(x, y);
        return p;
    }

    public static Line2D createLine(Point2D start, Point2D end) {
        return new Line2D.Double(start, end);
    }

    public static boolean isLowAngle(Point2D antp, Point2D lastp, Point2D interp, Point2D point) {
        boolean isCCW = true;
        try {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Curve line = manager.createCurve(0);
            line.addVertex(lastp.getX(), lastp.getY());
            line.addVertex(interp.getX(), interp.getY());
            line.addVertex(point.getX(), point.getY());
            line.addVertex(lastp.getX(), lastp.getY());
            isCCW = line.isCCW();
        }
        catch (Exception ex) {
            logger.warn("Can't determine CCW of angle.", (Throwable)ex);
        }
        try {
            double angle1 = UtilFunctions.getAngle(antp, lastp);
            double angle2 = UtilFunctions.getAngle(lastp, point);
            if (UtilFunctions.angleDistance(angle2, angle1) > Math.PI ? isCCW : !isCCW) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

