/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml.virtualrows;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.gml.virtualrows.StructureExtractorImpl;
import org.gvsig.fmap.dal.store.gml.virtualrows.XmlCommons;
import org.gvsig.fmap.dal.store.gml.virtualrows.xmlinfo.XMLAttributeInfoImpl;
import org.gvsig.fmap.dal.store.gml.virtualrows.xmlinfo.XMLInfoImpl;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GfsFile
implements Iterable<PropertyDefn>,
IsEmpty,
Size {
    private static final Logger LOGGER = LoggerFactory.getLogger(GfsFile.class);
    private static final String PROPERTY_NAME_SEPARATOR = "_";
    private static final String PROPERTY_PATH_SEPARATOR = "|";
    private static final String PROPERTY_ATTRIBUTE_SEPARATOR = "@";
    private String name;
    private String baseElementPath;
    private Map<String, PropertyDefn> properties;
    private Map<String, GeometryPropertyDefn> geometries;
    private int gmlVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getGeometryElementPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (GeometryPropertyDefn geometry : this.geometries.values()) {
            result.add(geometry.getElementPath().replace(PROPERTY_PATH_SEPARATOR, "/"));
        }
        return result;
    }

    public Collection<GeometryPropertyDefn> getGeometryElements() {
        return this.geometries.values();
    }

    private String getGeometryElementName(String path) {
        String theName = FilenameUtils.getBaseName((String)path);
        for (int i = 0; i < this.geometries.size(); ++i) {
            String geometryElementPath = this.geometries.get(i).getElementPath();
            if (!StringUtils.equals((CharSequence)path, (CharSequence)geometryElementPath)) continue;
            return theName + i;
        }
        return theName;
    }

    public String getBaseElementPath() {
        return this.baseElementPath;
    }

    public void setBaseElementPath(String baseElementPath) {
        this.baseElementPath = baseElementPath;
    }

    private String findBaseElementPath(XMLInfoImpl xmlinfo) {
        String possibleMemberPath = null;
        for (String path : xmlinfo.getTagsPaths()) {
            String[] ss;
            XMLAttributeInfoImpl tag = xmlinfo.getTag(path);
            if (StringUtils.isBlank(possibleMemberPath) && !tag.isAttr() && !StringUtils.equalsIgnoreCase((CharSequence)tag.getNs(), (CharSequence)"gml") && !StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)"FeatureCollection/boundedBy") && (ss = path.split("/")).length == 2) {
                possibleMemberPath = path;
            }
            if (path.equalsIgnoreCase("FeatureCollection/member")) {
                return path;
            }
            if (!path.equalsIgnoreCase("FeatureCollection/featureMember")) continue;
            return path;
        }
        return possibleMemberPath;
    }

    private Map<String, GeometryPropertyDefn> findGeometryElements(XMLInfoImpl xmlinfo) {
        XMLAttributeInfoImpl tag;
        LinkedHashMap<String, GeometryPropertyDefn> result = new LinkedHashMap<String, GeometryPropertyDefn>();
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : xmlinfo.getTagsPaths()) {
            tag = xmlinfo.getTag(path);
            paths.add(path);
        }
        for (int i = 0; i < paths.size(); ++i) {
            String path;
            path = (String)paths.get(i);
            tag = xmlinfo.getTag(path);
            if (i == paths.size() - 1 || tag.isAttr()) continue;
            XMLAttributeInfoImpl nextTag = xmlinfo.getTag((String)paths.get(i + 1));
            String p = null;
            switch (nextTag.getName().toUpperCase()) {
                case "POINT": 
                case "MULTIPOINT": 
                case "LINESTRING": {
                    p = path;
                    this.gmlVersion = 0;
                    break;
                }
                case "POLYGON": 
                case "MULTIPOLYGON": {
                    p = path;
                    this.gmlVersion = 2;
                    break;
                }
                case "SOLID": 
                case "SURFACE": 
                case "MULTISURFACE": 
                case "COMPOSITESURFACE": 
                case "CURVE": 
                case "MULTICURVE": {
                    p = path;
                    this.gmlVersion = 3;
                }
            }
            if (p == null) continue;
            int dims = 2;
            for (int i2 = 0; i2 < paths.size(); ++i2) {
                int n;
                String path2 = (String)paths.get(i2);
                if (!StringUtils.startsWith((CharSequence)path2, (CharSequence)path) || !StringUtils.endsWith((CharSequence)path2, (CharSequence)"srsDimension")) continue;
                XMLAttributeInfoImpl tag2 = xmlinfo.getTag(path2);
                String s = tag2.getFirstValue();
                if (!StringUtils.isNotBlank((CharSequence)s) || (n = Integer.parseInt(s)) <= 1 || n > 3) break;
                dims = n;
                break;
            }
            if (p.startsWith(this.baseElementPath + "/")) {
                p = p.substring(this.baseElementPath.length() + 1);
            }
            for (GeometryPropertyDefn geom : result.values()) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)p, (CharSequence)geom.getElementPath())) continue;
                p = null;
                break;
            }
            if (p == null) continue;
            result.put(tag.getName(), new GeometryPropertyDefn(tag.getName(), p, nextTag.getName().toUpperCase(), dims, nextTag.getSrs()));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String toString() {
        try {
            DataTypesManager datatypesManager = ToolsLocator.getDataTypesManager();
            StringBuilder builder = new StringBuilder();
            builder.append("<GMLFeatureClassList>\n  <GMLFeatureClass>\n    <Name>" + this.getName() + "</Name>\n" + "    <ElementPath>" + this.getBaseElementPath() + "</ElementPath>\n");
            if (this.geometries != null) {
                for (GeometryPropertyDefn geometryPropertyDefn : this.geometries.values()) {
                    builder.append("    <GeomPropertyDefn>\n");
                    builder.append("      <Name>");
                    builder.append(geometryPropertyDefn.getName());
                    builder.append("</Name>\n");
                    builder.append("      <ElementPath>");
                    builder.append(geometryPropertyDefn.getElementPath());
                    builder.append("</ElementPath>\n");
                    builder.append("      <Type>");
                    builder.append(geometryPropertyDefn.getGeometryTypeName());
                    builder.append("</Type>\n");
                    builder.append("      <Dimensions>");
                    builder.append(geometryPropertyDefn.getDimensions());
                    builder.append("</Dimensions>\n");
                    builder.append("      <Srs>");
                    builder.append(geometryPropertyDefn.getSrs());
                    builder.append("</Srs>\n");
                    builder.append("    </GeomPropertyDefn>\n");
                }
            }
            for (PropertyDefn propertyDefn : this.properties.values()) {
                int type = propertyDefn.getType();
                String propertyType = datatypesManager.getTypeName(type);
                builder.append("    <PropertyDefn>\n");
                builder.append("      <Name>");
                builder.append(propertyDefn.getName());
                builder.append("</Name>\n");
                builder.append("      <ElementPath>");
                builder.append(propertyDefn.getElementPath());
                if (propertyDefn.isAttr()) {
                    int lastIndex = builder.lastIndexOf(PROPERTY_PATH_SEPARATOR);
                    builder.replace(lastIndex, PROPERTY_PATH_SEPARATOR.length() + lastIndex, PROPERTY_ATTRIBUTE_SEPARATOR);
                }
                builder.append("</ElementPath>\n");
                builder.append("      <Type>");
                builder.append(propertyType);
                builder.append("</Type>\n");
                if (type == 8) {
                    builder.append("      <Width>");
                    builder.append(propertyDefn.getWidth());
                    builder.append("</Width>\n");
                }
                builder.append("    </PropertyDefn>\n");
            }
            builder.append("  </GMLFeatureClass>\n</GMLFeatureClassList>");
            return builder.toString();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't generate gfs file", (Throwable)ex);
            return null;
        }
    }

    public void fetch(File gmlFile) {
        this.properties = new LinkedMap();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("GML");
        status.setAutoremove(true);
        try {
            status.add();
            StructureExtractorImpl extractor = new StructureExtractorImpl();
            XMLInfoImpl xmlinfo = extractor.extractStructure(gmlFile, null, Locale.getDefault(), status);
            this.name = FilenameUtils.getBaseName((String)gmlFile.getName());
            this.baseElementPath = this.findBaseElementPath(xmlinfo);
            this.geometries = this.findGeometryElements(xmlinfo);
            for (String path : xmlinfo.getTagsPaths()) {
                XMLAttributeInfoImpl tag = xmlinfo.getTag(path);
                if (tag.hasChilds() || !path.startsWith(this.baseElementPath + "/")) continue;
                path = path.substring(this.baseElementPath.length() + 1);
                boolean found = false;
                if (this.geometries != null) {
                    for (GeometryPropertyDefn geometry : this.geometries.values()) {
                        if (path.equals(geometry.getElementPath())) {
                            found = true;
                            break;
                        }
                        if (!path.startsWith(geometry.getElementPath() + "/") || !tag.getNs().equalsIgnoreCase("gml")) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (path.indexOf(47) < 0 && tag.isAttr()) continue;
                String[] path_ss = path.split("/");
                String lastName = path_ss[path_ss.length - 1];
                String propertyName = StringUtils.replace((String)path, (String)"/", (String)PROPERTY_NAME_SEPARATOR);
                if (StringUtils.endsWith((CharSequence)path, (CharSequence)"$v")) {
                    propertyName = StringUtils.replace((String)propertyName, (String)(PROPERTY_NAME_SEPARATOR + lastName), (String)"");
                }
                String propertyPath = StringUtils.replace((String)path, (String)"/", (String)PROPERTY_PATH_SEPARATOR);
                if (StringUtils.endsWith((CharSequence)path, (CharSequence)"$v")) {
                    propertyPath = StringUtils.replace((String)propertyPath, (String)(PROPERTY_PATH_SEPARATOR + lastName), (String)"");
                }
                this.properties.put(propertyName, new PropertyDefn(propertyName, propertyPath, tag.getType(), tag.getSize(), tag.isAttr()));
            }
            status.terminate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't generate gfs file", (Throwable)ex);
            status.abort();
            throw new RuntimeException("", ex);
        }
    }

    public void load(File gfsFile) {
        final SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("GML");
        status.setAutoremove(true);
        this.setName(null);
        this.setBaseElementPath(null);
        this.properties = new LinkedMap();
        this.geometries = new LinkedMap();
        try {
            status.add();
            InputSource is = XmlCommons.openReader(gfsFile, null);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            final ArrayList path = new ArrayList();
            final DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            SAXParser saxParser = spf.newSAXParser();
            saxParser.parse(gfsFile, new DefaultHandler(){
                private Locator locator;
                int refreshInterval = 1;
                StringBuilder chars = new StringBuilder();
                PropertyDefn property = null;
                GeometryPropertyDefn geometry = null;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    int line = this.locator.getLineNumber();
                    if (line % this.refreshInterval == 0) {
                        status.setCurValue((long)line);
                    }
                    if (line > 100000) {
                        this.refreshInterval = 10000;
                    } else if (line > 10000) {
                        this.refreshInterval = 1000;
                    } else if (line > 1000) {
                        this.refreshInterval = 100;
                    } else if (line > 100) {
                        this.refreshInterval = 10;
                    }
                    if (StringUtils.equals((CharSequence)localName, (CharSequence)"PropertyDefn")) {
                        this.property = new PropertyDefn();
                    } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"GeomPropertyDefn")) {
                        this.geometry = new GeometryPropertyDefn();
                    }
                    path.add(localName);
                    this.chars.setLength(0);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (StringUtils.equals((CharSequence)localName, (CharSequence)"GeomPropertyDefn")) {
                        GfsFile.this.geometries.put(this.geometry.getName(), this.geometry);
                        this.geometry = null;
                    } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"PropertyDefn")) {
                        GfsFile.this.properties.put(this.property.getName(), this.property);
                        this.property = null;
                    } else if (this.property != null) {
                        if (StringUtils.equals((CharSequence)localName, (CharSequence)"Name")) {
                            String value = this.chars.toString();
                            this.property.setName(value);
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"ElementPath")) {
                            String value = this.chars.toString();
                            if (value.indexOf(GfsFile.PROPERTY_ATTRIBUTE_SEPARATOR) >= 0) {
                                this.property.setIsAttr(true);
                                value = value.replace(GfsFile.PROPERTY_ATTRIBUTE_SEPARATOR, GfsFile.PROPERTY_PATH_SEPARATOR);
                            }
                            this.property.setElementPath(value);
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Type")) {
                            String value = this.chars.toString();
                            this.property.setType(dataTypesManager.getType(value));
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Width")) {
                            int value = Integer.valueOf(this.chars.toString());
                            this.property.setWidth(value);
                        }
                    } else if (this.geometry != null) {
                        if (StringUtils.equals((CharSequence)localName, (CharSequence)"Name")) {
                            String value = this.chars.toString();
                            this.geometry.setName(value);
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"ElementPath")) {
                            String value = this.chars.toString();
                            this.geometry.setElementPath(value);
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Type")) {
                            String value = this.chars.toString();
                            this.geometry.setGeometryTypeName(value);
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Dimensions")) {
                            String value = this.chars.toString();
                            try {
                                this.geometry.setDimensions(Integer.parseInt(value));
                            }
                            catch (Exception exception) {}
                        } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Srs")) {
                            String value = this.chars.toString();
                            this.geometry.setSrs(value);
                        }
                    } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"Name")) {
                        String value = this.chars.toString();
                        GfsFile.this.setName(value);
                    } else if (StringUtils.equals((CharSequence)localName, (CharSequence)"ElementPath")) {
                        String value = this.chars.toString();
                        GfsFile.this.setBaseElementPath(value);
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.chars.append(ch, start, length);
                }
            });
            status.terminate();
        }
        catch (Exception ex) {
            status.abort();
            throw new RuntimeException("Can't load gfs file '" + gfsFile.getAbsolutePath() + "'", ex);
        }
    }

    public void save(File gfsFile) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(gfsFile));
            writer.append(this.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public Iterator<PropertyDefn> iterator() {
        return this.properties.values().iterator();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int size() {
        return this.properties.size();
    }

    public List<String> getPropertiesPaths() {
        ArrayList<String> res = new ArrayList<String>();
        for (PropertyDefn property : this.properties.values()) {
            res.add(property.getElementPath().replace(PROPERTY_PATH_SEPARATOR, "/"));
        }
        return res;
    }

    public PropertyDefn get(String propertyName) {
        return this.properties.get(propertyName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GfsFile)) {
            return false;
        }
        GfsFile other = (GfsFile)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.baseElementPath.equals(other.getBaseElementPath())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (PropertyDefn property : this) {
            PropertyDefn otherProperty;
            if (property.equals(otherProperty = other.get(property.getName()))) continue;
            System.out.println("MY :" + property.getElementPath());
            System.out.println("OT :" + otherProperty.getElementPath());
            return false;
        }
        for (GeometryPropertyDefn geometry : this.geometries.values()) {
            PropertyDefn otherGeometry;
            if (geometry.equals(otherGeometry = other.get(geometry.getName()))) continue;
            System.out.println("MY :" + geometry.getElementPath());
            System.out.println("OT :" + otherGeometry.getElementPath());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String XMLFILE1 = "/home/fdiaz/projects/GMLS/navarra.gml";
        new DefaultLibrariesInitializer().fullInitialize();
        GfsFile gfs = new GfsFile();
        gfs.fetch(new File("/home/fdiaz/projects/GMLS/navarra.gml"));
        System.out.println(gfs.toString());
        System.out.println(StringUtils.join(gfs.getPropertiesPaths(), (String)"\n"));
        File gfsFile = new File(FilenameUtils.removeExtension((String)"/home/fdiaz/projects/GMLS/navarra.gml") + ".gfs");
        gfs.save(gfsFile);
        GfsFile gfs2 = new GfsFile();
        gfs2.load(gfsFile);
        System.out.println("=========================================");
        System.out.println(gfs.toString());
        System.out.println(StringUtils.join(gfs.getPropertiesPaths(), (String)"\n"));
        System.out.println("Los gfs " + (gfs.equals(gfs2) ? "S\u00cd" : "NO") + " son iguales");
    }

    public static class GeometryPropertyDefn
    extends PropertyDefn {
        private String srs;
        private String geometryTypeName;
        private int dimensions;

        public GeometryPropertyDefn() {
            this.dimensions = 2;
        }

        public GeometryPropertyDefn(String name, String elementPath, String geometryTypeName, int dimensions, String srs) {
            super(name, elementPath, 0, 0, false);
            this.srs = srs;
            this.geometryTypeName = geometryTypeName;
            this.dimensions = dimensions;
        }

        public String getSrs() {
            return this.srs;
        }

        public void setSrs(String srs) {
            this.srs = srs;
        }

        public String getGeometryTypeName() {
            return this.geometryTypeName;
        }

        public void setGeometryTypeName(String geometryTypeName) {
            this.geometryTypeName = geometryTypeName;
        }

        public GeometryType getGeometryType() {
            try {
                int gtype = 0;
                int gsubType = 0;
                switch (this.geometryTypeName.toUpperCase()) {
                    case "POINT": {
                        gtype = 1;
                        break;
                    }
                    case "MULTIPOINT": {
                        gtype = 7;
                        break;
                    }
                    case "LINESTRING": {
                        gtype = 18;
                        break;
                    }
                    case "POLYGON": {
                        gtype = 19;
                        break;
                    }
                    case "MULTIPOLYGON": {
                        gtype = 22;
                        break;
                    }
                    case "SOLID": {
                        gtype = 22;
                        gsubType = 1;
                        break;
                    }
                    case "SURFACE": {
                        gtype = 19;
                        break;
                    }
                    case "MULTISURFACE": {
                        gtype = 22;
                        break;
                    }
                    case "COMPOSITESURFACE": {
                        gtype = 22;
                        break;
                    }
                    case "CURVE": {
                        gtype = 18;
                        break;
                    }
                    case "MULTICURVE": {
                        gtype = 21;
                    }
                }
                switch (this.dimensions) {
                    case 2: {
                        gsubType = 0;
                        break;
                    }
                    case 3: {
                        gsubType = 1;
                    }
                }
                return GeometryLocator.getGeometryManager().getGeometryType(gtype, gsubType);
            }
            catch (Throwable t) {
                throw new RuntimeException("Can't get geometry type", t);
            }
        }

        public int getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(int dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class PropertyDefn {
        private String name;
        private String elementPath;
        private int type;
        private int width;
        private boolean isAttr;

        public PropertyDefn() {
        }

        public PropertyDefn(String name, String elementPath, int type, int width, boolean isAttr) {
            this.name = name;
            this.elementPath = elementPath;
            this.type = type;
            this.width = width;
            this.isAttr = isAttr;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getElementPath() {
            return this.elementPath;
        }

        public void setElementPath(String elementPath) {
            this.elementPath = elementPath;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isAttr() {
            return this.isAttr;
        }

        public void setIsAttr(boolean b) {
            this.isAttr = b;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropertyDefn)) {
                return false;
            }
            PropertyDefn other = (PropertyDefn)obj;
            if (!StringUtils.equals((CharSequence)this.getName(), (CharSequence)other.getName())) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.getElementPath(), (CharSequence)other.getElementPath())) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.isAttr() == other.isAttr();
        }
    }
}

