/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml.virtualrows;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.utils.CharsetUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.store.gml.virtualrows.XmlCommons;
import org.gvsig.fmap.dal.store.gml.virtualrows.xmlinfo.XMLAttributeInfoImpl;
import org.gvsig.fmap.dal.store.gml.virtualrows.xmlinfo.XMLInfoImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StructureExtractorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureExtractorImpl.class);

    private void extractTags(final XMLInfoImpl xmlinfo, Reader reader, final SimpleTaskStatus status) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        try {
            final DataManager dataManager = DALLocator.getDataManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            status.message(i18n.getTranslation("_Reading_xml") + " 1/5");
            status.setRangeOfValues(0L, xmlinfo.getCountLines());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            InputSource is = new InputSource(reader);
            final ArrayList path = new ArrayList();
            saxParser.parse(is, new DefaultHandler(){
                private Locator locator;
                int size;
                int refreshInterval = 1;
                StringBuilder chars = new StringBuilder();

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    int line = this.locator.getLineNumber();
                    int column = this.locator.getColumnNumber() - 2 - localName.length();
                    if (line % this.refreshInterval == 0) {
                        status.setCurValue((long)line);
                    }
                    if (line > 100000) {
                        this.refreshInterval = 10000;
                    } else if (line > 10000) {
                        this.refreshInterval = 1000;
                    } else if (line > 1000) {
                        this.refreshInterval = 100;
                    } else if (line > 100) {
                        this.refreshInterval = 10;
                    }
                    String idvalue = dataManager.createUniqueID();
                    path.add(localName);
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    XMLAttributeInfoImpl info = xmlinfo.getTag(path_s);
                    if (info == null) {
                        info = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s, StructureExtractorImpl.this.getNs(qName));
                        xmlinfo.addTag(info);
                    }
                    XMLAttributeInfoImpl parentinfo = null;
                    if (path.size() > 1) {
                        List parentpath = path.subList(0, path.size() - 1);
                        String parentpath_s = StringUtils.join(parentpath, (String)"/");
                        parentinfo = xmlinfo.getTag(parentpath_s);
                        parentinfo.incrChildCount(localName);
                        parentinfo.setLastChildID(localName, idvalue);
                    }
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getLocalName(i);
                        String value = attributes.getValue(i);
                        String idvalueChild = dataManager.createUniqueID();
                        XMLAttributeInfoImpl infoChild = xmlinfo.getTag(path_s + "/" + name);
                        if (infoChild == null) {
                            infoChild = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s + "/" + name, StructureExtractorImpl.this.getNs(qName));
                            infoChild.setIsAttr(true);
                            xmlinfo.addTag(infoChild);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"srsName")) {
                            info.setSrs(value);
                            if (parentinfo != null) {
                                parentinfo.setSrs(value);
                            }
                        }
                        info.incrChildCount(infoChild.getName());
                        info.setLastChildID(infoChild.getName(), idvalueChild);
                        infoChild.addValue(value);
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    String value;
                    int line = this.locator.getLineNumber();
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    XMLAttributeInfoImpl info = xmlinfo.getTag(path_s);
                    if (info == null) {
                        info = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s, StructureExtractorImpl.this.getNs(qName));
                        xmlinfo.addTag(info);
                    }
                    XMLAttributeInfoImpl parentinfo = null;
                    if (path.size() > 1) {
                        List parentpath = path.subList(0, path.size() - 1);
                        String parentpath_s = StringUtils.join(parentpath, (String)"/");
                        parentinfo = xmlinfo.getTag(parentpath_s);
                    }
                    if (info.hasChilds() || parentinfo != null && parentinfo.getChildsCount(localName) > 1) {
                        value = this.chars.toString();
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            String name = info.getName() + "$v";
                            String idvalueChild = dataManager.createUniqueID();
                            XMLAttributeInfoImpl infoChild = xmlinfo.getTag(path_s + "/" + name);
                            if (infoChild == null) {
                                infoChild = new XMLAttributeInfoImpl(xmlinfo.getLocale(), path_s + "/" + name, StructureExtractorImpl.this.getNs(qName));
                                xmlinfo.addTag(infoChild);
                            }
                            info.incrChildCount(infoChild.getName());
                            info.setLastChildID(infoChild.getName(), idvalueChild);
                            infoChild.addValue(value);
                        }
                    } else {
                        value = this.chars.toString();
                        info.addValue(value);
                    }
                    info.consolidateChildCounters();
                    path.remove(path.size() - 1);
                    this.chars.setLength(0);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    int line = this.locator.getLineNumber();
                    this.chars.append(ch, start, length);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't extract tags.", ex);
        }
    }

    public XMLInfoImpl extractStructure(File xml, Charset charset, Locale locale, SimpleTaskStatus status) throws FileNotFoundException, IOException {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setLocale(locale);
        long count = XmlCommons.countLines(xml, charset, status);
        xmlinfo.setCountLines(count);
        InputSource is = XmlCommons.openReader(xml, charset);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfoImpl extractStructure(InputStream xml, Charset charset, Locale locale, SimpleTaskStatus status) throws IOException {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setLocale(locale);
        xmlinfo.setCountLines(-1L);
        InputSource is = XmlCommons.openReader(xml, charset);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfoImpl extractStructure(Reader reader, Locale locale, SimpleTaskStatus status) {
        XMLInfoImpl xmlinfo = new XMLInfoImpl();
        xmlinfo.setLocale(locale);
        InputSource is = new InputSource(reader);
        return this.extractStructure(is, xmlinfo, status);
    }

    public XMLInfoImpl extractStructure(InputSource is, XMLInfoImpl xmlinfo, SimpleTaskStatus status) {
        if (xmlinfo.getCharset() == null) {
            xmlinfo.setCharset(CharsetUtils.forName((String)is.getEncoding()));
        }
        this.extractTags(xmlinfo, is.getCharacterStream(), status);
        return xmlinfo;
    }

    private String getNs(String s) {
        String[] ss = s.split(":");
        if (ss.length == 1) {
            return null;
        }
        return ss[0];
    }
}

