/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordModel.marc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.marc4j.MarcHandler;
import org.marc4j.MarcReader;
import org.marc4j.marcxml.Converter;
import org.marc4j.marcxml.MarcResult;
import org.marc4j.marcxml.MarcSource;
import org.marc4j.marcxml.MarcXmlReader;
import org.marc4j.util.TaggedWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class iso2709
implements InformationFragment,
Serializable {
    protected String source_repository = null;
    protected String source_collection_name = null;
    protected Object handle = null;
    protected byte[] source_record = null;
    private ExplicitRecordFormatSpecification spec = null;

    public iso2709(byte[] marc_record) {
        this.source_record = marc_record;
    }

    public iso2709(String source_repository, String source_collection_name, ExplicitRecordFormatSpecification spec, Object handle, Object source) {
        this.source_record = (byte[])source;
        this.handle = handle;
        this.source_collection_name = source_collection_name;
        this.source_repository = source_repository;
        this.spec = spec;
    }

    public ExplicitRecordFormatSpecification getFormatSpecification() {
        return this.spec;
    }

    public void setFormatSpecification(ExplicitRecordFormatSpecification spec) {
        this.spec = spec;
    }

    public Object getOriginalObject() {
        return this.source_record;
    }

    public String getOriginalObjectClassName() {
        return "byte[]";
    }

    public Document getDocument() {
        Document retval = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        try {
            MarcXmlReader producer = new MarcXmlReader();
            InputSource in = new InputSource(new InputStreamReader(new ByteArrayInputStream(this.source_record)));
            SAXSource source = new SAXSource((XMLReader)producer, in);
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            retval = docBuilder.newDocument();
            Element root_element = retval.getDocumentElement();
            DOMResult result = new DOMResult(retval);
            Converter converter = new Converter();
            converter.convert((Source)source, (Result)result);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public String getDocumentSchema() {
        return this.spec.getSchema().toString();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            MarcReader reader = new MarcReader();
            TaggedWriter handler = new TaggedWriter((Writer)sw);
            MarcSource source = new MarcSource(reader, (InputStream)new ByteArrayInputStream(this.source_record));
            MarcResult result = new MarcResult();
            result.setHandler((MarcHandler)handler);
            Converter converter = new Converter();
            converter.convert((Source)source, (Result)result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public void setSourceRepositoryID(String source_repository) {
        this.source_repository = source_repository;
    }

    public String getSourceRepositoryID() {
        return this.source_repository;
    }

    public void setSourceCollectionName(String source_collection_name) {
        this.source_collection_name = source_collection_name;
    }

    public String getSourceCollectionName() {
        return this.source_collection_name;
    }

    public void setSourceFragmentID(Object handle) {
        this.handle = handle;
    }

    public Object getSourceFragmentID() {
        return this.handle;
    }
}

