/*
 * Decompiled with CFR 0.152.
 */
package es.gva.cit.jecwcompress;

import es.gva.cit.jecwcompress.EcwException;
import es.gva.cit.jecwcompress.JNIBase;
import es.gva.cit.jecwcompress.NCSError;
import es.gva.cit.jecwcompress.ReadCallBack;

public class NCSEcwCompressClient
extends JNIBase {
    private String inputFilename = null;
    private String outputFilename = null;
    private double targetCompression = 0.0;
    private int eCompressFormat = 0;
    private int eCompressHint = 0;
    private int nBlockSizeX = 0;
    private int nBlockSizeY = 0;
    private int nInOutSizeX = 0;
    private int nInOutSizeY = 0;
    private int nInputBands = 0;
    private int nOutputBands = 0;
    private long nInputSize = 0L;
    private double fCellIncrementX = 0.0;
    private double fCellIncrementY = 0.0;
    private double fOriginX = 0.0;
    private double fOriginY = 0.0;
    private int eCellSizeUnits = 0;
    private String szDatum = null;
    private String szProjection = null;
    private double fActualCompression = 0.0;
    private double fCompressionSeconds = 0.0;
    private double fCompressionMBSec = 0.0;
    private long nOutputSize = 0L;
    public byte[] buffer;
    private long readInfo;
    private int porcentaje;

    private native long NCSEcwCompressClientNat();

    private native int NCSEcwCompressOpenNat(long var1, boolean var3);

    private native int NCSEcwCompressNat(long var1, ReadCallBack var3);

    private native int NCSEcwCompressCloseNat(long var1);

    private native void NCSEcwCompressCancelNat(long var1);

    private native void finalizeNat(long var1);

    private void initialize() {
        this.buffer = new byte[this.nInOutSizeX * this.nInputBands];
    }

    private void setReadInfo(long ptr) {
        this.readInfo = ptr;
    }

    private long getReadInfo() {
        return this.readInfo;
    }

    public int getPercent() {
        return this.porcentaje;
    }

    public NCSEcwCompressClient() throws EcwException {
        this.cPtr = this.NCSEcwCompressClientNat();
        if (this.cPtr == 0L) {
            throw new EcwException("Error en la creaci\u00ef\u00bf\u00bdn del objeto NCSEcwCompressClient");
        }
    }

    public void NCSEcwCompressOpen(boolean bCalculateSizesOnly) throws EcwException {
        if (this.cPtr == 0L) {
            throw new EcwException("Error en NCSEcwCompressOpen(). No hay una referencia v\u00ef\u00bf\u00bdlida al objeto NCSEcwCompressClient.");
        }
        int error = this.NCSEcwCompressOpenNat(this.cPtr, bCalculateSizesOnly);
        if (error == -1) {
            throw new EcwException("Error en NCSEcwCompressOpen(). No se ha podido obtener un objeto NCSEcwCompress valido");
        }
        if (error != 0) {
            throw new EcwException("Error en NCSEcwCompressOpen(). La llamada nativa ha devuelto un error " + NCSError.ErrorToString(error));
        }
    }

    public void NCSEcwCompress(ReadCallBack read) throws EcwException {
        if (this.cPtr == 0L) {
            throw new EcwException("Error en NCSEcwCompress(). No hay una referencia v\u00ef\u00bf\u00bdlida al objeto NCSEcwCompressClient.");
        }
        if (read == null) {
            throw new EcwException("Error en NCSEcwCompress(). El par\u00ef\u00bf\u00bdmetro ReadCallBack no puede ser nulo.");
        }
        int error = this.NCSEcwCompressNat(this.cPtr, read);
        if (error == -1) {
            throw new EcwException("Error en NCSEcwCompress(). No se ha podido obtener un objeto NCSEcwCompress valido");
        }
        if (error != 0) {
            throw new EcwException("Error en NCSEcwCompress(). La llamada nativa ha devuelto un error " + NCSError.ErrorToString(error));
        }
    }

    public void NCSEcwCompressClose() throws EcwException {
        if (this.cPtr == 0L) {
            throw new EcwException("Error en NCSEcwCompress(). No hay una referencia v\u00ef\u00bf\u00bdlida al objeto NCSEcwCompressClient.");
        }
        int error = this.NCSEcwCompressCloseNat(this.cPtr);
        if (error == -1) {
            throw new EcwException("Error en NCSEcwCompress(). No se ha podido obtener un objeto NCSEcwCompress valido");
        }
        if (error != 0) {
            throw new EcwException("Error en NCSEcwCompress(). La llamada nativa ha devuelto un error " + NCSError.ErrorToString(error));
        }
    }

    public void NCSEcwCompressCancel() throws EcwException {
        if (this.cPtr == 0L) {
            throw new EcwException("Error en NCSEcwCompress(). No hay una referencia v\u00ef\u00bf\u00bdlida al objeto NCSEcwCompressClient.");
        }
        this.NCSEcwCompressCancelNat(this.cPtr);
    }

    public void finalize() throws EcwException {
        if (this.cPtr == 0L) {
            throw new EcwException("Error en finalize(). No hay una referencia v\u00ef\u00bf\u00bdlida al objeto NCSEcwCompressClient y no se ha podido liberar la memoria.");
        }
    }

    public void setInputFilename(String filename) {
        this.inputFilename = filename;
    }

    public void setOutputFilename(String filename) {
        this.outputFilename = filename;
    }

    public void setTargetCompress(double compress) {
        this.targetCompression = compress;
    }

    public void setCompressFormat(int format) {
        this.eCompressFormat = format;
    }

    public void setCompressHint(int hint) {
        this.eCompressHint = hint;
    }

    public void setBlockSizeX(int n) {
        this.nBlockSizeX = n;
    }

    public void setBlockSizeY(int n) {
        this.nBlockSizeY = n;
    }

    public void setInOutSizeX(int n) {
        this.nInOutSizeX = n;
    }

    public void setInOutSizeY(int n) {
        this.nInOutSizeY = n;
    }

    public void setInputBands(int n) {
        this.nInputBands = n;
    }

    public void setOutputBands(int n) {
        this.nOutputBands = n;
    }

    public void setInputSize(long nis) {
        this.nInputSize = nis;
    }

    public void setCellIncrementX(double x) {
        this.fCellIncrementX = x;
    }

    public void setCellIncrementY(double y) {
        this.fCellIncrementY = y;
    }

    public void setOriginX(double x) {
        this.fOriginX = x;
    }

    public void setOriginY(double y) {
        this.fOriginY = y;
    }

    public void setCellSizeUnits(int cellu) {
        this.eCellSizeUnits = cellu;
    }

    public void setDatum(String dat) {
        this.szDatum = dat;
    }

    public void setProjection(String proj) {
        this.szProjection = proj;
    }

    public void setActualCompression(double comp) {
        this.fActualCompression = comp;
    }

    public void setCompressionSeconds(double comp) {
        this.fCompressionSeconds = comp;
    }

    public void setCompressionMBSec(double comp) {
        this.fCompressionMBSec = comp;
    }

    public void setOutputSize(long n) {
        this.nOutputSize = n;
    }
}

