/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import java.util.HashMap;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;

public class LayerDatatypeSextanteAlgorithm
extends AbstractSextanteGeoProcess
implements IProcessActions {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "RasterStore1";
    public static final String DATATYPE = "Datatype";
    public static final String ADJUST_DEC2INT = "AdjustDec2Int";
    public static final String ADJUST_BIG2SMALL = "AdjustBig2Small";
    public static String[] DEC2INT_OPTIONS = new String[]{"Trunk", "Round", "Ceil", "Floor"};
    public static String[] BIG2SMALL_OPTIONS = new String[]{"Trunk", "Maxvalue", "NoData"};
    public static String[] DATATYPES = new String[]{"Byte", "UShort", "Short", "Integer", "Float", "Double"};
    private DataProcess task = null;

    public void defineCharacteristics() {
        this.setName(this.getTranslation("layer_datatype"));
        this.setGroup(this.getTranslation("raster_layer"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, this.getTranslation("Input_layer"), true);
            this.m_Parameters.addSelection(DATATYPE, this.getTranslation("dst_datatype"), DATATYPES);
            this.m_Parameters.addSelection(ADJUST_DEC2INT, this.getTranslation("dec_2_int"), DEC2INT_OPTIONS);
            this.m_Parameters.addSelection(ADJUST_BIG2SMALL, this.getTranslation("big_2_small"), BIG2SMALL_OPTIONS);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputRasterLayer(RESULT, this.getTranslation("principalcomponents"));
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        FLyrRaster lyrRaster = (FLyrRaster)input.getBaseDataObject();
        IRasterLayer output = null;
        output = this.getNewRORasterLayer(RESULT, Sextante.getText((String)"layerdatatype_description"), input.getDataType(), input.getBandsCount());
        String fileName = ((FLyrRasterIRasterLayer)output).getName();
        try {
            this.setProgressText(this.getTranslation("convert_datatype"));
            this.task = this.createLayerDatatypeProcess(lyrRaster.getDataStore(), fileName);
            this.task.execute();
            HashMap params = this.task.getResult();
            fileName = (String)params.get("FileName");
            ((FLyrRasterIRasterLayer)output).setBaseDataObject(fileName);
        }
        catch (ProcessInterruptedException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (ProcessException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return !this.getTaskMonitor().isCanceled();
    }

    private DataProcess createLayerDatatypeProcess(RasterDataStore inputStore, String fileName) throws ProcessException, WrongParameterTypeException, WrongParameterIDException, NullParameterValueException, NullParameterAdditionalInfoException {
        DataProcess taskStats = RasterBaseAlgorithmLibrary.getManager().createRasterTask("LayerDatatypeProcess");
        taskStats.setActions((IProcessActions)this);
        List params = taskStats.getRasterTaskInputParameters("LayerDatatypeProcess");
        for (int i = 0; i < params.size(); ++i) {
            int j;
            int position;
            String value;
            String paramName = (String)params.get(i);
            Class paramType = taskStats.getParameterTypeByProcess("LayerDatatypeProcess", paramName);
            if (paramType == RasterDataStore.class) {
                taskStats.addParam(paramName, (Object)inputStore);
            }
            if (paramName.equals("Path")) {
                taskStats.addParam(paramName, (Object)fileName);
            }
            if (paramName.equals(DATATYPE)) {
                value = this.m_Parameters.getParameterValueAsString(DATATYPE);
                position = 0;
                for (j = 0; j < DATATYPES.length; ++j) {
                    if (!DATATYPES[j].equals(value)) continue;
                    position = j;
                }
                taskStats.addParam(paramName, (Object)position);
            }
            if (paramName.equals(ADJUST_DEC2INT)) {
                value = this.m_Parameters.getParameterValueAsString(ADJUST_DEC2INT);
                position = 0;
                for (j = 0; j < DEC2INT_OPTIONS.length; ++j) {
                    if (!DEC2INT_OPTIONS[j].equals(value)) continue;
                    position = j;
                }
                taskStats.addParam(paramName, (Object)position);
            }
            if (paramName.equals(ADJUST_BIG2SMALL)) {
                value = this.m_Parameters.getParameterValueAsString(ADJUST_BIG2SMALL);
                position = 0;
                for (j = 0; j < BIG2SMALL_OPTIONS.length; ++j) {
                    if (!BIG2SMALL_OPTIONS[j].equals(value)) continue;
                    position = j;
                }
                taskStats.addParam(paramName, (Object)position);
            }
            if (!paramName.equals("WINDOW")) continue;
            AnalysisExtent ext = this.getAnalysisExtent();
            Extent bbox = RasterLocator.getManager().getDataStructFactory().createExtent(ext.getXMin(), ext.getYMax(), ext.getXMax(), ext.getYMin());
            Extent inputBbox = inputStore.getExtent();
            if (bbox.getULX() == inputBbox.getULX() && bbox.getULY() == inputBbox.getULY() && bbox.getLRX() == inputBbox.getLRX() && bbox.getLRY() == inputBbox.getLRY()) continue;
            taskStats.addParam(paramName, (Object)bbox);
        }
        return taskStats;
    }

    public void interrupted() {
    }

    public void end(Object param) {
    }

    public void updateProgress(int current, int total) {
        boolean cancelled = this.setProgress(current, total);
        if (!cancelled && this.task != null) {
            this.task.actionCanceled(null);
        }
    }
}

