/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.BooleanType;

class SDOBooleanType
extends BooleanType {
    private static final long serialVersionUID = 1L;

    SDOBooleanType() {
    }

    public String getName() {
        return "sdo_boolean";
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        String value = rs.getString(name);
        if (rs.wasNull()) {
            return this.getDefaultValue();
        }
        if ("TRUE".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void set(PreparedStatement st, Boolean value, int index) throws SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            boolean bool = value;
            st.setString(index, bool ? "TRUE" : "FALSE");
        }
    }

    public String objectToSQLString(Boolean value, Dialect dialect) {
        return value != false ? "'TRUE'" : "'FALSE'";
    }
}

