/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import org.hibernate.HibernateException;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.spatial.GeometrySqlTypeDescriptor;
import org.hibernate.spatial.GeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.sqlserver.SqlServer2008GeometryTypeDescriptor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SqlServer2008SpatialDialect
extends SQLServer2008Dialect
implements SpatialDialect {
    public static final String SHORT_NAME = "sqlserver";
    public static final String COLUMN_TYPE = "GEOMETRY";

    public SqlServer2008SpatialDialect() {
        this.registerColumnType(2003, COLUMN_TYPE);
        this.registerFunction("dimension", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1.STDimension()"));
        this.registerFunction("geometrytype", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "?1.STGeometryType()"));
        this.registerFunction("srid", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1.STSrid"));
        this.registerFunction("envelope", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STEnvelope()"));
        this.registerFunction("astext", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "?1.STAsText()"));
        this.registerFunction("asbinary", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BINARY, "?1.STAsBinary()"));
        this.registerFunction("isempty", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIsEmpty()"));
        this.registerFunction("issimple", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIsSimple()"));
        this.registerFunction("boundary", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STBoundary()"));
        this.registerFunction("contains", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STContains(?2)"));
        this.registerFunction("crosses", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STCrosses(?2)"));
        this.registerFunction("disjoint", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STDisjoint(?2)"));
        this.registerFunction("equals", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STEquals(?2)"));
        this.registerFunction("intersects", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIntersects(?2)"));
        this.registerFunction("overlaps", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STOverlaps(?2)"));
        this.registerFunction("touches", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STTouches(?2)"));
        this.registerFunction("within", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STWithin(?2)"));
        this.registerFunction("relate", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STRelate(?2,?3)"));
        this.registerFunction("distance", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.DOUBLE, "?1.STDistance(?2)"));
        this.registerFunction("buffer", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STBuffer(?2)"));
        this.registerFunction("convexhull", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STConvexHull()"));
        this.registerFunction("difference", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STDifference(?2)"));
        this.registerFunction("intersection", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STIntersection(?2)"));
        this.registerFunction("symdifference", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STSymDifference(?2)"));
        this.registerFunction("geomunion", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STUnion(?2)"));
        this.registerFunction("area", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.DOUBLE, "?1.STArea()"));
        this.registerFunction("centroid", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STCentroid()"));
        this.registerFunction("pointonsurface", (SQLFunction)new SQLFunctionTemplate((Type)GeometryType.INSTANCE, "?1.STPointOnSurface()"));
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        if (code == 3000) {
            return COLUMN_TYPE;
        }
        return super.getTypeName(code, length, precision, scale);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor instanceof GeometrySqlTypeDescriptor) {
            return SqlServer2008GeometryTypeDescriptor.INSTANCE;
        }
        return super.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String stfunction;
        switch (spatialRelation) {
            case 4: {
                stfunction = "STWithin";
                break;
            }
            case 6: {
                stfunction = "STContains";
                break;
            }
            case 3: {
                stfunction = "STCrosses";
                break;
            }
            case 5: {
                stfunction = "STOverlaps";
                break;
            }
            case 1: {
                stfunction = "STDisjoint";
                break;
            }
            case 7: {
                stfunction = "STIntersects";
                break;
            }
            case 2: {
                stfunction = "STTouches";
                break;
            }
            case 0: {
                stfunction = "STEquals";
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        return columnName + "." + stfunction + "(?) = 1";
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return columnName + ".Filter(?) = 1";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("No spatial aggregate SQL functions.");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException("SQL Server has no DWithin function.");
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return columnName + ".STSrid = (?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String base = "(" + columnName + ".STIsEmpty() ";
        return isEmpty ? base + " = 1 )" : base + " = 0 )";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }
}

