/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.Figure;
import org.hibernate.spatial.dialect.sqlserver.convertors.FigureAttribute;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.Shape;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MCoordinate;

class PointEncoder
extends AbstractEncoder<Point> {
    PointEncoder() {
    }

    @Override
    public SqlServerGeometry encode(Point geom) {
        SqlServerGeometry sqlServerGeom = new SqlServerGeometry();
        sqlServerGeom.setSrid(geom.getSRID());
        sqlServerGeom.setIsValid();
        if (geom.isEmpty()) {
            sqlServerGeom.setNumberOfPoints(0);
            sqlServerGeom.setNumberOfFigures(0);
            sqlServerGeom.setNumberOfShapes(1);
            sqlServerGeom.setShape(0, new Shape(-1, -1, OpenGisType.POINT));
            return sqlServerGeom;
        }
        sqlServerGeom.setIsSinglePoint();
        sqlServerGeom.setNumberOfPoints(1);
        Coordinate coordinate = geom.getCoordinate();
        if (this.is3DPoint(coordinate)) {
            sqlServerGeom.setHasZValues();
            sqlServerGeom.allocateZValueArray();
        }
        if (this.isMPoint(coordinate)) {
            sqlServerGeom.setHasMValues();
            sqlServerGeom.allocateMValueArray();
        }
        sqlServerGeom.setCoordinate(0, coordinate);
        return sqlServerGeom;
    }

    @Override
    protected void encode(Geometry geom, int parentIdx, List<Coordinate> coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Point)) {
            throw new IllegalArgumentException("Require Point geometry");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentIdx, -1, OpenGisType.POINT));
            return;
        }
        int pntOffset = coordinates.size();
        int figureOffset = figures.size();
        coordinates.add(geom.getCoordinate());
        Figure figure = new Figure(FigureAttribute.Stroke, pntOffset);
        figures.add(figure);
        Shape shape = new Shape(parentIdx, figureOffset, OpenGisType.POINT);
        shapes.add(shape);
    }

    private boolean isMPoint(Coordinate coordinate) {
        return coordinate instanceof MCoordinate && !Double.isNaN(((MCoordinate)coordinate).m);
    }

    private boolean is3DPoint(Coordinate coordinate) {
        return !Double.isNaN(coordinate.z);
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Point;
    }
}

