/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.spatialjoin;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.dissolve.DissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.Summary;
import org.gvsig.geoprocess.algorithm.spatialjoin.IntersectsSpatialJoinOperation;
import org.gvsig.geoprocess.algorithm.spatialjoin.SpatialJoinParametersPanel;
import org.gvsig.geoprocess.algorithm.spatialjoin.SpatiallyIndexedSpatialJoinOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ServiceManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class SpatialJoinAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String NEW_FIELD = "NUM_RELA";
    public static final String RESULT = "RESULT";
    public static final String LAYER1 = "LAYER1";
    public static final String LAYER2 = "LAYER2";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String SELECTGEOM_OVERLAY = "SELECTGEOM_OVERLAY";
    public static final String NEAREST = "NEAREST";
    public static final String FUNCTION_LIST = "FUNCTION_LIST";
    public static final String[] Summary = new String[]{"Min", "Max", "Sum", "Avg"};
    private boolean[] funcList = new boolean[Summary.length];
    private HashMap<String, String> funcMap = new HashMap();

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Spatialjoin"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(LAYER2, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer"), false);
            this.m_Parameters.addBoolean(SELECTGEOM_OVERLAY, this.getTranslation("Selected_geometries_overlay_layer"), false);
            this.m_Parameters.addBoolean(NEAREST, this.getTranslation("use_the_nearest"), false);
            this.m_Parameters.addString(FUNCTION_LIST, this.getTranslation("Function_list"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT, this.getTranslation("Spatialjoin"), -1);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        boolean selectedGeomOverlay = this.m_Parameters.getParameter(SELECTGEOM_OVERLAY).getParameterValueAsBoolean();
        boolean nearest = this.m_Parameters.getParameterValueAsBoolean(NEAREST);
        String functionList = this.m_Parameters.getParameterValueAsString(FUNCTION_LIST);
        this.loadSummary(functionList);
        FlyrVectIVectorLayer inputLayer = null;
        FlyrVectIVectorLayer overlayLayer = null;
        if (!(layer2 instanceof FlyrVectIVectorLayer) || !(layer1 instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        overlayLayer = (FlyrVectIVectorLayer)layer2;
        inputLayer = (FlyrVectIVectorLayer)layer1;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            FeatureType featureTypeInputLayer = inputLayer.getFeatureStore().getDefaultFeatureType();
            FeatureType featureTypeOverlayLayer = overlayLayer.getFeatureStore().getDefaultFeatureType();
            GeometryOperation operation = null;
            FeatureStore outFeatStore = null;
            if (nearest) {
                outFeatStore = this.buildOutPutStoreFromUnion(featureTypeInputLayer, featureTypeOverlayLayer, inputLayer.getShapeType(), this.getTranslation("SpatialJoin"), RESULT, "DIST", Double.class);
                operation = new SpatiallyIndexedSpatialJoinOperation(overlayLayer, this.createIndex(overlayLayer.getFeatureStore(), selectedGeomOverlay), this);
            } else {
                outFeatStore = this.buildSpatialJoinOutPutStore(featureTypeInputLayer, inputLayer.getShapeType(), this.getTranslation("SpatialJoin"), RESULT);
                DissolveRule rule = new DissolveRule(featureTypeInputLayer.getAttributeName(0), this.funcMap);
                Summary summary = new Summary((IDissolveRule)rule, outFeatStore.getDefaultFeatureType());
                operation = new IntersectsSpatialJoinOperation(overlayLayer, this.createIndex(overlayLayer.getFeatureStore(), selectedGeomOverlay), summary, this);
            }
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            operation.computesGeometryOperation(inputLayer.getFeatureStore(), outFeatStore, this.attrNames, selectedGeomInput, selectedGeomOverlay, true);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return true;
    }

    private SpatialIndex createIndex(FeatureStore store, boolean selectionOnly) throws BaseException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        SpatialIndexFactory factory = geomManager.getSpatialIndexFactory("JSIRTree");
        DynObject parameters = factory.createParameters();
        SpatialIndex index = (SpatialIndex)factory.create(parameters, (ServiceManager)geomManager);
        final SpatialIndex wrappedIndex = store.wrapSpatialIndex(index);
        Visitor visitor = new Visitor(){

            public void visit(Object obj) throws VisitCanceledException, BaseException {
                Feature f = (Feature)obj;
                Geometry g = f.getDefaultGeometry();
                FeatureReference ref = f.getReference();
                wrappedIndex.insert(g, (Object)ref);
            }
        };
        if (selectionOnly) {
            store.getFeatureSelection().accept(visitor);
        } else {
            store.accept(visitor);
        }
        return wrappedIndex;
    }

    private int isInList(String it) {
        for (int i = 0; i < Summary.length; ++i) {
            if (Summary[i].compareTo(it) != 0) continue;
            return i;
        }
        return -1;
    }

    private void loadSummary(String functionList) {
        String[] attrList = functionList.split(";");
        for (int i = 0; i < attrList.length; ++i) {
            String[] func = attrList[i].split(",");
            for (int j = 1; j < func.length; ++j) {
                int pos = this.isInList(func[j]);
                if (pos == -1) continue;
                this.funcList[pos] = true;
                this.funcMap.put(Summary[pos], func[0]);
            }
        }
    }

    protected FeatureStore buildSpatialJoinOutPutStore(FeatureType featureType1, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        ArrayList<Class> typesList = new ArrayList<Class>();
        ArrayList<String> attr = new ArrayList<String>();
        for (FeatureAttributeDescriptor attribute : featureType1) {
            if (attribute.getDataType().getType() == 66) continue;
            attr.add(attribute.getName());
            typesList.add(attribute.getObjectClass());
        }
        for (int i = 0; i < this.funcList.length; ++i) {
            if (!this.funcList[i]) continue;
            String fieldName = this.funcMap.get(Summary[i]);
            if (fieldName.length() >= 6) {
                fieldName = fieldName.substring(0, 7);
            }
            attr.add(fieldName + "_" + Summary[i]);
            typesList.add(Double.class);
        }
        attr.add(NEW_FIELD);
        typesList.add(Integer.class);
        this.attrNames = new String[attr.size()];
        attr.toArray(this.attrNames);
        Class[] types = new Class[typesList.size()];
        typesList.toArray(types);
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, this.attrNames);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return SpatialJoinParametersPanel.class;
    }
}

