/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.multipoint;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class MultipointEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    public static final String FINISH = "finish";
    public static final String KEY_FINISH = "key_finish";
    private final EditingServiceParameter points;
    private List<Point> values;
    private boolean finish;
    private final FeatureStore featureStore;

    public MultipointEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.finish = false;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(FINISH, (Object)FINISH, i18nManager.getTranslation(KEY_FINISH));
        String consoleMsg = editingProviderServices.makeConsoleMessage("indicate_new_point", (EditingServiceParameterOptions)options);
        this.points = new DefaultEditingServiceParameter("indicate_new_point", consoleMsg, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.LIST_POSITIONS, EditingServiceParameter.TYPE.OPTION}).setDataType(8);
    }

    public EditingServiceParameter next() {
        if (this.finish) {
            return null;
        }
        return this.points;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol pointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        for (Point point : this.values) {
            drawingStatus.addStatus((Geometry)point, pointSymbolEditing, "");
            drawingStatus.addStatus((Geometry)point, previewSymbol, "");
        }
        return drawingStatus;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
        this.finish = false;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.points);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.points) {
            String option;
            if (value instanceof Point) {
                this.values.add((Point)value);
            } else if (value instanceof String && StringUtils.equalsIgnoreCase((String)(option = (String)parameter.getOptions2().getValue(value, parameter.getDefaultValue())), (String)FINISH)) {
                this.finish = true;
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null && this.values.size() > 0) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                MultiPoint multiPoint = GeometryLocator.getGeometryManager().createMultiPoint(subtype);
                for (Point point : this.values) {
                    multiPoint.addPoint(point);
                }
                return multiPoint;
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geom = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geom, this.featureStore);
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new ArrayList<Point>();
    }

    public String getName() {
        return "Inserts multipoitns geometries";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.points) {
            return this.values;
        }
        return null;
    }
}

