/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Dictionary;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticIntegerDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.CX;
import org.apache.pdfbox.jbig2.decoder.huffman.EncodedTable;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.StandardTables;
import org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.GenericRefinementRegion;
import org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.apache.pdfbox.jbig2.segments.Table;
import org.apache.pdfbox.jbig2.segments.TextRegion;

public class SymbolDictionary
implements Dictionary {
    private SubInputStream subInputStream;
    private short sdrTemplate;
    private byte sdTemplate;
    private boolean isCodingContextRetained;
    private boolean isCodingContextUsed;
    private short sdHuffAggInstanceSelection;
    private short sdHuffBMSizeSelection;
    private short sdHuffDecodeWidthSelection;
    private short sdHuffDecodeHeightSelection;
    private boolean useRefinementAggregation;
    private boolean isHuffmanEncoded;
    private short[] sdATX;
    private short[] sdATY;
    private short[] sdrATX;
    private short[] sdrATY;
    private int amountOfExportSymbolss;
    private int amountOfNewSymbols;
    private SegmentHeader segmentHeader;
    private int amountOfImportedSymbolss;
    private ArrayList<Bitmap> importSymbols;
    private int amountOfDecodedSymbols;
    private Bitmap[] newSymbols;
    private HuffmanTable dhTable;
    private HuffmanTable dwTable;
    private HuffmanTable bmSizeTable;
    private HuffmanTable aggInstTable;
    private ArrayList<Bitmap> exportSymbols;
    private ArrayList<Bitmap> sbSymbols;
    private ArithmeticDecoder arithmeticDecoder;
    private ArithmeticIntegerDecoder iDecoder;
    private TextRegion textRegion;
    private GenericRegion genericRegion;
    private GenericRefinementRegion genericRefinementRegion;
    private CX cx;
    private CX cxIADH;
    private CX cxIADW;
    private CX cxIAAI;
    private CX cxIAEX;
    private CX cxIARDX;
    private CX cxIARDY;
    private CX cxIADT;
    protected CX cxIAID;
    private int sbSymCodeLen;

    public SymbolDictionary() {
    }

    public SymbolDictionary(SubInputStream subInputStream, SegmentHeader segmentHeader) throws IOException {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        this.readRegionFlags();
        this.setAtPixels();
        this.setRefinementAtPixels();
        this.readAmountOfExportedSymbols();
        this.readAmountOfNewSymbols();
        this.setInSyms();
        if (this.isCodingContextUsed) {
            SegmentHeader[] segmentHeaderArray = this.segmentHeader.getRtSegments();
            for (int i = segmentHeaderArray.length - 1; i >= 0; --i) {
                if (segmentHeaderArray[i].getSegmentType() != 0) continue;
                SymbolDictionary symbolDictionary = (SymbolDictionary)segmentHeaderArray[i].getSegmentData();
                if (!symbolDictionary.isCodingContextRetained) break;
                this.setRetainedCodingContexts(symbolDictionary);
                break;
            }
        }
        this.checkInput();
    }

    private void readRegionFlags() throws IOException {
        this.subInputStream.readBits(3);
        this.sdrTemplate = (short)this.subInputStream.readBit();
        this.sdTemplate = (byte)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.isCodingContextRetained = true;
        }
        if (this.subInputStream.readBit() == 1) {
            this.isCodingContextUsed = true;
        }
        this.sdHuffAggInstanceSelection = (short)this.subInputStream.readBit();
        this.sdHuffBMSizeSelection = (short)this.subInputStream.readBit();
        this.sdHuffDecodeWidthSelection = (short)(this.subInputStream.readBits(2) & 0xFL);
        this.sdHuffDecodeHeightSelection = (short)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.useRefinementAggregation = true;
        }
        if (this.subInputStream.readBit() == 1) {
            this.isHuffmanEncoded = true;
        }
    }

    private void setAtPixels() throws IOException {
        if (!this.isHuffmanEncoded) {
            if (this.sdTemplate == 0) {
                this.readAtPixels(4);
            } else {
                this.readAtPixels(1);
            }
        }
    }

    private void setRefinementAtPixels() throws IOException {
        if (this.useRefinementAggregation && this.sdrTemplate == 0) {
            this.readRefinementAtPixels(2);
        }
    }

    private void readAtPixels(int n) throws IOException {
        this.sdATX = new short[n];
        this.sdATY = new short[n];
        for (int i = 0; i < n; ++i) {
            this.sdATX[i] = this.subInputStream.readByte();
            this.sdATY[i] = this.subInputStream.readByte();
        }
    }

    private void readRefinementAtPixels(int n) throws IOException {
        this.sdrATX = new short[n];
        this.sdrATY = new short[n];
        for (int i = 0; i < n; ++i) {
            this.sdrATX[i] = this.subInputStream.readByte();
            this.sdrATY[i] = this.subInputStream.readByte();
        }
    }

    private void readAmountOfExportedSymbols() throws IOException {
        this.amountOfExportSymbolss = (int)this.subInputStream.readBits(32);
    }

    private void readAmountOfNewSymbols() throws IOException {
        this.amountOfNewSymbols = (int)this.subInputStream.readBits(32);
    }

    private void setInSyms() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        if (this.segmentHeader.getRtSegments() != null) {
            this.retrieveImportSymbols();
        } else {
            this.importSymbols = new ArrayList();
        }
    }

    private void setRetainedCodingContexts(SymbolDictionary symbolDictionary) {
        this.arithmeticDecoder = symbolDictionary.arithmeticDecoder;
        this.isHuffmanEncoded = symbolDictionary.isHuffmanEncoded;
        this.useRefinementAggregation = symbolDictionary.useRefinementAggregation;
        this.sdTemplate = symbolDictionary.sdTemplate;
        this.sdrTemplate = symbolDictionary.sdrTemplate;
        this.sdATX = symbolDictionary.sdATX;
        this.sdATY = symbolDictionary.sdATY;
        this.sdrATX = symbolDictionary.sdrATX;
        this.sdrATY = symbolDictionary.sdrATY;
        this.cx = symbolDictionary.cx;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            if (this.sdTemplate != 0) {
                this.sdTemplate = 0;
            }
            if (!this.useRefinementAggregation) {
                if (this.isCodingContextRetained) {
                    this.isCodingContextRetained = false;
                }
                if (this.isCodingContextUsed) {
                    this.isCodingContextUsed = false;
                }
            }
        } else {
            if (this.sdHuffBMSizeSelection != 0) {
                this.sdHuffBMSizeSelection = 0;
            }
            if (this.sdHuffDecodeWidthSelection != 0) {
                this.sdHuffDecodeWidthSelection = 0;
            }
            if (this.sdHuffDecodeHeightSelection != 0) {
                this.sdHuffDecodeHeightSelection = 0;
            }
        }
        if (!this.useRefinementAggregation && this.sdrTemplate != 0) {
            this.sdrTemplate = 0;
        }
        if (!(this.isHuffmanEncoded && this.useRefinementAggregation || this.sdHuffAggInstanceSelection == 0)) {
            this.sdHuffAggInstanceSelection = 0;
        }
    }

    @Override
    public ArrayList<Bitmap> getDictionary() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (null == this.exportSymbols) {
            if (this.useRefinementAggregation) {
                this.sbSymCodeLen = this.getSbSymCodeLen();
            }
            if (!this.isHuffmanEncoded) {
                this.setCodingStatistics();
            }
            this.newSymbols = new Bitmap[this.amountOfNewSymbols];
            int[] nArray = null;
            if (this.isHuffmanEncoded && !this.useRefinementAggregation) {
                nArray = new int[this.amountOfNewSymbols];
            }
            this.setSymbolsArray();
            int n = 0;
            this.amountOfDecodedSymbols = 0;
            while (this.amountOfDecodedSymbols < this.amountOfNewSymbols) {
                long l;
                n = (int)((long)n + this.decodeHeightClassDeltaHeight());
                int n2 = 0;
                int n3 = 0;
                int n4 = this.amountOfDecodedSymbols;
                while ((l = this.decodeDifferenceWidth()) != Long.MAX_VALUE && this.amountOfDecodedSymbols < this.amountOfNewSymbols) {
                    n2 = (int)((long)n2 + l);
                    n3 += n2;
                    if (!this.isHuffmanEncoded || this.useRefinementAggregation) {
                        if (!this.useRefinementAggregation) {
                            this.decodeDirectlyThroughGenericRegion(n2, n);
                        } else {
                            this.decodeAggregate(n2, n);
                        }
                    } else if (this.isHuffmanEncoded && !this.useRefinementAggregation) {
                        nArray[this.amountOfDecodedSymbols] = n2;
                    }
                    ++this.amountOfDecodedSymbols;
                }
                if (!this.isHuffmanEncoded || this.useRefinementAggregation) continue;
                l = this.sdHuffBMSizeSelection == 0 ? StandardTables.getTable(1).decode(this.subInputStream) : this.huffDecodeBmSize();
                this.subInputStream.skipBits();
                Bitmap bitmap = this.decodeHeightClassCollectiveBitmap(l, n, n3);
                this.subInputStream.skipBits();
                this.decodeHeightClassBitmap(bitmap, n4, n, nArray);
            }
            int[] nArray2 = this.getToExportFlags();
            this.setExportedSymbols(nArray2);
        }
        return this.exportSymbols;
    }

    private void setCodingStatistics() throws IOException {
        if (this.cxIADT == null) {
            this.cxIADT = new CX(512, 1);
        }
        if (this.cxIADH == null) {
            this.cxIADH = new CX(512, 1);
        }
        if (this.cxIADW == null) {
            this.cxIADW = new CX(512, 1);
        }
        if (this.cxIAAI == null) {
            this.cxIAAI = new CX(512, 1);
        }
        if (this.cxIAEX == null) {
            this.cxIAEX = new CX(512, 1);
        }
        if (this.useRefinementAggregation && this.cxIAID == null) {
            this.cxIAID = new CX(1 << this.sbSymCodeLen, 1);
            this.cxIARDX = new CX(512, 1);
            this.cxIARDY = new CX(512, 1);
        }
        if (this.cx == null) {
            this.cx = new CX(65536, 1);
        }
        if (this.arithmeticDecoder == null) {
            this.arithmeticDecoder = new ArithmeticDecoder(this.subInputStream);
        }
        if (this.iDecoder == null) {
            this.iDecoder = new ArithmeticIntegerDecoder(this.arithmeticDecoder);
        }
    }

    private final void decodeHeightClassBitmap(Bitmap bitmap, int n, int n2, int[] nArray) throws IntegerMaxValueException, InvalidHeaderValueException, IOException {
        for (int i = n; i < this.amountOfDecodedSymbols; ++i) {
            Bitmap bitmap2;
            int n3 = 0;
            for (int j = n; j <= i - 1; ++j) {
                n3 += nArray[j];
            }
            Rectangle rectangle = new Rectangle(n3, 0, nArray[i], n2);
            this.newSymbols[i] = bitmap2 = Bitmaps.extract(rectangle, bitmap);
            this.sbSymbols.add(bitmap2);
        }
    }

    private final void decodeAggregate(int n, int n2) throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        long l = this.isHuffmanEncoded ? this.huffDecodeRefAggNInst() : this.iDecoder.decode(this.cxIAAI);
        if (l > 1L) {
            this.decodeThroughTextRegion(n, n2, l);
        } else if (l == 1L) {
            this.decodeRefinedSymbol(n, n2);
        }
    }

    private final long huffDecodeRefAggNInst() throws IOException, InvalidHeaderValueException {
        if (this.sdHuffAggInstanceSelection == 0) {
            return StandardTables.getTable(1).decode(this.subInputStream);
        }
        if (this.sdHuffAggInstanceSelection == 1) {
            if (this.aggInstTable == null) {
                int n = 0;
                if (this.sdHuffDecodeHeightSelection == 3) {
                    ++n;
                }
                if (this.sdHuffDecodeWidthSelection == 3) {
                    ++n;
                }
                if (this.sdHuffBMSizeSelection == 3) {
                    ++n;
                }
                this.aggInstTable = this.getUserTable(n);
            }
            return this.aggInstTable.decode(this.subInputStream);
        }
        return 0L;
    }

    private final void decodeThroughTextRegion(int n, int n2, long l) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (this.textRegion == null) {
            this.textRegion = new TextRegion(this.subInputStream, null);
            this.textRegion.setContexts(this.cx, new CX(512, 1), new CX(512, 1), new CX(512, 1), new CX(512, 1), this.cxIAID, new CX(512, 1), new CX(512, 1), new CX(512, 1), new CX(512, 1));
        }
        this.setSymbolsArray();
        this.textRegion.setParameters(this.arithmeticDecoder, this.iDecoder, this.isHuffmanEncoded, true, n, n2, l, 1, this.amountOfImportedSymbolss + this.amountOfDecodedSymbols, (short)0, (short)0, (short)0, (short)1, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, this.sdrTemplate, this.sdrATX, this.sdrATY, this.sbSymbols, this.sbSymCodeLen);
        this.addSymbol(this.textRegion);
    }

    private final void decodeRefinedSymbol(int n, int n2) throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        int n3;
        int n4;
        int n5;
        if (this.isHuffmanEncoded) {
            n5 = (int)this.subInputStream.readBits(this.sbSymCodeLen);
            n4 = (int)StandardTables.getTable(15).decode(this.subInputStream);
            n3 = (int)StandardTables.getTable(15).decode(this.subInputStream);
            StandardTables.getTable(1).decode(this.subInputStream);
            this.subInputStream.skipBits();
        } else {
            n5 = this.iDecoder.decodeIAID(this.cxIAID, this.sbSymCodeLen);
            n4 = (int)this.iDecoder.decode(this.cxIARDX);
            n3 = (int)this.iDecoder.decode(this.cxIARDY);
        }
        this.setSymbolsArray();
        Bitmap bitmap = this.sbSymbols.get(n5);
        this.decodeNewSymbols(n, n2, bitmap, n4, n3);
        if (this.isHuffmanEncoded) {
            this.subInputStream.skipBits();
        }
    }

    private final void decodeNewSymbols(int n, int n2, Bitmap bitmap, int n3, int n4) throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        if (this.genericRefinementRegion == null) {
            this.genericRefinementRegion = new GenericRefinementRegion(this.subInputStream);
            if (this.arithmeticDecoder == null) {
                this.arithmeticDecoder = new ArithmeticDecoder(this.subInputStream);
            }
            if (this.cx == null) {
                this.cx = new CX(65536, 1);
            }
        }
        this.genericRefinementRegion.setParameters(this.cx, this.arithmeticDecoder, this.sdrTemplate, n, n2, bitmap, n3, n4, false, this.sdrATX, this.sdrATY);
        this.addSymbol(this.genericRefinementRegion);
    }

    private final void decodeDirectlyThroughGenericRegion(int n, int n2) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (this.genericRegion == null) {
            this.genericRegion = new GenericRegion(this.subInputStream);
        }
        this.genericRegion.setParameters(false, this.sdTemplate, false, false, this.sdATX, this.sdATY, n, n2, this.cx, this.arithmeticDecoder);
        this.addSymbol(this.genericRegion);
    }

    private final void addSymbol(Region region) throws IntegerMaxValueException, InvalidHeaderValueException, IOException {
        Bitmap bitmap;
        this.newSymbols[this.amountOfDecodedSymbols] = bitmap = region.getRegionBitmap();
        this.sbSymbols.add(bitmap);
    }

    private final long decodeDifferenceWidth() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            switch (this.sdHuffDecodeWidthSelection) {
                case 0: {
                    return StandardTables.getTable(2).decode(this.subInputStream);
                }
                case 1: {
                    return StandardTables.getTable(3).decode(this.subInputStream);
                }
                case 3: {
                    if (this.dwTable == null) {
                        int n = 0;
                        if (this.sdHuffDecodeHeightSelection == 3) {
                            ++n;
                        }
                        this.dwTable = this.getUserTable(n);
                    }
                    return this.dwTable.decode(this.subInputStream);
                }
            }
        } else {
            return this.iDecoder.decode(this.cxIADW);
        }
        return 0L;
    }

    private final long decodeHeightClassDeltaHeight() throws IOException, InvalidHeaderValueException {
        if (this.isHuffmanEncoded) {
            return this.decodeHeightClassDeltaHeightWithHuffman();
        }
        return this.iDecoder.decode(this.cxIADH);
    }

    private final long decodeHeightClassDeltaHeightWithHuffman() throws IOException, InvalidHeaderValueException {
        switch (this.sdHuffDecodeHeightSelection) {
            case 0: {
                return StandardTables.getTable(4).decode(this.subInputStream);
            }
            case 1: {
                return StandardTables.getTable(5).decode(this.subInputStream);
            }
            case 3: {
                if (this.dhTable == null) {
                    this.dhTable = this.getUserTable(0);
                }
                return this.dhTable.decode(this.subInputStream);
            }
        }
        return 0L;
    }

    private final Bitmap decodeHeightClassCollectiveBitmap(long l, int n, int n2) throws IOException {
        if (l == 0L) {
            Bitmap bitmap = new Bitmap(n2, n);
            for (int i = 0; i < bitmap.getLength(); ++i) {
                bitmap.setByte(i, this.subInputStream.readByte());
            }
            return bitmap;
        }
        if (this.genericRegion == null) {
            this.genericRegion = new GenericRegion(this.subInputStream);
        }
        this.genericRegion.setParameters(true, this.subInputStream.getStreamPosition(), l, n, n2);
        return this.genericRegion.getRegionBitmap();
    }

    private void setExportedSymbols(int[] nArray) {
        this.exportSymbols = new ArrayList(this.amountOfExportSymbolss);
        for (int i = 0; i < this.amountOfImportedSymbolss + this.amountOfNewSymbols; ++i) {
            if (nArray[i] != 1) continue;
            if (i < this.amountOfImportedSymbolss) {
                this.exportSymbols.add(this.importSymbols.get(i));
                continue;
            }
            this.exportSymbols.add(this.newSymbols[i - this.amountOfImportedSymbolss]);
        }
    }

    private int[] getToExportFlags() throws IOException, InvalidHeaderValueException {
        int n = 0;
        long l = 0L;
        int[] nArray = new int[this.amountOfImportedSymbolss + this.amountOfNewSymbols];
        int n2 = 0;
        while (n2 < this.amountOfImportedSymbolss + this.amountOfNewSymbols) {
            l = this.isHuffmanEncoded ? StandardTables.getTable(1).decode(this.subInputStream) : this.iDecoder.decode(this.cxIAEX);
            if (l != 0L) {
                int n3 = n2;
                while ((long)n3 < (long)n2 + l) {
                    nArray[n3] = n;
                    ++n3;
                }
            }
            n = n == 0 ? 1 : 0;
            n2 = (int)((long)n2 + l);
        }
        return nArray;
    }

    private final long huffDecodeBmSize() throws IOException, InvalidHeaderValueException {
        if (this.bmSizeTable == null) {
            int n = 0;
            if (this.sdHuffDecodeHeightSelection == 3) {
                ++n;
            }
            if (this.sdHuffDecodeWidthSelection == 3) {
                ++n;
            }
            this.bmSizeTable = this.getUserTable(n);
        }
        return this.bmSizeTable.decode(this.subInputStream);
    }

    private int getSbSymCodeLen() throws IOException {
        if (this.isHuffmanEncoded) {
            return Math.max((int)Math.ceil(Math.log(this.amountOfImportedSymbolss + this.amountOfNewSymbols) / Math.log(2.0)), 1);
        }
        return (int)Math.ceil(Math.log(this.amountOfImportedSymbolss + this.amountOfNewSymbols) / Math.log(2.0));
    }

    private final void setSymbolsArray() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        if (this.importSymbols == null) {
            this.retrieveImportSymbols();
        }
        if (this.sbSymbols == null) {
            this.sbSymbols = new ArrayList();
            this.sbSymbols.addAll(this.importSymbols);
        }
    }

    private void retrieveImportSymbols() throws IOException, InvalidHeaderValueException, IntegerMaxValueException {
        this.importSymbols = new ArrayList();
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            if (segmentHeader.getSegmentType() != 0) continue;
            SymbolDictionary symbolDictionary = (SymbolDictionary)segmentHeader.getSegmentData();
            this.importSymbols.addAll(symbolDictionary.getDictionary());
            this.amountOfImportedSymbolss += symbolDictionary.amountOfExportSymbolss;
        }
    }

    private HuffmanTable getUserTable(int n) throws InvalidHeaderValueException, IOException {
        int n2 = 0;
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            if (segmentHeader.getSegmentType() != 53) continue;
            if (n2 == n) {
                Table table = (Table)segmentHeader.getSegmentData();
                return new EncodedTable(table);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IntegerMaxValueException, IOException {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
        this.parseHeader();
    }
}

