/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.exception.UnsupportedSLDVersionException;
import org.gvsig.sldsupport.impl.parser.ExtendedKXmlParser;
import org.gvsig.sldsupport.impl.sld.parsing.FeatureStyleElement;
import org.gvsig.sldsupport.impl.sld.parsing.NamedLayerElement;
import org.gvsig.sldsupport.impl.sld.parsing.UserLayerElement;
import org.gvsig.sldsupport.impl.sld.parsing.symbol.SymbolElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.SLDObject;
import org.gvsig.sldsupport.sld.SLDRoot;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.layer.SLDUserLayer;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Handler {
    private static List<String> versions = new ArrayList<String>();

    public static SLDObject parse(InputStream inStream, String encoding, String version) throws XmlPullParserException, IOException, SLDException {
        ExtendedKXmlParser parser = new ExtendedKXmlParser();
        parser.setInput(inStream, encoding);
        int tag = parser.getEventType();
        if (tag == 0) {
            parser.nextTag();
            parser.require(2, null, "StyledLayerDescriptor");
        } else if (tag != 2) {
            throw new IOException("Misplaced input stream (it's not before opening tag)");
        }
        String name = parser.getName();
        String v = null;
        if (name.compareToIgnoreCase("StyledLayerDescriptor") == 0) {
            v = parser.getAttributeValue(null, "version");
            if (v == null) {
                throw new SLDReadException("Version attribute is missing in StyledLayerDescriptor");
            }
            SLDRoot root = Handler.parseRoot((XmlPullParser)parser, v);
            tag = parser.getEventType();
            if (tag != 1) {
                throw new SLDReadException("Expected end of document after closing 'StyledLayerDescriptor' tag");
            }
            return root;
        }
        if (name.compareToIgnoreCase("FeatureStyle") == 0 || name.compareToIgnoreCase("FeatureTypeStyle") == 0) {
            v = parser.getAttributeValue(null, "version");
            return Handler.parseFeatureStyle((XmlPullParser)parser, v);
        }
        if (name.compareToIgnoreCase("LineSymbolizer") == 0 || name.compareToIgnoreCase("PolygonSymbolizer") == 0 || name.compareToIgnoreCase("PointSymbolizer") == 0 || name.compareToIgnoreCase("TextSymbolizer") == 0 || name.compareToIgnoreCase("RasterSymbolizer") == 0) {
            v = parser.getAttributeValue(null, "version");
            return Handler.parseSymbol((XmlPullParser)parser, v);
        }
        throw new SLDReadException("Misplaced input stream. Bad opening tag: " + name);
    }

    private static SLDSymbol parseSymbol(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        return SymbolElement.parse(parser, version);
    }

    private static SLDLayer parseLayer(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String name = parser.getName();
        SLDNamedLayer resp = null;
        if (SLDUtils.isStr(name, "NamedLayer")) {
            resp = NamedLayerElement.parse(parser, version);
        } else if (SLDUtils.isStr(name, "UserLayer")) {
            resp = UserLayerElement.parse(parser, version);
        } else {
            throw new SLDReadException("Expected layer, found: '" + name + "' tag");
        }
        return resp;
    }

    private static SLDFeatureStyle parseFeatureStyle(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String name = parser.getName();
        SLDFeatureStyle resp = null;
        if (!SLDUtils.isStr(name, "FeatureStyle") && !SLDUtils.isStr(name, "FeatureTypeStyle")) {
            throw new SLDReadException("Expected layer, found: '" + name + "' tag");
        }
        resp = FeatureStyleElement.parse(parser, version);
        return resp;
    }

    private static SLDRoot parseRoot(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "StyledLayerDescriptor");
        int tag = parser.nextTag();
        String name = parser.getName();
        SLDLayer layer_item = null;
        SLDRoot resp = new SLDRoot(version);
        while (tag == 2 && (SLDUtils.isStr(name, "UserLayer") || SLDUtils.isStr(name, "NamedLayer"))) {
            layer_item = Handler.parseLayer(parser, version);
            resp.getLayers().add(layer_item);
            name = parser.getName();
            tag = parser.getEventType();
        }
        parser.require(3, null, "StyledLayerDescriptor");
        parser.next();
        return resp;
    }

    public static void writeToFile(SLDObject obj, File outf) throws InvalidSLDObjectException, UnsupportedSLDVersionException, UnsupportedSLDObjectException, IOException {
        if (obj == null) {
            throw new InvalidSLDObjectException("SLDObject", "Null");
        }
        if (!(obj instanceof SLDRoot || obj instanceof SLDFeatureStyle || obj instanceof SLDSymbol)) {
            throw new InvalidSLDObjectException("Unexpected class.", obj.getClass().getName());
        }
        if (outf == null || !outf.canWrite()) {
            new IOException("Null or read-only file: " + (outf == null ? "Null" : outf.getAbsolutePath()));
        }
        if (obj.getVersion() == null || !versions.contains(obj.getVersion())) {
            throw new UnsupportedSLDVersionException(obj.getVersion());
        }
        outf.delete();
        outf.createNewFile();
        FileOutputStream outs = new FileOutputStream(outf);
        XmlBuilder xmlb = Handler.getXML(obj);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "utf-8");
        writer.write(xmlb.getXML());
        writer.close();
        outs.close();
    }

    public static XmlBuilder getXML(SLDObject obj) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (!(obj instanceof SLDRoot || obj instanceof SLDFeatureStyle || obj instanceof SLDSymbol)) {
            throw new InvalidSLDObjectException("SLDObject: Unexpected entity.", obj == null ? "Null" : obj.getClass().getName());
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xsi:schemaLocation", "http://www.opengis.net/sld StyledLayerDescriptor.xsd");
        attributes.put("xmlns", "http://www.opengis.net/sld");
        attributes.put("xmlns:ogc", "http://www.opengis.net/ogc");
        attributes.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
        attributes.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attributes.put("version", obj.getVersion());
        XmlBuilder xmlBuilder = new XmlBuilder();
        xmlBuilder.setEncoding("utf-8");
        xmlBuilder.writeHeader();
        if (obj instanceof SLDRoot) {
            Handler.appendRoot((SLDRoot)obj, xmlBuilder, attributes);
        } else if (obj instanceof SLDFeatureStyle) {
            FeatureStyleElement.append((SLDFeatureStyle)obj, xmlBuilder, attributes);
        } else if (obj instanceof SLDSymbol) {
            SymbolElement.append((SLDSymbol)obj, xmlBuilder, attributes);
        }
        return xmlBuilder;
    }

    private static void appendRoot(SLDRoot root, XmlBuilder xb, Map<String, String> atts) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("StyledLayerDescriptor", atts);
        List list = root.getLayers();
        if (list == null || list.size() == 0) {
            throw new InvalidSLDObjectException("StyledLayerDescriptor", "No layers");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof SLDUserLayer) {
                UserLayerElement.append((SLDUserLayer)list.get(i), xb, root.getVersion());
                continue;
            }
            if (list.get(i) instanceof SLDNamedLayer) {
                NamedLayerElement.append((SLDNamedLayer)list.get(i), xb, root.getVersion());
                continue;
            }
            throw new UnsupportedSLDObjectException(list.get(i) == null ? "Null" : ((SLDLayer)list.get(i)).getClass().getName(), "Bad layer type");
        }
        xb.closeTag();
    }

    static {
        versions.add("1.0.0");
        versions.add("1.1.0");
    }
}

