/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.FeatureStyleElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UserStyleElement {
    public static void append(SLDUserStyle obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        List fstys;
        xb.openTag("UserStyle");
        if (obj.getName() != null) {
            xb.writeTag("Name", obj.getName());
        }
        if (obj.getTitle() != null) {
            xb.writeTag("Title", obj.getTitle());
        }
        if (obj.getAbstract() != null) {
            xb.writeTag("Abstract", obj.getAbstract());
        }
        if (obj.isDefault() != null) {
            xb.writeTag("IsDefault", obj.isDefault());
        }
        if ((fstys = obj.getFeatureStyles()) == null || fstys.size() == 0) {
            throw new InvalidSLDObjectException("UserStyle", "No feature styles found.");
        }
        for (int i = 0; i < fstys.size(); ++i) {
            FeatureStyleElement.append((SLDFeatureStyle)fstys.get(i), xb, null);
        }
        xb.closeTag();
    }

    public static SLDUserStyle parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "UserStyle");
        int tag = 0;
        SLDUserStyle resp = new SLDUserStyle();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "UserStyle") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Name")) {
                        txt = parser.nextText();
                        resp.setName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Title")) {
                        txt = parser.nextText();
                        resp.setTile(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Abstract") || SLDUtils.isStr(name, "Description")) {
                        txt = parser.nextText();
                        resp.setAbstract(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "IsDefault")) {
                        txt = parser.nextText();
                        resp.setIsDefault(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "FeatureTypeStyle") || SLDUtils.isStr(name, "FeatureStyle")) {
                        SLDFeatureStyle fsty = FeatureStyleElement.parse(parser, version);
                        resp.getFeatureStyles().add(fsty);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in user style: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

