/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.filteroperator;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.comparison.BinaryComparisonOperatorElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.comparison.IsBetweenComparisonElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.comparison.IsLikeComparisonElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.comparison.IsNullComparisonElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.logic.BinaryLogicOperatorElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.logic.UnaryLogicOperatorElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.spatial.BBoxOperatorElement;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.spatial.BinarySpatialOperatorElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDBinaryComparisonOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDIsBetweenOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDIsLikeOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDIsNullOperator;
import org.gvsig.sldsupport.sld.filter.operator.logic.SLDBinaryLogicOperator;
import org.gvsig.sldsupport.sld.filter.operator.logic.SLDUnaryLogicOperator;
import org.gvsig.sldsupport.sld.filter.operator.spatial.SLDBBoxOperator;
import org.gvsig.sldsupport.sld.filter.operator.spatial.SLDBinarySpatialOperator;
import org.gvsig.sldsupport.sld.filter.operator.spatial.SLDDistanceBufferOperator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FilterOperatorElement {
    public static void append(SLDFilterOperator obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj instanceof SLDBBoxOperator) {
            BBoxOperatorElement.append((SLDBBoxOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDBinarySpatialOperator) {
            BinarySpatialOperatorElement.append((SLDBinarySpatialOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDBinaryComparisonOperator) {
            BinaryComparisonOperatorElement.append((SLDBinaryComparisonOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDIsBetweenOperator) {
            IsBetweenComparisonElement.append((SLDIsBetweenOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDIsLikeOperator) {
            IsLikeComparisonElement.append((SLDIsLikeOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDIsNullOperator) {
            IsNullComparisonElement.append((SLDIsNullOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDBinaryLogicOperator) {
            BinaryLogicOperatorElement.append((SLDBinaryLogicOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDUnaryLogicOperator) {
            UnaryLogicOperatorElement.append((SLDUnaryLogicOperator)obj, xb, version);
            return;
        }
        if (obj instanceof SLDDistanceBufferOperator) {
            // empty if block
        }
        throw new UnsupportedSLDObjectException("Unexpected type of SLDFilterOperator.", obj == null ? "Null" : obj.getClass().getName());
    }

    public static SLDFilterOperator parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String name = parser.getName();
        SLDBBoxOperator operator = null;
        if (SLDUtils.isStr(name, "BBOX")) {
            operator = BBoxOperatorElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "Contains") || SLDUtils.isStr(name, "Crosses") || SLDUtils.isStr(name, "Disjoint") || SLDUtils.isStr(name, "Equals") || SLDUtils.isStr(name, "Intersects") || SLDUtils.isStr(name, "Overlaps") || SLDUtils.isStr(name, "Touches") || SLDUtils.isStr(name, "Within")) {
            operator = BinarySpatialOperatorElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, SLDDistanceBufferOperator.DISTANCE_BUFFER_OPERATOR_BEYOND) || SLDUtils.isStr(name, SLDDistanceBufferOperator.DISTANCE_BUFFER_OPERATOR_DWITHIN)) {
            throw new SLDReadException("Distance buffer operator not supported: " + name);
        }
        if (SLDUtils.isStr(name, "PropertyIsEqualTo") || SLDUtils.isStr(name, "PropertyIsNotEqualTo") || SLDUtils.isStr(name, "PropertyIsLessThan") || SLDUtils.isStr(name, "PropertyIsLessThanOrEqualTo") || SLDUtils.isStr(name, "PropertyIsGreaterThan") || SLDUtils.isStr(name, "PropertyIsGreaterThanOrEqualTo")) {
            operator = BinaryComparisonOperatorElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "PropertyIsLike")) {
            operator = IsLikeComparisonElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "PropertyIsNull")) {
            operator = IsNullComparisonElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "PropertyIsBetween")) {
            operator = IsBetweenComparisonElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "And") || SLDUtils.isStr(name, "Or")) {
            operator = BinaryLogicOperatorElement.parse(parser, version);
            return operator;
        }
        if (SLDUtils.isStr(name, "Not")) {
            operator = UnaryLogicOperatorElement.parse(parser, version);
            return operator;
        }
        throw new SLDReadException("Unexpected entity in filter operator: " + name);
    }
}

