/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.raster.lib.legend.api.Transparency;
import org.gvsig.raster.lib.legend.api.TransparencyRange;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultTransparency
implements Transparency {
    private static final String PERSISTENCE_NAME = "transparency";
    private static final String PERSISTENCE_DESCRIPTION = "Transparency persistence description";
    private static final String OPACITY_PERSISTENCE_FIELD = "opacity";
    private static final String TRANSPARENCY_RANGES_PERSISTENCE_FIELD = "transparencyRanges";
    public static final String OPACITY_PROPERTY_NAME = "opacity";
    public static final String TRANSPARENCY_RANGES_PROPERTY_NAME = "transparencyRanges";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int value = 255;
    private List<TransparencyRange> transparencyRanges = new ArrayList<TransparencyRange>();

    public DefaultTransparency() {
    }

    public DefaultTransparency(int transparency, List<TransparencyRange> transparencyRanges) {
        this();
        this.setValue(transparency);
        if (transparencyRanges != null) {
            this.transparencyRanges = transparencyRanges;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public int getAlpha() {
        return this.value;
    }

    public List<TransparencyRange> getTransparencyRanges() {
        return Collections.unmodifiableList(this.transparencyRanges);
    }

    public void addTransparencyRange(TransparencyRange range) {
        if (this.transparencyRanges == null) {
            this.transparencyRanges = new ArrayList<TransparencyRange>();
        }
        List<TransparencyRange> oldTransparencyRanges = this.getTransparencyRanges();
        this.transparencyRanges.add(range);
        this.propertyChangeSupport.firePropertyChange("transparencyRanges", oldTransparencyRanges, this.transparencyRanges);
    }

    public void removeTransparencyRange(TransparencyRange range) {
        if (this.transparencyRanges == null) {
            return;
        }
        List<TransparencyRange> oldTransparencyRanges = this.getTransparencyRanges();
        this.transparencyRanges.remove(range);
        this.propertyChangeSupport.firePropertyChange("transparencyRanges", oldTransparencyRanges, this.transparencyRanges);
    }

    public void setValue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Opacity value has to be between 0 and 255");
        }
        if (value != this.value) {
            this.propertyChangeSupport.firePropertyChange("opacity", this.value, value);
            this.value = value;
        }
    }

    public void setTransparencyRanges(List<TransparencyRange> ranges) {
        this.propertyChangeSupport.firePropertyChange("transparencyRanges", this.transparencyRanges, ranges);
        this.transparencyRanges = ranges;
    }

    public static void registerPersistence() {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        DynStruct definition = persistenceManager.getDefinition(PERSISTENCE_NAME);
        if (definition == null) {
            definition = persistenceManager.addDefinition(DefaultTransparency.class, PERSISTENCE_NAME, PERSISTENCE_DESCRIPTION, null, null);
            definition.addDynFieldInt("opacity").setMandatory(false);
            definition.addDynFieldList("transparencyRanges").setClassOfValue(TransparencyRange.class).setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("opacity", this.value);
        state.set("transparencyRanges", this.transparencyRanges);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.value = state.getInt("opacity");
        this.transparencyRanges = state.getList("transparencyRanges");
    }

    public int getTransparencyRangeAlpha(byte r, byte g, byte b) {
        int red = r;
        int green = g;
        int blue = b;
        if (red < 0) {
            red = 255 + red;
        }
        if (green < 0) {
            green = 255 + green;
        }
        if (blue < 0) {
            blue = 255 + blue;
        }
        return this.getTransparencyRangeAlpha(red, green, blue);
    }

    public int getTransparencyRangeAlpha(int red, int green, int blue) {
        int alpha = 255;
        for (int i = 0; i < this.transparencyRanges.size(); ++i) {
            int alphaRange = 255;
            TransparencyRange tr = this.transparencyRanges.get(i);
            if (tr == null) continue;
            if (tr.isAnd()) {
                if (this.isInRange(tr.getRed(), red) && this.isInRange(tr.getGreen(), green) && this.isInRange(tr.getBlue(), blue)) {
                    alphaRange = tr.getAlpha();
                }
            } else {
                if (!this.isInRange(tr.getRed(), red) && !this.isInRange(tr.getGreen(), green) && !this.isInRange(tr.getBlue(), blue)) continue;
                alphaRange = tr.getAlpha();
            }
            alpha = alpha * alphaRange / 255;
        }
        return alpha;
    }

    private boolean isInRange(int[] range, int value) {
        if (range == null) {
            return true;
        }
        if (range[0] < 0 && value <= range[1]) {
            return true;
        }
        if (range[1] < 0 && value >= range[0]) {
            return true;
        }
        if (range[0] < 0 && range[1] < 0) {
            return true;
        }
        return value >= range[0] && value <= range[1];
    }
}

