/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.io;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.io.GimpPaletteColorTableIO;

public class GimpPaletteColorTableIOFactory
implements ColorTableIOFactory {
    private static final String DEFAULT_EXTENSION = "gpl";
    private static final String DESCRIPTION = "Gimp Palette";

    public String getName() {
        return "GimpPaletteColorTableIO";
    }

    public ColorTableIO create() {
        return new GimpPaletteColorTableIO();
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FilenameUtils.getExtension((String)file.getAbsolutePath());
        return extension.equalsIgnoreCase(DEFAULT_EXTENSION);
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

