/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisEntitySelectorControllerJComboBox
extends AbstractDisposable
implements VCSGisEntitySelectorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisEntitySelectorControllerJComboBox.class);
    private final JComboBox cboTables;
    private final ActionListenerSupport actionListeners;
    private final ChangeListenerHelper changeListeners;
    private VCSGisWorkspace workspace;
    private boolean processing;
    private boolean enabled;
    private ArrayList<VCSGisEntity> entities;
    private Predicate<VCSGisEntity> viewFilter;
    private Predicate<VCSGisEntity> filter;
    private Thread lastThread;
    private Function<VCSGisEntity, String> labelEntityFormatter;

    public VCSGisEntitySelectorControllerJComboBox(JComboBox cboTables) {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.viewFilter = ALL_ENTITIES;
        this.filter = ALL_ENTITIES;
        this.cboTables = cboTables;
        this.processing = false;
        this.actionListeners = toolsSwingManager.createActionListenerSupport();
        this.changeListeners = toolsSwingManager.createChangeListenerHelper();
        this.initComponents();
    }

    private void initComponents() {
        this.cboTables.addItemListener(new ItemListener(){
            boolean alreadyInEvent = false;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        this.alreadyInEvent = true;
                        VCSGisEntitySelectorControllerJComboBox.this.fireChangeEvent();
                        VCSGisEntitySelectorControllerJComboBox.this.fireActionEvent(new ActionEvent(this, 0, "select"));
                    }
                    finally {
                        this.alreadyInEvent = false;
                    }
                }
            }
        });
        this.cboTables.setRenderer(new ListCellRenderer(){
            JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof VCSGisEntity && VCSGisEntitySelectorControllerJComboBox.this.workspace != null) {
                    this.label.setText(VCSGisEntitySelectorControllerJComboBox.this.workspace.formatEntityLabel((VCSGisEntity)value));
                } else {
                    this.label.setText(Objects.toString(value, null));
                }
                return this.label;
            }
        });
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public VCSGisEntity getSelectedEntity() {
        if (this.workspace == null) {
            return null;
        }
        LabeledValue selected = (LabeledValue)this.cboTables.getSelectedItem();
        if (selected == null) {
            return null;
        }
        VCSGisEntity entity = (VCSGisEntity)selected.getValue();
        if (!this.filter.test(entity)) {
            return null;
        }
        return entity;
    }

    public void setSelectedEntity(VCSGisEntity entity) {
        if (this.workspace == null) {
            return;
        }
        ComboBoxModel model = this.cboTables.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            VCSGisEntity value = (VCSGisEntity)((LabeledValue)model.getElementAt(i)).getValue();
            if (!StringUtils.equals((CharSequence)entity.getEntityCode(), (CharSequence)value.getEntityCode())) continue;
            this.cboTables.setSelectedIndex(i);
            return;
        }
    }

    public List<VCSGisEntity> getCheckedEntities() {
        return Collections.EMPTY_LIST;
    }

    public void setWorkspace(VCSGisWorkspace workspace) {
        DisposeUtils.disposeQuietly((Disposable)workspace);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.reloadEntities();
    }

    public VCSGisWorkspace getWorkspace() {
        return this.workspace;
    }

    public void reloadEntities() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.cboTables.setModel(model);
        if (this.workspace == null) {
            return;
        }
        Thread task = new Thread(() -> this.reloadTables(this.workspace), "VCSGisEntitySelectorComboReloadEntities");
        task.start();
        this.lastThread = task;
    }

    private boolean isCancelled() {
        return Thread.currentThread() != this.lastThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTables(VCSGisWorkspace workspace) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            LabeledValueImpl entry;
            String s;
            this.fireActionEvent(new ActionEvent((Object)this, 3, "begin_processing"));
            this.processing = true;
            this.doUpdateComponents();
            workspace.updateEntitiesFromRepository();
            List repoEntities = workspace.getRepositoryEntities();
            ArrayList<LabeledValue<VCSGisEntity>> theEntities = new ArrayList<LabeledValue<VCSGisEntity>>();
            for (VCSGisEntity rentity : repoEntities) {
                if (this.isCancelled()) {
                    return;
                }
                VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntityByCode(rentity.getEntityCode());
                s = VCSGisSwingCommons.getHTMLColorTag(lentity == null ? 32 : lentity.getState(), this.getLabelOfEntity(rentity));
                if (lentity != null && this.viewFilter.test((VCSGisEntity)lentity)) {
                    entry = new LabeledValueImpl(s, (Object)lentity);
                    theEntities.add((LabeledValue<VCSGisEntity>)entry);
                    continue;
                }
                if (!this.viewFilter.test(rentity)) continue;
                entry = new LabeledValueImpl(s, (Object)rentity);
                theEntities.add((LabeledValue<VCSGisEntity>)entry);
            }
            List localEntities = workspace.getWorkspaceEntities();
            for (VCSGisWorkspaceEntity localEntity : localEntities) {
                if (this.isCancelled()) {
                    return;
                }
                if (!StringUtils.isBlank((CharSequence)localEntity.getRepositoryRevisionCode()) || !this.viewFilter.test((VCSGisEntity)localEntity)) continue;
                s = VCSGisSwingCommons.getHTMLColorTag(localEntity.getState(), this.getLabelOfEntity((VCSGisEntity)localEntity));
                entry = new LabeledValueImpl(s, (Object)localEntity);
                theEntities.add((LabeledValue<VCSGisEntity>)entry);
            }
            Collections.sort(theEntities, (o1, o2) -> StringUtils.compareIgnoreCase((String)((VCSGisEntity)o1.getValue()).getLabelOrName(), (String)((VCSGisEntity)o2.getValue()).getLabelOrName()));
            if (!this.isCancelled()) {
                this.postReloadTables(theEntities);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_retrieve_entities_from_repository", (Throwable)e);
            if (!this.isCancelled()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_entities_from_repository") + "\n" + e.getMessage(), i18n.getTranslation("_VCS_Checkout"), 2);
            }
        }
        finally {
            if (!this.isCancelled()) {
                this.processing = false;
                this.doUpdateComponents();
                this.fireActionEvent(new ActionEvent((Object)this, 4, "end_processing"));
            }
        }
    }

    private void postReloadTables(List<LabeledValue<VCSGisEntity>> entities) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postReloadTables(entities))) {
            return;
        }
        this.entities = new ArrayList();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(new LabeledValueImpl("", null));
        for (LabeledValue<VCSGisEntity> entity : entities) {
            if (entity == null) continue;
            this.entities.add((VCSGisEntity)entity.getValue());
            model.addElement(entity);
        }
        this.cboTables.setModel(model);
        this.processing = false;
        this.fireActionEvent(new ActionEvent((Object)this, 2, "reload"));
    }

    public Collection<VCSGisEntity> getEntities() {
        return this.entities;
    }

    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.cboTables.setEnabled(this.enabled && !this.processing);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.doUpdateComponents();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecksEnabled(boolean enabled) {
    }

    public boolean isChecksEnabled() {
        return false;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListeners.fireActionEvent(ae);
    }

    private void fireChangeEvent() {
        this.changeListeners.fireEvent();
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void setViewFilter(Predicate<VCSGisEntity> viewFilter) {
        this.viewFilter = viewFilter;
        this.reloadEntities();
    }

    public void setFilter(Predicate<VCSGisEntity> filter) {
        this.filter = filter;
        this.reloadEntities();
    }

    public void check(VCSGisEntity entity) {
    }

    public void unCheck(VCSGisEntity entity) {
    }

    public void clearChecks() {
    }

    public void setCheck(Collection<String> entityCodes, boolean check) {
    }

    public void checkAll() {
    }

    public void clear() {
        this.setWorkspace(null);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
    }

    private String getLabelOfEntity(VCSGisEntity entity) {
        if (this.labelEntityFormatter == null) {
            return entity.getLabelOrName();
        }
        return this.labelEntityFormatter.apply(entity);
    }

    public void setLabelEntityFormatter(Function<VCSGisEntity, String> formatter) {
        this.labelEntityFormatter = formatter;
    }

    public String getCategory(VCSGisEntity entity) {
        String category = entity.getFirstCategory();
        return category;
    }

    public void collapseAll() {
    }

    public void expandAll() {
    }
}

