/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import javax.swing.table.AbstractTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;

public class LocalChangesTableModel
extends AbstractTableModel {
    private final VCSGisWorkspaceChanges<VCSGisChange> changes;
    private final VCSGisWorkspace ws;
    private static String[] columnNames;
    private static final Class<?>[] COLUMNCLASS;

    public LocalChangesTableModel(VCSGisWorkspace ws) {
        this(null, ws);
    }

    public LocalChangesTableModel(VCSGisWorkspaceChanges changes, VCSGisWorkspace ws) {
        this.ws = ws;
        I18nManager i18n = ToolsLocator.getI18nManager();
        columnNames = new String[]{i18n.getTranslation("select"), i18n.getTranslation("table"), i18n.getTranslation("operation"), i18n.getTranslation("label"), i18n.getTranslation("code")};
        this.changes = changes;
        if (this.changes != null) {
            this.changes.addChangeListener(e -> this.fireTableDataChanged());
        }
    }

    @Override
    public int getRowCount() {
        if (this.changes == null) {
            return 0;
        }
        try {
            return (int)this.changes.size64();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisChange row = (VCSGisChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.isSelected();
            }
            case 1: {
                VCSGisEntity entity = this.ws.getEntity(row.getEntityCode());
                if (entity == null) {
                    return "unknown (" + row.getEntityCode() + ")";
                }
                return this.ws.getEntity(row.getEntityCode()).getEntityName();
            }
            case 2: {
                int op = row.getOperation();
                return i18n.getTranslation(VCSGisSwingCommons.getOperationLabel(op));
            }
            default: {
                return row.getLabel();
            }
            case 4: 
        }
        return row.getRelatedFeatureCode();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return;
        }
        VCSGisChange row = (VCSGisChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                Boolean selected = (Boolean)aValue;
                if (selected.booleanValue()) {
                    this.changes.addSelectionInterval((long)rowIndex, (long)rowIndex);
                    break;
                }
                this.changes.removeSelectionInterval((long)rowIndex, (long)rowIndex);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNCLASS[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    static {
        COLUMNCLASS = new Class[]{Boolean.class, String.class, Integer.class, String.class, String.class};
    }
}

