/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryChange;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.changes.RemoteChangesTableModel;
import org.gvsig.vcsgis.swing.impl.changes.VCSGisJChangesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteChangesController
extends AbstractDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChangesController.class);
    private final PickerController<VCSGisWorkspace> workspacePicker;
    private final JTable tblRemoteChanges;
    private final JButton btnRemoteShowForm;
    private final JButton btnRemoteUpdate;
    private final JButton btnRemoteMerge;
    private final JButton btnRemoteReloadChanges;
    private final JButton btnRemoteCheckAll;
    private final JButton btnRemoteUnCheckAll;
    private final JButton btnRemoteExpandAllEntities;
    private final JButton btnRemoteCollapseAllEntities;
    private final JTree treeRepositoryTables;
    private final JTextComponent txtRepositoryTablesFilter;
    private final JButton btnRepositoryTablesFilter;
    private VCSGisWorkspaceChanges<VCSGisRepositoryChange> changes;
    private final JButton btnRemoteTablesReload;
    private final JButton btnRemoteDownloadChanges;
    private final JButton btnRemoteCleanChanges;
    private final VCSGisJChangesImpl context;
    private final JButton btnRemoteZoom;
    private final JButton btnRemoteCenter;
    private final JButton btnRemoteHighlight;
    private final JButton btnRemoteCheckout;
    private final JButton btnRemoteCheckoutOverwrite;
    private final JButton btnRemoteCleanHighligthed;
    private final JLabel lblRemoteChangesCount;
    private VCSGisEntitySelectorController entitySelector;
    private final JButton btnRemoteCheckRecomendedEntities;
    private final JButton btnRemoteUnCheckAllEntities;

    public RemoteChangesController(VCSGisJChangesImpl context, PickerController<VCSGisWorkspace> workspacePicker, JTree treeRepositoryTables, JTextComponent txtRepositoryTablesFilter, JButton btnRepositoryTablesFilter, JButton btnRemoteTablesReload, JTable tblRemoteChanges, JButton btnRemoteCheckAll, JButton btnRemoteUnCheckAll, JButton btnRemoteExpandAllEntities, JButton btnRemoteCollapseAllEntities, JButton btnRemoteDownloadChanges, JButton btnRemoteReloadChanges, JButton btnRemoteCleanChanges, JButton btnRemoteUpdate, JButton btnRemoteMerge, JButton btnRemoteShowForm, JButton btnRemoteZoom, JButton btnRemoteCenter, JButton btnRemoteHighlight, JButton btnRemoteCheckout, JButton btnRemoteCheckoutOverwrite, JButton btnRemoteCleanHighligthed, JLabel lblRemoteChangesCount, JButton btnRemoteCheckRecomendedEntities, JButton btnRemoteUnCheckAllEntities) {
        this.context = context;
        this.workspacePicker = workspacePicker;
        this.treeRepositoryTables = treeRepositoryTables;
        this.txtRepositoryTablesFilter = txtRepositoryTablesFilter;
        this.btnRepositoryTablesFilter = btnRepositoryTablesFilter;
        this.btnRemoteTablesReload = btnRemoteTablesReload;
        this.tblRemoteChanges = tblRemoteChanges;
        this.btnRemoteCheckAll = btnRemoteCheckAll;
        this.btnRemoteUnCheckAll = btnRemoteUnCheckAll;
        this.btnRemoteExpandAllEntities = btnRemoteExpandAllEntities;
        this.btnRemoteCollapseAllEntities = btnRemoteCollapseAllEntities;
        this.btnRemoteDownloadChanges = btnRemoteDownloadChanges;
        this.btnRemoteCleanChanges = btnRemoteCleanChanges;
        this.btnRemoteReloadChanges = btnRemoteReloadChanges;
        this.btnRemoteUpdate = btnRemoteUpdate;
        this.btnRemoteMerge = btnRemoteMerge;
        this.btnRemoteShowForm = btnRemoteShowForm;
        this.btnRemoteZoom = btnRemoteZoom;
        this.btnRemoteCenter = btnRemoteCenter;
        this.btnRemoteHighlight = btnRemoteHighlight;
        this.btnRemoteCheckout = btnRemoteCheckout;
        this.btnRemoteCheckoutOverwrite = btnRemoteCheckoutOverwrite;
        this.btnRemoteCleanHighligthed = btnRemoteCleanHighligthed;
        this.lblRemoteChangesCount = lblRemoteChangesCount;
        this.btnRemoteCheckRecomendedEntities = btnRemoteCheckRecomendedEntities;
        this.btnRemoteUnCheckAllEntities = btnRemoteUnCheckAllEntities;
        this.initComponents();
    }

    public void alert(String msg) {
        this.context.alert(msg);
    }

    public void message(String msg) {
        this.context.message(msg);
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.btnRemoteCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCleanChanges.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteDownloadChanges.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteMerge.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteReloadChanges.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteShowForm.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteTablesReload.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteUnCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteUpdate.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteZoom.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCenter.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteHighlight.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCheckout.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCheckoutOverwrite.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRemoteCleanHighligthed.setCursor(Cursor.getPredefinedCursor(12));
        this.translate();
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.treeRepositoryTables, this.txtRepositoryTablesFilter, this.btnRepositoryTablesFilter);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addChangeListener(e -> this.doReloadChanges());
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 0: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.doReloadChanges();
                    this.doUpdateComponents();
                    break;
                }
                case 2: {
                    this.doReloadChanges();
                    this.doUpdateComponents();
                }
            }
        });
        this.btnRemoteTablesReload.addActionListener(e -> {
            this.doReloadTables();
            this.doReloadChanges();
        });
        this.tblRemoteChanges.getSelectionModel().setSelectionMode(2);
        this.tblRemoteChanges.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    RemoteChangesController.this.doToggleSelection();
                }
            }
        });
        this.tblRemoteChanges.getSelectionModel().addListSelectionListener(e -> this.context.doUpdateComponents());
        this.btnRemoteCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doCheckAll();
                this.doReloadChanges();
            }
        });
        this.btnRemoteUnCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doUnCheckAll();
                this.doReloadChanges();
            }
        });
        this.btnRemoteCollapseAllEntities.addActionListener(e -> this.entitySelector.collapseAll());
        this.btnRemoteExpandAllEntities.addActionListener(e -> this.entitySelector.expandAll());
        this.btnRemoteDownloadChanges.addActionListener(e -> this.doDownloadChangesOfSelectedTable());
        this.btnRemoteReloadChanges.addActionListener(e -> this.doReloadTables());
        this.btnRemoteCleanChanges.addActionListener(e -> {
            this.doCleanChanges();
            this.doReloadChanges();
        });
        this.btnRemoteUpdate.addActionListener(e -> this.doUpdate());
        this.btnRemoteMerge.addActionListener(e -> this.doMerge());
        this.btnRemoteShowForm.addActionListener(e -> this.doShowForm());
        this.btnRemoteZoom.addActionListener(e -> this.doZoomToSelectedChange());
        this.btnRemoteCenter.addActionListener(e -> this.doCenterToSelectedChange());
        this.btnRemoteHighlight.addActionListener(e -> this.doHighLightSelectedChange());
        this.btnRemoteCleanHighligthed.addActionListener(e -> VCSGisSwingCommons.cleanHighligthed());
        this.btnRemoteCheckout.addActionListener(e -> this.doCheckout(false));
        this.btnRemoteCheckoutOverwrite.addActionListener(e -> {
            if (this.askUserOverwriteSelectedTables()) {
                this.doCheckout(true);
            }
        });
        this.btnRemoteCheckRecomendedEntities.addActionListener(e -> this.doCheckRecomendedEntities());
        this.btnRemoteUnCheckAllEntities.addActionListener(e -> this.entitySelector.clearChecks());
        this.context.doUpdateComponents();
        SwingUtilities.invokeLater(() -> {
            this.message(i18n.getTranslation("_Ready"));
            this.lblRemoteChangesCount.setText("");
        });
    }

    private boolean askUserOverwriteSelectedTables() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        int n = dialogs.confirmDialog(i18n.getTranslation("_Are_you_sure_you_want_to_overwrite_the_selected_tables"), i18n.getTranslation("_VCSGis_Checkout_overwrite"), 0, 3);
        return n == 0;
    }

    public void doChangeWorkspace() {
        VCSGisWorkspace ws = this.context.getWorkspace();
        this.entitySelector.setWorkspace(ws);
        if (ws != null) {
            for (String tableName : this.context.getDefaultTablesSelection()) {
                VCSGisWorkspaceEntity entity = ws.getWorkspaceEntity(tableName);
                if (entity == null) continue;
                this.entitySelector.check((VCSGisEntity)entity);
            }
        }
        this.doReloadChanges();
    }

    public void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnRemoteCheckAll);
        swingManager.translate((AbstractButton)this.btnRemoteUpdate);
        swingManager.translate((AbstractButton)this.btnRemoteCleanChanges);
        swingManager.translate((AbstractButton)this.btnRemoteReloadChanges);
        swingManager.translate((AbstractButton)this.btnRemoteMerge);
        swingManager.translate((AbstractButton)this.btnRemoteShowForm);
        swingManager.translate((AbstractButton)this.btnRemoteUnCheckAll);
        swingManager.translate((AbstractButton)this.btnRemoteTablesReload);
        swingManager.translate((AbstractButton)this.btnRemoteDownloadChanges);
        swingManager.translate((AbstractButton)this.btnRemoteCenter);
        swingManager.translate((AbstractButton)this.btnRemoteHighlight);
        swingManager.translate((AbstractButton)this.btnRemoteZoom);
        swingManager.translate((AbstractButton)this.btnRemoteCheckout);
        swingManager.translate((AbstractButton)this.btnRemoteCheckoutOverwrite);
        swingManager.translate((AbstractButton)this.btnRemoteCleanHighligthed);
        swingManager.translate((AbstractButton)this.btnRemoteCheckRecomendedEntities);
        swingManager.translate((AbstractButton)this.btnRemoteUnCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnRemoteCollapseAllEntities);
        swingManager.translate((AbstractButton)this.btnRemoteExpandAllEntities);
    }

    private VCSGisWorkspace getUndisposableWorkspace() {
        VCSGisWorkspace ws = this.context.getWorkspace();
        DisposeUtils.disposeQuietly((Disposable)ws);
        return ws;
    }

    void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        try {
            VCSGisRepositoryChange change;
            this.context.setVisibleStatus(this.context.processing);
            this.context.btnClose.setEnabled(!this.context.processing);
            VCSGisWorkspace ws = this.getUndisposableWorkspace();
            List checkedEntities = this.entitySelector.getCheckedEntities();
            boolean hasLocalTables = false;
            boolean hasRemoteTables = false;
            for (VCSGisEntity checkedEntity : checkedEntities) {
                if (ws.getWorkspaceEntityByName(checkedEntity.getEntityName()) != null) {
                    hasLocalTables = true;
                    continue;
                }
                hasRemoteTables = true;
            }
            this.btnRemoteCheckAll.setEnabled(!this.context.processing && this.changes != null);
            this.btnRemoteUnCheckAll.setEnabled(!this.context.processing && this.changes != null);
            this.btnRemoteDownloadChanges.setEnabled(!this.context.processing && ws != null && hasLocalTables);
            this.btnRemoteCheckout.setEnabled(!this.context.processing && ws != null && hasRemoteTables && !hasLocalTables);
            this.btnRemoteCheckoutOverwrite.setEnabled(!this.context.processing && ws != null && (hasRemoteTables || hasLocalTables));
            this.btnRemoteReloadChanges.setEnabled(!this.context.processing && ws != null && hasLocalTables);
            this.btnRemoteCleanChanges.setEnabled(!this.context.processing && ws != null && hasLocalTables);
            this.btnRemoteTablesReload.setEnabled(!this.context.processing);
            this.btnRemoteTablesReload.setEnabled(!this.context.processing && ws != null);
            boolean enableShowForm = false;
            int row = this.tblRemoteChanges.getSelectedRow();
            if (row >= 0 && (change = (VCSGisRepositoryChange)this.changes.get64((long)row)).getOperation() != 3) {
                enableShowForm = true;
            }
            this.btnRemoteShowForm.setEnabled(!this.context.processing && enableShowForm);
            this.entitySelector.setEnabled(!this.context.processing);
            this.tblRemoteChanges.setEnabled(!this.context.processing);
            this.workspacePicker.setEnabled(!this.context.processing);
            if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                this.btnRemoteMerge.setEnabled(false);
                this.btnRemoteUpdate.setEnabled(false);
            } else {
                VCSGisEntity checkedEntity3;
                MutableObject msg = new MutableObject();
                Iterator iterator = checkedEntities.iterator();
                while (iterator.hasNext() && ws.canUpdate(msg, (checkedEntity3 = (VCSGisEntity)iterator.next()).getEntityName())) {
                }
                if (msg.getValue() != null) {
                    this.btnRemoteDownloadChanges.setEnabled(false);
                    this.btnRemoteCheckout.setEnabled(false);
                    this.btnRemoteCheckoutOverwrite.setEnabled(false);
                    this.btnRemoteMerge.setEnabled(false);
                    this.btnRemoteUpdate.setEnabled(false);
                    this.alert((String)msg.getValue());
                } else if (checkedEntities.size() == 1) {
                    VCSGisEntity checkedEntity2 = (VCSGisEntity)checkedEntities.get(0);
                    if (ws.updateNeedMerge(checkedEntity2.getEntityName())) {
                        this.btnRemoteMerge.setEnabled(!this.context.processing);
                        this.btnRemoteUpdate.setEnabled(false);
                    } else {
                        this.btnRemoteMerge.setEnabled(false);
                        this.btnRemoteUpdate.setEnabled(!this.context.processing && this.changes != null && !this.changes.isSelectionEmpty());
                    }
                } else {
                    this.btnRemoteMerge.setEnabled(false);
                    this.btnRemoteUpdate.setEnabled(!this.context.processing && this.changes != null && !this.changes.isSelectionEmpty());
                    for (VCSGisEntity checkedEntity3 : checkedEntities) {
                        if (!ws.updateNeedMerge(checkedEntity3.getEntityName())) continue;
                        this.btnRemoteMerge.setEnabled(!this.context.processing);
                        this.btnRemoteUpdate.setEnabled(false);
                        break;
                    }
                }
            }
            Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
            Geometry wsGeom = this.getWorkspaceGeometryOfSelectedChange();
            Geometry bbox = VCSGisSwingCommons.createBBox(repoGeom, wsGeom);
            this.btnRemoteZoom.setEnabled(!this.context.processing && bbox != null);
            this.btnRemoteCenter.setEnabled(!this.context.processing && bbox != null);
            this.btnRemoteHighlight.setEnabled(!this.context.processing && bbox != null);
            this.btnRemoteCleanHighligthed.setEnabled(!this.context.processing);
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Changes", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
    }

    private void doToggleSelection() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                Iterator<Long> rows = this.getChangesSelectionIterator();
                this.changes.process(rows, change -> {
                    change.setSelected(!change.isSelected());
                    return true;
                });
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisToggleSelectionRemoteChanges");
        task.start();
    }

    private Iterator<Long> getChangesSelectionIterator() {
        final ListSelectionModel selection = this.tblRemoteChanges.getSelectionModel();
        return new Iterator<Long>(){
            long n;
            {
                this.n = selection.getMinSelectionIndex();
            }

            @Override
            public boolean hasNext() {
                while (this.n <= (long)selection.getMaxSelectionIndex()) {
                    if (selection.isSelectedIndex((int)this.n)) {
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }

            @Override
            public Long next() {
                if (this.n > (long)selection.getMaxSelectionIndex()) {
                    throw new IllegalStateException();
                }
                return this.n++;
            }
        };
    }

    private Iterator<Long> getRowsIterator() {
        final long size = this.changes.size64();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                return this.n < size;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    private void doCheckAll() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                Iterator<Long> rows = this.getRowsIterator();
                this.changes.process(rows, change -> {
                    change.setSelected(true);
                    return true;
                });
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisCheckAllRemoteChanges");
        task.start();
    }

    private void doUnCheckAll() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                Iterator<Long> rows = this.getRowsIterator();
                this.changes.process(rows, change -> {
                    change.setSelected(false);
                    return true;
                });
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisCheckAllRemoteChanges");
        task.start();
    }

    private void doUpdate() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return;
        }
        this.tblRemoteChanges.setModel(new RemoteChangesTableModel(ws));
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Download_changes");
        Thread task = new Thread(() -> {
            try {
                VCSGisEntity checkedEntity;
                taskStatus.setAutoremove(true);
                taskStatus.add();
                this.context.setTaskStatus(taskStatus);
                this.context.processing = true;
                this.context.doUpdateComponents();
                int r = 0;
                Iterator iterator = checkedEntities.iterator();
                while (iterator.hasNext() && (r = ws.update((checkedEntity = (VCSGisEntity)iterator.next()).getEntityName(), taskStatus)) == 0) {
                }
                this.doPostUpdate(checkedEntities, r);
                taskStatus.terminate();
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                taskStatus.abort();
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisUpdate");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
    }

    private void doPostUpdate(List<VCSGisEntity> checkedEntities, int updateStatus) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostUpdate(checkedEntities, updateStatus))) {
            return;
        }
        if (updateStatus == 0) {
            this.context.setVisibleStatus(false);
        }
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        this.doReloadChanges();
        for (VCSGisEntity checkedEntity : checkedEntities) {
            FeatureStore store = ws.getFeatureStore(checkedEntity.getEntityName());
            VCSGisSwingCommons.refreshDocument(store);
        }
        this.context.doUpdateComponents();
        this.context.updateLocalChangesTable();
        VCSGisSwingCommons.cleanHighligthed();
    }

    private void doMerge() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return;
        }
        this.tblRemoteChanges.setModel(new RemoteChangesTableModel(ws));
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                MutableLong localChangesCreated = new MutableLong(0L);
                ArrayList<VCSGisEntity> entitiesWithLocalChanges = new ArrayList<VCSGisEntity>();
                int r = 0;
                for (VCSGisEntity entity : checkedEntities) {
                    String tableName = entity.getEntityName();
                    Long lchanges = localChangesCreated.getValue();
                    r = this.getUndisposableWorkspace().merge(tableName, localChangesCreated, this.context.getTaskStatusController().getSimpleTaskStatus());
                    if (r != 0) break;
                    if (lchanges == localChangesCreated.getValue()) continue;
                    entitiesWithLocalChanges.add(entity);
                }
                this.doPostMerge(checkedEntities, entitiesWithLocalChanges, r, localChangesCreated.getValue());
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisMerge");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
    }

    private void doPostMerge(List<VCSGisEntity> checkedEntities, List<VCSGisEntity> entitiesWithLocalChanges, int mergeStatus, long localChangesCreated) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostMerge(checkedEntities, entitiesWithLocalChanges, mergeStatus, localChangesCreated))) {
            return;
        }
        if (mergeStatus == 0) {
            this.context.setVisibleStatus(false);
        }
        this.doReloadChanges();
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        for (VCSGisEntity entity : checkedEntities) {
            FeatureStore store = ws.getFeatureStore(entity.getEntityName());
            VCSGisSwingCommons.refreshDocument(store);
        }
        if (localChangesCreated > 0L) {
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            dialogsManager.messageDialog(i18n.getTranslation("_The_process_has_modified_local_changes_that_would_need_to_be_committed_to_the_repository"), null, i18n.getTranslation("_VCSGis_Merge"), 1, "VCSGIS_merge_need_commit");
            this.context.selectTab(0);
            this.context.selectOnlyALocalEntity(entitiesWithLocalChanges);
        }
        this.context.doUpdateComponents();
        this.context.updateLocalChangesTable();
        VCSGisSwingCommons.cleanHighligthed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowForm() {
        if (this.changes == null) {
            return;
        }
        int row = this.tblRemoteChanges.getSelectedRow();
        VCSGisRepositoryChange change = (VCSGisRepositoryChange)this.changes.get64((long)row);
        if (change.getOperation() == 0) {
            return;
        }
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        VCSGisWorkspaceEntity entity = ws.getWorkspaceEntityByCode(change.getEntityCode());
        if (entity == null) {
            VCSGisEntity repoEntity = ws.getEntity(change.getEntityCode());
            FeatureType featureType = repoEntity.getFeatureType();
            JDynForm form = DynFormLocator.getDynFormManager().createJDynForm((DynStruct)featureType);
            DynObject values = ToolsLocator.getDynObjectManager().createDynObject((DynStruct)featureType);
            Json.addAll((DynObject)values, (JsonObject)change.getRelatedFeatureDataAsJson());
            form.setValues(values);
            form.setReadOnly(true);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Remote change: " + change.getLabel(), WindowManager.MODE.WINDOW);
            return;
        }
        FeatureStore store = null;
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            store = ws.openFeatureStore(entity.getEntityName(), false);
            EditableFeature feature = store.createNewFeature(change.getRelatedFeatureDataAsJson());
            JFeatureForm form = dataSwingManager.createJFeatureForm((Feature)feature);
            form.getDynForm().setReadOnly(true);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Remote change: " + change.getLabel(), WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't show form for change '" + change.getCode() + "'.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    private void doReloadChanges() {
        List checkedEntities;
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        if (this.changes != null) {
            this.changes.removeAllChangeListener();
        }
        if (CollectionUtils.isEmpty((Collection)(checkedEntities = this.entitySelector.getCheckedEntities()))) {
            this.changes = null;
            this.tblRemoteChanges.setModel(new DefaultTableModel());
            this.lblRemoteChangesCount.setText("0");
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.message("Reloading list of remote changes...");
        this.changes = ws.getRemoteChangesByEntity((String[])checkedEntities.stream().map(t -> t.getEntityName()).toArray(String[]::new));
        this.changes.addChangeListener(e -> this.context.doUpdateComponents());
        RemoteChangesTableModel changesModel = new RemoteChangesTableModel(this.changes, ws);
        this.tblRemoteChanges.setModel(changesModel);
        int columns = this.tblRemoteChanges.getColumnModel().getColumnCount();
        for (int i = 1; i < columns; ++i) {
            this.tblRemoteChanges.getColumnModel().getColumn(i).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    VCSGisChange changeRow = (VCSGisChange)RemoteChangesController.this.changes.get64((long)row);
                    VCSGisSwingCommons.setColorCompoment(c, changeRow.getStatus());
                    return c;
                }
            });
        }
        this.context.doUpdateComponents();
        this.context.message(i18n.getTranslation("_Repository_changes_list_updated", new String[]{String.valueOf(this.changes.size64())}));
        this.lblRemoteChangesCount.setText(String.valueOf(this.changes.size64()));
    }

    private List<VCSGisEntity> getWorkspaceCheckedEntities() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return null;
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return null;
        }
        ArrayList<VCSGisEntity> workspaceCheckedEntities = new ArrayList<VCSGisEntity>();
        for (VCSGisEntity entity : checkedEntities) {
            if (ws.getWorkspaceEntityByCode(entity.getEntityCode()) == null) continue;
            workspaceCheckedEntities.add(entity);
        }
        if (CollectionUtils.isEmpty(workspaceCheckedEntities)) {
            return null;
        }
        return workspaceCheckedEntities;
    }

    private List<VCSGisEntity> getRepositoryCheckedEntities() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return null;
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
            return null;
        }
        ArrayList<VCSGisEntity> workspaceCheckedEntities = new ArrayList<VCSGisEntity>();
        for (VCSGisEntity entity : checkedEntities) {
            if (ws.getWorkspaceEntityByCode(entity.getEntityCode()) != null) continue;
            workspaceCheckedEntities.add(entity);
        }
        if (CollectionUtils.isEmpty(workspaceCheckedEntities)) {
            return null;
        }
        return workspaceCheckedEntities;
    }

    private void doCleanChanges() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List<VCSGisEntity> entitiesToCleanChanges = this.getWorkspaceCheckedEntities();
        if (CollectionUtils.isEmpty(entitiesToCleanChanges)) {
            return;
        }
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                for (VCSGisEntity checkedEntity : entitiesToCleanChanges) {
                    this.message("Removing list of remote changes from selected tables" + checkedEntity.getEntityName() + "...");
                    ws.updateClean(checkedEntity.getEntityName());
                }
                this.message("Ready.");
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisUpdateClean");
        task.start();
    }

    private void doDownloadChangesOfSelectedTable() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List<VCSGisEntity> entitiesToUpdate = this.getWorkspaceCheckedEntities();
        if (CollectionUtils.isEmpty(entitiesToUpdate)) {
            return;
        }
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Download changes");
        Thread task = new Thread(() -> {
            try {
                taskStatus.setAutoremove(true);
                taskStatus.add();
                taskStatus.setRangeOfValues(0L, (long)entitiesToUpdate.size());
                taskStatus.setCurValue(0L);
                this.context.setTaskStatus(taskStatus);
                this.context.processing = true;
                this.context.doUpdateComponents();
                for (VCSGisEntity entity : entitiesToUpdate) {
                    taskStatus.setTitle("Download changes - " + entity.getLabel());
                    this.message("Removing list of remote changes of " + entity.getEntityName() + "...");
                    ws.updateClean(entity.getEntityName());
                    this.message("Downloading list of remote changes of " + entity.getEntityName() + "...");
                    ws.updatePrepare(entity.getEntityName(), taskStatus);
                    taskStatus.incrementCurrentValue();
                }
                this.message("Updating metadata information");
                ws.clearRepositoryEntitiesCached();
                ws.updateEntitiesFromRepository();
                this.context.updateLocalChangesTable();
                taskStatus.terminate();
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                taskStatus.abort();
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
                this.doReloadChanges();
            }
        }, "VCSGisUpdatePrepare");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
        this.message("_Ready");
    }

    private void doReloadTables() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            this.entitySelector.setWorkspace(null);
            return;
        }
        this.entitySelector.reloadEntities();
    }

    public boolean isProcessing() {
        return this.context.processing;
    }

    private Geometry getRepositoryGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            if (this.tblRemoteChanges.getSelectedRowCount() > 1 && this.tblRemoteChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblRemoteChanges.getSelectedRows()) {
                    VCSGisRepositoryChange change = (VCSGisRepositoryChange)this.changes.get64((long)selectedRow);
                    Geometry currentGeom = change.getGeometry();
                    if (currentGeom == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                int selected = this.tblRemoteChanges.getSelectedRow();
                if (selected >= 0) {
                    VCSGisRepositoryChange change = (VCSGisRepositoryChange)this.changes.get64((long)selected);
                    geom = change.getGeometry();
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private Geometry getWorkspaceGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            VCSGisWorkspace ws = this.getUndisposableWorkspace();
            if (this.tblRemoteChanges.getSelectedRowCount() > 1 && this.tblRemoteChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblRemoteChanges.getSelectedRows()) {
                    Geometry currentGeom;
                    VCSGisRepositoryChange change = (VCSGisRepositoryChange)this.changes.get64((long)selectedRow);
                    Feature f = ws.getRelatedFeature(change);
                    if (f == null || (currentGeom = f.getDefaultGeometry()) == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                VCSGisRepositoryChange change;
                Feature f;
                int selected = this.tblRemoteChanges.getSelectedRow();
                if (selected >= 0 && (f = ws.getRelatedFeature(change = (VCSGisRepositoryChange)this.changes.get64((long)selected))) != null) {
                    geom = f.getDefaultGeometry();
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private FeatureStore getWorkspaceStoreOfSelectedChange() {
        FeatureStore store = null;
        int selected = this.tblRemoteChanges.getSelectedRow();
        if (selected >= 0) {
            VCSGisRepositoryChange change = (VCSGisRepositoryChange)this.changes.get64((long)selected);
            VCSGisWorkspace ws = this.getUndisposableWorkspace();
            VCSGisWorkspaceEntity entity = ws.getWorkspaceEntityByCode(change.getEntityCode());
            store = ws.openFeatureStore(entity.getEntityName(), false);
        }
        return store;
    }

    private void doZoomToSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        services.zoomViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(repoGeom, geom));
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    private void doCenterToSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        services.centerViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(repoGeom, geom));
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    private void doHighLightSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getWorkspaceStoreOfSelectedChange();
        Geometry repoGeom = this.getRepositoryGeometryOfSelectedChange();
        Geometry geom = this.getWorkspaceGeometryOfSelectedChange();
        if (repoGeom != null) {
            services.highlight(1, repoGeom, store);
        }
        if (geom != null) {
            services.highlight(2, geom, store);
        }
    }

    private void doCheckout(boolean overwrite) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisWorkspace workspace = this.getUndisposableWorkspace();
        if (workspace == null) {
            return;
        }
        List entitiesToCheckout = overwrite ? this.entitySelector.getCheckedEntities() : this.getRepositoryCheckedEntities();
        if (CollectionUtils.isEmpty((Collection)entitiesToCheckout)) {
            return;
        }
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                int r = 0;
                for (VCSGisEntity entity : entitiesToCheckout) {
                    if (overwrite && (r = workspace.removeEntity(entity)) != 0) {
                        this.message(i18n.getTranslation("_Cant_overwrite") + " " + entity.getEntityName());
                        break;
                    }
                    r = workspace.checkout(entity.getEntityName());
                    if (r == 0) continue;
                    this.message(i18n.getTranslation("_Cant_checkout") + " " + entity.getEntityName());
                    break;
                }
                this.postCheckout(r, entitiesToCheckout);
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
                this.context.updateLocalChangesTable();
            }
        }, "VCSGisCheckout");
        this.context.processing = true;
        this.doUpdateComponents();
        task.start();
    }

    private void postCheckout(int checkoutStatus, List<VCSGisEntity> entities) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postCheckout(checkoutStatus, entities))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisWorkspace workspace = this.getUndisposableWorkspace();
        if (checkoutStatus == 0) {
            int res;
            FeatureStore store;
            ThreadSafeDialogsManager dialogs;
            int n;
            this.context.setVisibleStatus(false);
            int tablesWithGeometry = 0;
            for (VCSGisEntity entity : entities) {
                if (!StringUtils.isNotBlank((CharSequence)entity.getGeometryFieldName())) continue;
                ++tablesWithGeometry;
            }
            if (tablesWithGeometry > 0 && services.isThereAnyActiveView() && (n = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_Do_you_want_add_layer_to_active_view"), i18n.getTranslation("_VCS_Checkout"), 0, 3, "VCSGis_Checkout_add_layer_to_view")) == 0) {
                for (VCSGisEntity entity : entities) {
                    if (!StringUtils.isNotBlank((CharSequence)entity.getGeometryFieldName())) continue;
                    store = workspace.openFeatureStore(entity.getEntityName(), false);
                    services.addLayerToView(store, null, entity.getFirstCategory(), entity.getLabel(), false);
                }
            }
            if (entities.size() - tablesWithGeometry > 0 && (res = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_Do_you_want_add_table_to_project"), i18n.getTranslation("_VCS_Checkout"), 0, 3, "VCSGis_Checkout_add_table_to_project")) == 0) {
                for (VCSGisEntity entity : entities) {
                    if (services.isThereAnyActiveView() && !StringUtils.isBlank((CharSequence)entity.getGeometryFieldName())) continue;
                    store = workspace.openFeatureStore(entity.getEntityName(), false);
                    services.addTableToProject(workspace, store);
                }
            }
        }
        this.doReloadChanges();
        for (VCSGisEntity entity : entities) {
            FeatureStore store = this.getUndisposableWorkspace().getFeatureStore(entity.getEntityName());
            VCSGisSwingCommons.refreshDocument(store);
        }
    }

    protected void doDispose() throws BaseException {
    }

    private void doCheckRecomendedEntities() {
        VCSGisWorkspace workspace = this.getUndisposableWorkspace();
        if (workspace == null) {
            return;
        }
        HashSet<String> updateEntities = new HashSet<String>();
        Collection entities = this.entitySelector.getEntities();
        block3: for (VCSGisEntity entity : entities) {
            if (!workspace.existsInWorkspace(entity)) continue;
            VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            switch (lentity.getState()) {
                default: {
                    continue block3;
                }
                case 6: 
                case 8: 
                case 16: 
            }
            updateEntities.add(entity.getEntityCode());
        }
        this.entitySelector.setCheck(updateEntities, true);
    }
}

