/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisJChanges;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingImplLibrary;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.changes.LocalChangesController;
import org.gvsig.vcsgis.swing.impl.changes.RemoteChangesController;
import org.gvsig.vcsgis.swing.impl.changes.VCSGisJChangesView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJChangesImpl
extends VCSGisJChangesView
implements VCSGisJChanges,
PropertiesSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJChangesImpl.class);
    public static final int NOTCLOSABLE = 64;
    public static final int RESIZABLE = 1;
    public static final int MAXIMIZABLE = 2;
    public static final int ICONIFIABLE = 4;
    public static final int LOCAL_TAB_INDEX = 0;
    public static final int REMOTE_TAB_INDEX = 1;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private LocalChangesController localChangesController;
    private RemoteChangesController remoteChangesController;
    private final List<VCSGisWorkspaceEntity> workspaceEntities = null;
    private final List<VCSGisEntity> repositoryEntities = null;
    private boolean entitiesUpdateds;
    private VCSGisWorkspace currentWorkspace;
    private TaskStatusController taskStatusController;
    private Timer timerClearMsg;
    boolean processing;
    private JSplitPane splWorkingCopy;
    private JSplitPane splRepository;
    private SimpleTaskStatus taskStatus;
    private PropertiesSupportHelper propertiesSupport;
    private List<String> defaultTablesSelection;

    public VCSGisJChangesImpl() {
        this(null, null, null, null);
    }

    public VCSGisJChangesImpl(VCSGisWorkspace workspace, List<String> tableNames, Timestamp efectivedate, String comment) {
        this.defaultTablesSelection = tableNames == null ? Collections.EMPTY_LIST : tableNames;
        this.processing = false;
        this.propertiesSupport = new PropertiesSupportHelper();
        this.propertiesSupport.setProperty("WindowInfo.Flags", (Object)71);
        this.initComponents();
        SwingUtilities.invokeLater(() -> {
            this.workspacePicker.set((Object)workspace);
            this.localChangesController.setEfectiveDate(efectivedate);
            this.localChangesController.setComment(comment);
        });
    }

    public List<String> getDefaultTablesSelection() {
        return this.defaultTablesSelection;
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate((AbstractButton)this.btnWorkspace);
        swingManager.translate((AbstractButton)this.btnClose);
        swingManager.translate(this.tabLocalAndRemote);
    }

    private void initComponents() {
        VCSGisSwingManager vcsSwingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                VCSGisJChangesImpl.this.dispose();
            }
        });
        this.splWorkingCopy = ToolsSwingUtils.createHorizontalSplit((JPanel)this.gridWorkingCopy, (JPanel)this.gridWorkingCopyList, (boolean)false, (JPanel)this.gridWokingCopyTable, (boolean)false);
        this.splWorkingCopy.setDividerLocation(ToolsSwingUtils.cols2px((int)45));
        this.splRepository = ToolsSwingUtils.createHorizontalSplit((JPanel)this.gridRepository, (JPanel)this.gridRepositoryList, (boolean)false, (JPanel)this.gridRepositoryTable, (boolean)false);
        this.splRepository.setDividerLocation(ToolsSwingUtils.cols2px((int)45));
        this.timerClearMsg = new Timer(20000, e -> this.lblStatusMessages.setText(""));
        this.timerClearMsg.setRepeats(false);
        this.translate();
        this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("");
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusCaption, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind((TaskStatus)this.taskStatus);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = vcsSwingManager.createWorkspacePickerController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
        this.localChangesController = new LocalChangesController(this, this.workspacePicker, this.btnLocalCheckRecomendedEntities, this.btnLocalCheckAllEntities, this.btnLocalUnCheckAllEntities, this.btnLocalExpandAllEntities, this.btnLocalCollapseAllEntities, this.tblLocalChanges, this.btnLocalCheckAll, this.btnLocalUnCheckAll, this.btnLocalShowForm, this.btnLocalRefresh, this.btnLocalCommit, this.btnLocalRevert, this.lblLocalEffectiveDate, this.txtLocalEffectiveDate, this.txtLocalComment, this.btnLocalEffectiveDate, this.lblLocalComment, this.btnLocalZoom, this.btnLocalCenter, this.btnLocalHighlight, this.btnLocalCleanHighligthed, this.lblLocalChangesCount, this.txtLocalTablesFilter, this.btnLocalTable, this.treeLocalTables, this.btnExecuteTopologyPlan, this.btnLocalFilterAdd, this.btnLocalFilterRemove);
        this.remoteChangesController = new RemoteChangesController(this, this.workspacePicker, this.treeRepositoryTables, this.txtRepositoryTablesFilter, this.btnRepositoryTablesFilter, this.btnRemoteTablesReload, this.tblRemoteChanges, this.btnRemoteCheckAll, this.btnRemoteUncheckAll, this.btnRemoteExpandAllEntities, this.btnRemoteCollapseAllEntities, this.btnRemoteDownloadChanges, this.btnRemoteReloadChanges, this.btnRemoteCleanChanges, this.btnRemoteUpdate, this.btnRemoteMerge, this.btnRemoteShowForm, this.btnRemoteZoom, this.btnRemoteCenter, this.btnRemoteHighlight, this.btnRemoteCheckout, this.btnRemoteCheckoutOverwrite, this.btnRemoteCleanHighligthed, this.lblRemoteChangesCount, this.btnRemoteCheckRecomendedEntities, this.btnRemoteUnCheckAllEntities);
        this.btnClose.addActionListener(e -> {
            if (this.processing) {
                return;
            }
            this.setVisible(false);
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)14, (int)100);
    }

    void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        if (this.localChangesController != null) {
            this.localChangesController.doUpdateComponents();
        }
        if (this.remoteChangesController != null) {
            this.remoteChangesController.doUpdateComponents();
        }
    }

    public void updateLocalChangesTable() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.updateLocalChangesTable())) {
            return;
        }
        this.localChangesController.doReloadTables();
    }

    public VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        return ws;
    }

    private VCSGisWorkspace getUndisposableWorkspace() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        DisposeUtils.disposeQuietly((Disposable)ws);
        LOGGER.info("ws.references = " + DisposeUtils.getReferences((Disposable)ws));
        return ws;
    }

    private void doChangeWorkspace() {
        VCSGisWorkspace ws = null;
        try {
            ws = this.getWorkspace();
            if (ws == null) {
                this.localChangesController.doChangeWorkspace();
                this.remoteChangesController.doChangeWorkspace();
                return;
            }
            if (ws.isOffline() || ws.authenticate(null)) {
                this.localChangesController.doChangeWorkspace();
                this.remoteChangesController.doChangeWorkspace();
                return;
            }
            VCSGisSwingCommons.showAuthenticationRequiredMessage("_VCS_Changes");
            this.workspacePicker.set(null);
            this.doChangeWorkspace();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Changes", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)ws);
        }
    }

    public void updateEntitiesFromRepository(boolean forceUpdateEntities) {
        VCSGisWorkspace ws = null;
        try {
            ws = this.getWorkspace();
            if (ws == null) {
                return;
            }
            if (!forceUpdateEntities && this.currentWorkspace == ws && this.entitiesUpdateds) {
                return;
            }
            this.setVisibleStatus(true);
            ws.updateEntitiesFromRepository();
            if (this.currentWorkspace != null && this.currentWorkspace != ws) {
                DisposeUtils.disposeQuietly((Disposable)this.currentWorkspace);
                this.currentWorkspace = null;
            }
            this.currentWorkspace = ws;
            ws = null;
            this.entitiesUpdateds = true;
            this.setVisibleStatus(false);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)ws);
        }
    }

    public void alert(String msg) {
        if (StringUtils.startsWith((CharSequence)msg, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            msg = i18n.getTranslation(msg);
        }
        this.message(VCSGisSwingCommons.getHTMLColorTag(Color.red.darker(), msg));
    }

    public void message(String msg) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        String message = msg;
        this.timerClearMsg.stop();
        if (StringUtils.startsWith((CharSequence)message, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            message = i18n.getTranslation(message);
        }
        this.lblStatusMessages.setVisible(true);
        this.lblStatusMessages.setText(message);
        this.timerClearMsg.start();
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusCaption.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(VCSGisSwingImplLibrary.class, (String)"/org/gvsig/vcsgis/swing/impl/images", (String)"VCSGis", (String[][])new String[][]{{"vcsgis", "vcsgis-commit-all", "vcsgis-changes"}, {"vcsgis", "vcsgis-revert", "vcsgis-changes"}, {"vcsgis", "vcsgis-topology-plan", "vcsgis-changes"}, {"vcsgis", "vcsgis-show-local-changes", "vcsgis-changes"}, {"vcsgis", "vcsgis-checkout-overwrite", "vcsgis-changes"}, {"vcsgis", "vcsgis-remotechanges-clear", "vcsgis-changes"}, {"vcsgis", "vcsgis-remotechanges-download", "vcsgis-changes"}, {"vcsgis", "vcsgis-remotechanges-reload", "vcsgis-changes"}, {"vcsgis", "vcsgis-highlight-context", "vcsgis-changes"}, {"vcsgis", "vcsgis-update-all", "vcsgis-changes"}, {"vcsgis", "vcsgis-merge", "vcsgis-changes"}, {"vcsgis", "vcsgis-show-remote-changes", "vcsgis-changes"}, {"vcsgis", "vcsgis-center-context", "vcsgis-changes"}, {"vcsgis", "vcsgis-zoom-context", "vcsgis-changes"}, {"vcsgis", "vcsgis-clean-highlighted", "vcsgis-changes"}});
        ToolsSwingUtils.registerSubgroupIconScreenshot(VCSGisSwingImplLibrary.class, (String)"vcsgis", (String)"vcsgis-changes", (String)"/org/gvsig/vcsgis/swing/impl/screenshots/vcsgis-changes-local.png");
        ToolsSwingUtils.registerSubgroupIconScreenshot(VCSGisSwingImplLibrary.class, (String)"vcsgis", (String)"vcsgis-changes", (String)"/org/gvsig/vcsgis/swing/impl/screenshots/vcsgis-changes-remote.png");
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void selectTab(int tab) {
        this.tabLocalAndRemote.setSelectedIndex(tab);
    }

    public void selectOnlyALocalEntity(VCSGisEntity selectedTable) {
        this.localChangesController.selectOnlyAEntity(selectedTable);
    }

    public void selectOnlyALocalEntity(List<VCSGisEntity> selectedTables) {
        this.localChangesController.selectOnlyAEntity(selectedTables);
    }

    public void setDialog(Dialog dialog) {
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.localChangesController);
        this.localChangesController = null;
        DisposeUtils.disposeQuietly((Disposable)this.remoteChangesController);
        this.remoteChangesController = null;
        DisposeUtils.disposeQuietly((Disposable)this.currentWorkspace);
        this.currentWorkspace = null;
    }

    public void setTaskStatus(SimpleTaskStatus taskStatus) {
        this.taskStatusController.bind((TaskStatus)taskStatus);
    }

    public Object getProperty(String name) {
        return this.propertiesSupport.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesSupport.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesSupport.getProperties();
    }
}

