/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.log;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJLog;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.log.VCSGisJLogView;
import org.gvsig.vcsgis.swing.impl.log.VCSGisRepositoryLogDataTableModel;

public class VCSGisJLogImpl
extends VCSGisJLogView
implements VCSGisJLog {
    private boolean processing = false;
    private TaskStatusController taskStatusController;
    private VCSGisRepositoryLogDataTableModel tableModel;

    public VCSGisJLogImpl() {
        this.initComponents();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.translate();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                VCSGisJLogImpl.this.dispose();
            }
        });
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(true);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        this.tableModel = new VCSGisRepositoryLogDataTableModel(null);
        this.tblChanges.setModel(this.tableModel);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)70);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblElement);
        toolsSwingManager.translate(this.lblTable);
    }

    private void updateStateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.updateStateComponents())) {
            return;
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    public static void selfRegister() {
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusMessages.setVisible(visible);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public void setDialog(Dialog dialog) {
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Object)this.tableModel);
    }

    public void put(VCSGisWorkspace ws, VCSGisEntity entity, String featureCode) {
        SwingUtilities.invokeLater(() -> {
            DisposeUtils.bind((Disposable)ws);
            this.doLog(ws, entity, featureCode);
        });
    }

    private void doLog(VCSGisWorkspace ws, VCSGisEntity entity, String featureCode) {
        Thread task = new Thread(() -> {
            SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("History");
            taskStatus.setAutoremove(true);
            try {
                DisposeUtils.disposeQuietly((Object)this.tableModel);
                this.tableModel = null;
                this.txtTable.setText(entity.getLabelOrName());
                this.taskStatusController.setVisible(true);
                this.taskStatusController.bind((TaskStatus)taskStatus);
                List changes = ws.log(entity.getEntityName(), featureCode, taskStatus);
                this.tableModel = new VCSGisRepositoryLogDataTableModel(changes);
                this.tblChanges.setModel(this.tableModel);
                taskStatus.terminate();
                this.taskStatusController.setVisible(false);
            }
            catch (UserCancelledException e) {
                taskStatus.cancel();
            }
            catch (Exception e) {
                taskStatus.abort();
                DisposeUtils.disposeQuietly((Object)this.tableModel);
                this.tableModel = new VCSGisRepositoryLogDataTableModel(null);
                this.tblChanges.setModel(this.tableModel);
                taskStatus.message(e.getLocalizedMessage());
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)ws);
            }
        }, "VCSGisLog");
        task.start();
    }
}

