/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.resourceTable;

import java.awt.Cursor;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJCreateResourceTable;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.resourceTable.VCSGisJCreateResourceTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJCreateResourceTableImpl
extends VCSGisJCreateResourceTableView
implements Component,
VCSGisJCreateResourceTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJCreateResourceTableImpl.class);
    private PickerController<VCSGisWorkspace> wsConnectionPicker;
    private Dialog dialog;

    public VCSGisJCreateResourceTableImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        this.btnAddWsConnection.setCursor(Cursor.getPredefinedCursor(12));
        this.wsConnectionPicker = swingManager.createWorkspacePickerController(this.cboWsConnections, this.btnAddWsConnection);
        this.wsConnectionPicker.addChangeListener(e -> this.doChangeWorkspace());
        this.txtTableName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VCSGisJCreateResourceTableImpl.this.doUpdateEnableComponents();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VCSGisJCreateResourceTableImpl.this.doUpdateEnableComponents();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VCSGisJCreateResourceTableImpl.this.doUpdateEnableComponents();
            }
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)6, (int)60);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createResourceTable() {
        int n;
        String tableName = this.txtTableName.getText();
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null || StringUtils.isBlank((CharSequence)tableName)) {
            return 270;
        }
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorerParameters connection = workspace.getExplorerParameters();
        DatabaseWorkspaceManager dbWorkspaceManager = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)connection);
        dbWorkspaceManager.createTableResources(tableName);
        FeatureStore featureStore = null;
        try {
            String label = tableName;
            String category = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboCategory.getSelectedItem()), null);
            String datamodel = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboModel.getSelectedItem()), null);
            String attrNameForLabel = "name";
            featureStore = workspace.openFeatureStore(tableName, false);
            int result = workspace.add(tableName, featureStore, attrNameForLabel, category, label, datamodel, null, null, false, null);
            if (result == 0) {
                this.postCreateResourceTable(result, workspace, tableName, this.chkAddTableToProject.isSelected());
            }
            n = result;
        }
        catch (Throwable throwable) {
            DisposeUtils.disposeQuietly(featureStore);
            DisposeUtils.disposeQuietly((Disposable)workspace);
            this.doUpdateEnableComponents();
            throw throwable;
        }
        DisposeUtils.disposeQuietly((Disposable)featureStore);
        DisposeUtils.disposeQuietly((Disposable)workspace);
        this.doUpdateEnableComponents();
        return n;
    }

    public String getWorkspaceName() {
        return this.txtTableName.getText();
    }

    public VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.wsConnectionPicker.get();
        return workspace;
    }

    public VCSGisEntity getTable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void doChangeWorkspace() {
        this.updateCategoryCombo();
        this.updateModelCombo();
        this.doUpdateEnableComponents();
    }

    private void doUpdateEnableComponents() {
        boolean enabled;
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean bl = enabled = workspace != null && StringUtils.isNotBlank((CharSequence)this.txtTableName.getText());
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enabled);
        }
        DisposeUtils.disposeQuietly((Disposable)workspace);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.lblResourceTable);
        swingManager.translate(this.lblLabel);
        swingManager.translate(this.lblCategory);
        swingManager.translate(this.lblModel);
        swingManager.translate((AbstractButton)this.chkAddTableToProject);
    }

    public boolean isProcessing() {
        return false;
    }

    private void updateCategoryCombo() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.wsConnectionPicker.get();
        DefaultComboBoxModel<String> modelCategories = new DefaultComboBoxModel<String>();
        if (ws != null) {
            for (String category : ws.getEntityCategories()) {
                modelCategories.addElement(category);
            }
        }
        Object item = this.cboCategory.getSelectedItem();
        this.cboCategory.setModel(modelCategories);
        ListElement.setSelected((JComboBox)this.cboCategory, (Object)item);
    }

    private void updateModelCombo() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.wsConnectionPicker.get();
        DefaultComboBoxModel<String> modelDataModels = new DefaultComboBoxModel<String>();
        if (ws != null) {
            for (String modelName : ws.getDataModels()) {
                modelDataModels.addElement(modelName);
            }
        }
        Object item = this.cboModel.getSelectedItem();
        this.cboModel.setModel(modelDataModels);
        ListElement.setSelected((JComboBox)this.cboModel, (Object)item);
    }

    private void postCreateResourceTable(int createResourceTableStatus, VCSGisWorkspace workspace, String tableName, boolean addTableToProject) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postCreateResourceTable(createResourceTableStatus, workspace, tableName, addTableToProject))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        if (createResourceTableStatus == 0 && addTableToProject) {
            FeatureStore store = workspace.openFeatureStore(tableName, false);
            services.addTableToProject(workspace, store);
        }
        this.updateCategoryCombo();
        this.updateModelCombo();
    }
}

