/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.revisions;

import javax.swing.table.DefaultTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;

public class RevisionsTableModel
extends DefaultTableModel
implements Disposable {
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_EFECTIVEDATE = 1;
    private static final int COLUMN_REVISION = 2;
    private static final int COLUMN_CHANGES = 3;
    private static final int COLUMN_USER = 4;
    private static final int COLUMN_MESSAGE = 5;
    private final String[] columnNames;
    private final Class[] columnClasses;
    private GetItemWithSize64<VCSGisRevision> revisions;
    private VCSGisWorkspace workspace;

    public RevisionsTableModel() {
        this((VCSGisWorkspace)null, (GetItemWithSize64<VCSGisRevision>)null);
    }

    public RevisionsTableModel(VCSGisWorkspace workspace, GetItemWithSize64<VCSGisRevision> revisions) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.columnNames = new String[]{i18n.getTranslation("_Date"), i18n.getTranslation("_Effective_date"), i18n.getTranslation("_Revision"), i18n.getTranslation("_Changes"), i18n.getTranslation("_User"), i18n.getTranslation("_Message")};
        this.columnClasses = new Class[]{String.class, String.class, Integer.class, Long.class, String.class, String.class};
        DisposeUtils.bind((Disposable)this);
        this.revisions = revisions;
        if (revisions != null) {
            DisposeUtils.bind(this.revisions);
            DisposeUtils.bind((Disposable)workspace);
        } else {
            workspace = null;
        }
        this.workspace = workspace;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getRowCount() {
        if (this.revisions == null) {
            return 0;
        }
        return (int)this.revisions.size64();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.revisions == null) {
            return null;
        }
        VCSGisRevision revision = (VCSGisRevision)this.revisions.get64((long)row);
        switch (column) {
            case 0: {
                return revision.getRevisionDate().toString();
            }
            case 1: {
                return revision.getEfectiveDate().toString();
            }
            case 2: {
                return revision.getNumber();
            }
            case 3: {
                return revision.getChangesCount();
            }
            case 4: {
                return this.workspace.getUserName(revision.getUserCode());
            }
            case 5: {
                return revision.getComment();
            }
        }
        return null;
    }

    VCSGisRevision getSelectedRevision(int row) {
        return (VCSGisRevision)this.revisions.get64((long)row);
    }

    public void dispose() {
        if (DisposeUtils.release((Disposable)this)) {
            DisposeUtils.disposeQuietly(this.revisions);
            DisposeUtils.disposeQuietly((Disposable)this.workspace);
            this.revisions = null;
            this.workspace = null;
        }
    }
}

