/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.export.swing.JExportConfigPanel;
import org.gvsig.export.swing.impl.DefaultJExportConfigPanelView;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DefaultJExportConfigPanel
extends DefaultJExportConfigPanelView
implements JExportConfigPanel {
    private JListWithCheckbox lstFactories;
    private ChangeListenerHelper changeListenerHelper;

    public DefaultJExportConfigPanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        this.changeListenerHelper = manager.createChangeListenerHelper();
        this.lstFactories = manager.createJListWithCheckbox(this.lstServiceFactories);
        ListSelectionModel checkModel = this.lstFactories.getCheckedModel();
        checkModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DefaultJExportConfigPanel.this.changeListenerHelper.fireEvent(new ChangeEvent(DefaultJExportConfigPanel.this));
            }
        });
        manager.translate(this.lblHeader);
        manager.translate(this.lblServiceFactories);
        this.reset();
    }

    public void reset() {
        ExportServiceManager manager = ExportLocator.getServiceManager();
        List factories = manager.getAllServiceFactories();
        int index = 0;
        ListSelectionModel checkModel = this.lstFactories.getCheckedModel();
        checkModel.clearSelection();
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        for (ExportServiceFactory factory : factories) {
            model.addElement(new ListElement(factory.getLabel(), (Object)factory));
            if (factory.isEnabled()) {
                checkModel.addSelectionInterval(index, index);
            }
            ++index;
        }
        this.lstFactories.setModel(model);
    }

    public void apply() {
        ExportServiceManager manager = ExportLocator.getServiceManager();
        List factories = manager.getAllServiceFactories();
        ListSelectionModel checkModel = this.lstFactories.getCheckedModel();
        int index = 0;
        for (ExportServiceFactory factory : factories) {
            factory.setEnabled(checkModel.isSelectedIndex(index));
            ++index;
        }
    }

    public List<ExportServiceFactory> getAllFactories() {
        ExportServiceManager manager = ExportLocator.getServiceManager();
        List factories = manager.getAllServiceFactories();
        return Collections.unmodifiableList(factories);
    }

    public List<ExportServiceFactory> getSelectedFactories() {
        ArrayList<ExportServiceFactory> result = new ArrayList<ExportServiceFactory>();
        ExportServiceManager manager = ExportLocator.getServiceManager();
        List factories = manager.getAllServiceFactories();
        ListSelectionModel checkModel = this.lstFactories.getCheckedModel();
        int index = 0;
        for (ExportServiceFactory factory : factories) {
            if (checkModel.isSelectedIndex(index)) {
                result.add(factory);
            }
            ++index;
        }
        return result;
    }

    public List<String> getSelectedNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ExportServiceFactory selectedFactory : this.getSelectedFactories()) {
            result.add(selectedFactory.getName());
        }
        return result;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListenerHelper.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListenerHelper.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }
}

