/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.order.LayerOrderManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.locator.BaseLocator;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextLocator
extends BaseLocator {
    private static Logger logger = LoggerFactory.getLogger(MapContextLocator.class);
    public static final String MAPCONTEXT_MANAGER_NAME = "mapcontextlocator.manager";
    private static final String MAPCONTEXT_MANAGER_DESCRIPTION = "MapContext Library manager";
    public static final String SYMBOL_MANAGER_NAME = "symbol.manager";
    private static final String SYMBOL_MANAGER_DESCRIPTION = "Symbols manager";
    public static final String DEFAULT_LAYER_ORDER_MANAGER_NAME = "default.layer.order.manager";
    private static final String DEFAULT_LAYER_ORDER_MANAGER_DESCRIPTION = "Default layer order manager";
    public static final String LAYER_ORDER_MANAGER_NAME = "layer.order.manager.name";
    public static final String LAYER_ORDER_MANAGER_EXT_POINT = "layer.order.manager.extension.point";
    private static final MapContextLocator instance = new MapContextLocator();

    private MapContextLocator() {
    }

    public static MapContextLocator getInstance() {
        return instance;
    }

    public static MapContextManager getMapContextManager() throws LocatorException {
        return (MapContextManager)MapContextLocator.getInstance().get(MAPCONTEXT_MANAGER_NAME);
    }

    public static void registerMapContextManager(Class clazz) {
        MapContextLocator.getInstance().register(MAPCONTEXT_MANAGER_NAME, MAPCONTEXT_MANAGER_DESCRIPTION, clazz);
    }

    public static SymbolManager getSymbolManager() throws LocatorException {
        return (SymbolManager)MapContextLocator.getInstance().get(SYMBOL_MANAGER_NAME);
    }

    public static void registerSymbolManager(Class clazz) {
        MapContextLocator.getInstance().register(SYMBOL_MANAGER_NAME, SYMBOL_MANAGER_DESCRIPTION, clazz);
    }

    public static void registerDefaultOrderManager(Class lom_class) throws LocatorException {
        if (!LayerOrderManager.class.isAssignableFrom(lom_class)) {
            throw new LocatorException("Class '" + (lom_class == null ? "NULL" : lom_class.getClass().getName()) + "' does not implement LayerOrderManager.", "", -1L);
        }
        MapContextLocator.getInstance().registerDefault(DEFAULT_LAYER_ORDER_MANAGER_NAME, DEFAULT_LAYER_ORDER_MANAGER_DESCRIPTION, lom_class);
        MapContextLocator.registerOrderManager(lom_class);
    }

    public static void registerOrderManager(Class lom_class) {
        if (!LayerOrderManager.class.isAssignableFrom(lom_class)) {
            throw new LocatorException("Class '" + (lom_class == null ? "NULL" : lom_class.getClass().getName()) + "' does not implement LayerOrderManager.", "", -1L);
        }
        ExtensionPointManager epMan = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epMan.add(LAYER_ORDER_MANAGER_EXT_POINT, "");
        ep.append("layer.order.manager.name." + lom_class.getName(), "", lom_class);
    }

    public static LayerOrderManager getDefaultOrderManager() throws LocatorException {
        LayerOrderManager resp = null;
        try {
            resp = (LayerOrderManager)MapContextLocator.getInstance().get(DEFAULT_LAYER_ORDER_MANAGER_NAME);
        }
        catch (Exception ex) {
            logger.info("Cant get default layer order manager", (Throwable)ex);
        }
        return resp;
    }

    public static List getOrderManagers() {
        ExtensionPointManager epMan = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epMan.get(LAYER_ORDER_MANAGER_EXT_POINT);
        ArrayList<LayerOrderManager> managers = new ArrayList<LayerOrderManager>();
        for (ExtensionPoint.Extension extension : ep) {
            LayerOrderManager lom = null;
            try {
                lom = (LayerOrderManager)extension.create();
            }
            catch (Exception e) {
                logger.warn("Cant create LayerOrderManager " + extension.getName(), (Throwable)e);
                continue;
            }
            managers.add(lom);
        }
        return managers;
    }
}

