/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.impl;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextDrawer;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayerHidesArea;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerDrawEvent;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.operations.ComposedLayer;
import org.gvsig.fmap.mapcontext.layers.operations.LayerCollection;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelable;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMapContextDrawer
implements MapContextDrawer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMapContextDrawer.class);
    private MapContext mapContext = null;
    private ViewPort viewPort = null;
    private CachedImage cachedImage = null;
    private DrawList previousDrawList = null;
    private boolean printGraphicsLayer;

    protected void checkInitialized() {
        if (this.mapContext == null || this.viewPort == null) {
            throw new IllegalStateException("MapContext and ViewPort must be set");
        }
    }

    @Override
    public void draw(FLayers root, BufferedImage image, Graphics2D g, Cancellable cancel, double scale) throws ReadException {
        int lastLayerToDraw;
        int firstLayerToDraw;
        this.checkInitialized();
        if (this.cachedImage != null && this.cachedImage.hasChangedViewPortDrawVersion()) {
            this.cachedImage = null;
        }
        AffineTransform aux_at = null;
        if (this.isValidFullCachedImage()) {
            aux_at = g.getTransform();
            g.drawImage((Image)this.cachedImage.getFullDrawnImage(), (int)(-aux_at.getTranslateX()), (int)(-aux_at.getTranslateY()), null);
            LOG.debug("Drawn full image from the cache, all layers cached");
            return;
        }
        DrawList drawList = this.createDrawList(root, cancel, scale);
        if (drawList == null || drawList.size() == 0) {
            return;
        }
        if (cancel.isCanceled()) {
            this.cachedImage = null;
            return;
        }
        if (this.isValidPartialCachedImage(drawList)) {
            firstLayerToDraw = 0;
            lastLayerToDraw = this.cachedImage.getLastDrawnLayerPosition();
            aux_at = g.getTransform();
            g.drawImage((Image)this.cachedImage.getPartialDrawnImage(), (int)(-aux_at.getTranslateX()), (int)(-aux_at.getTranslateY()), null);
            this.cachedImage.updateVersions(this.mapContext, this.viewPort);
            LOG.debug("Reused image of cached layers from 0 to {}", (Object)lastLayerToDraw);
        } else {
            if (this.cachedImage == null) {
                this.cachedImage = new CachedImage();
                firstLayerToDraw = 0;
                lastLayerToDraw = drawList.getLastLayerVisible(this.viewPort);
            } else {
                firstLayerToDraw = 0;
                int firstChangedLayer = drawList.getFirstChangedLayer();
                lastLayerToDraw = firstChangedLayer < 0 ? drawList.getLayerCount() - 1 : firstChangedLayer - 1;
            }
            drawList.drawLayers(image, g, firstLayerToDraw, lastLayerToDraw, cancel, scale);
            this.cachedImage.setPartialDrawnImage(image, this.mapContext, this.viewPort, lastLayerToDraw);
        }
        if (cancel.isCanceled()) {
            this.cachedImage = null;
            return;
        }
        firstLayerToDraw = lastLayerToDraw + 1;
        lastLayerToDraw = drawList.getLayerCount() - 1;
        drawList.drawLayers(image, g, firstLayerToDraw, lastLayerToDraw, cancel, scale);
        if (cancel.isCanceled()) {
            this.clean();
        } else {
            this.cachedImage.setFullDrawnImage(image);
        }
        this.previousDrawList = drawList;
    }

    private boolean isValidPartialCachedImage(DrawList drawList) {
        return this.cachedImage != null && this.cachedImage.isValidPartialDrawnImage(this.mapContext, drawList);
    }

    private boolean isValidFullCachedImage() {
        return this.cachedImage != null && this.cachedImage.isValidFullDrawnImage(this.mapContext);
    }

    private void print(Object layerOrComposed, Graphics2D g, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        ILabelable labelable = null;
        ILabelable tmp = null;
        if (layerOrComposed instanceof ILabelable && (tmp = (ILabelable)layerOrComposed).isLabeled() && tmp.getLabelingStrategy() != null && tmp.getLabelingStrategy().shouldDrawLabels(scale)) {
            labelable = tmp;
        }
        if (layerOrComposed instanceof FLayer) {
            FLayer layer = (FLayer)layerOrComposed;
            layer.print(g, this.viewPort, cancel, scale, properties);
        } else {
            ComposedLayer composed = (ComposedLayer)layerOrComposed;
            composed.print(g, this.viewPort, cancel, scale, properties);
        }
        if (labelable != null) {
            labelable.printLabels(g, this.viewPort, cancel, scale, properties);
        }
    }

    @Override
    public void setMapContext(MapContext mapContext) {
        if (this.mapContext == mapContext) {
            return;
        }
        this.clean();
        this.mapContext = mapContext;
    }

    @Override
    public void setViewPort(ViewPort viewPort) {
        if (this.viewPort == viewPort) {
            return;
        }
        this.clean();
        this.viewPort = viewPort;
    }

    protected void clean() {
        this.cachedImage = null;
    }

    @Override
    public boolean isPrintGraphicsLayer() {
        return this.printGraphicsLayer;
    }

    @Override
    public void setPrintGraphicsLayer(boolean b) {
        this.printGraphicsLayer = b;
    }

    @Override
    public void dispose() {
        this.mapContext = null;
        this.viewPort = null;
        this.cachedImage = null;
        this.previousDrawList = null;
    }

    @Override
    public void print(FLayers root, Graphics2D g, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        this.checkInitialized();
        List printList = this.createPrintList(root, cancel, scale);
        if (cancel.isCanceled()) {
            return;
        }
        ComposedLayer composed = null;
        int layerPos = -1;
        for (int pos = 0; pos < printList.size(); ++pos) {
            if (cancel.isCanceled()) {
                return;
            }
            Object obj = printList.get(pos);
            if (obj instanceof LayersGroupEvent) {
                LayersGroupEvent event = (LayersGroupEvent)obj;
                if (event.type == "in") {
                    event.group.beginDraw(g, this.viewPort);
                    continue;
                }
                event.group.endDraw(g, this.viewPort);
                continue;
            }
            ++layerPos;
            FLayer layer = (FLayer)obj;
            if (composed == null) {
                composed = layer.newComposedLayer();
                if (composed != null) {
                    try {
                        composed.add(layer);
                        continue;
                    }
                    catch (Exception e) {
                        throw new ReadException("DefaultMapContexDrawer exception", (Throwable)e);
                    }
                }
            } else {
                if (composed.canAdd(layer)) {
                    try {
                        composed.add(layer);
                        continue;
                    }
                    catch (Exception e) {
                        throw new ReadException("DefaultMapContexDrawer exception", (Throwable)e);
                    }
                }
                this.print(composed, g, cancel, scale, properties);
                composed = layer.newComposedLayer();
                if (composed != null) {
                    try {
                        composed.add(layer);
                        continue;
                    }
                    catch (Exception e) {
                        throw new ReadException("DefaultMapContexDrawer exception", (Throwable)e);
                    }
                }
            }
            this.print(layer, g, cancel, scale, properties);
            if (composed == null) continue;
            this.print(composed, g, cancel, scale, properties);
            composed = null;
        }
    }

    private DrawList createDrawList(FLayers root, Cancellable cancel, double scale) {
        DrawList result = new DrawList(this.previousDrawList);
        MyLayerIterator iter = new MyLayerIterator(root, scale);
        while (iter.hasNext()) {
            if (cancel.isCanceled()) {
                return null;
            }
            result.add(iter.next());
        }
        if (cancel.isCanceled()) {
            return null;
        }
        for (VectorLayer graphicsLayer : this.mapContext.getGraphicsLayers()) {
            if (graphicsLayer == null || !graphicsLayer.isAvailable() || !graphicsLayer.isVisible() || !graphicsLayer.isWithinScale(scale)) continue;
            result.add(graphicsLayer);
        }
        return result;
    }

    private List createPrintList(FLayers root, Cancellable cancel, double scale) {
        ArrayList result = new ArrayList();
        SimpleLayerIterator iter = new SimpleLayerIterator(root);
        while (iter.hasNext()) {
            if (cancel.isCanceled()) {
                return null;
            }
            result.add(iter.next());
        }
        if (this.printGraphicsLayer) {
            for (VectorLayer graphicsLayer : this.mapContext.getGraphicsLayers()) {
                if (graphicsLayer == null || !graphicsLayer.isAvailable() || !graphicsLayer.isVisible() || !graphicsLayer.isWithinScale(scale)) continue;
                result.add(graphicsLayer);
            }
        }
        return result;
    }

    public static class RegisterMapContextDrawer
    implements Callable {
        public Object call() {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            try {
                manager.setDefaultMapContextDrawer(DefaultMapContextDrawer.class);
            }
            catch (MapContextException ex) {
                throw new RuntimeException("Can't register the default MapContextDrawer", (Throwable)((Object)ex));
            }
            return Boolean.TRUE;
        }
    }

    private class LayersGroupEvent {
        public static final String IN_Event = "in";
        public static final String OUT_Event = "Out";
        private LayerCollection group = null;
        private String type = "in";

        public LayersGroupEvent(LayerCollection group, String type) {
            this.group = group;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public LayerCollection getGroup() {
            return this.group;
        }
    }

    private class MyLayerIterator
    implements Iterator {
        List layersList = new ArrayList();
        int index = 0;
        double scale = 0.0;

        public MyLayerIterator(FLayer layer, double scale) {
            this.scale = scale;
            this.appendLayer(layer);
        }

        protected void appendLayer(FLayer layer) {
            if (layer instanceof LayerCollection) {
                this.appendLayers((LayerCollection)((Object)layer));
            } else if (this.evaluate(layer)) {
                this.layersList.add(layer);
            }
        }

        private void appendLayers(LayerCollection layers) {
            this.layersList.add(new LayersGroupEvent(layers, "in"));
            for (int i = 0; i < layers.getLayersCount(); ++i) {
                this.appendLayer(layers.getLayer(i));
            }
            this.layersList.add(new LayersGroupEvent(layers, "Out"));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.layersList.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object aux = this.layersList.get(this.index);
            ++this.index;
            return aux;
        }

        public boolean evaluate(FLayer layer) {
            if (layer instanceof LayerCollection) {
                return false;
            }
            return layer.isAvailable() && layer.isVisible() && layer.isWithinScale(this.scale);
        }
    }

    private class SimpleLayerIterator
    extends LayersIterator {
        public SimpleLayerIterator(FLayer layer) {
            this.appendLayer(layer);
        }

        @Override
        public boolean evaluate(FLayer layer) {
            if (layer instanceof FLayers) {
                return false;
            }
            return layer.isAvailable() && layer.isVisible();
        }
    }

    public class DrawList {
        private List layers = new ArrayList();
        private List all = new ArrayList();
        private List versions = new ArrayList();
        private DrawList previosList = null;
        private int firstLayerChanged = -1;

        public DrawList() {
        }

        public DrawList(DrawList previousList) {
            if (previousList != null) {
                this.firstLayerChanged = previousList.getLayerCount();
                this.previosList = previousList;
            }
        }

        public int getLayerCount() {
            return this.layers.size();
        }

        public int getLastLayerVisible(ViewPort viewPort) {
            Envelope area = viewPort.getAdjustedEnvelope();
            for (int n = 0; n < this.layers.size() - 1; ++n) {
                FLayer layer = (FLayer)this.layers.get(n);
                if (!(layer instanceof FLayerHidesArea) || !((FLayerHidesArea)((Object)layer)).hidesThisArea(area)) continue;
                return n;
            }
            return this.layers.size() - 1;
        }

        private boolean hasChanged(FLayer layer, int pos) {
            long layerVersion;
            FLayer previous = (FLayer)this.previosList.layers.get(pos);
            if (previous != layer) {
                return true;
            }
            long previousVersion = (Long)this.previosList.versions.get(pos);
            return previousVersion != (layerVersion = layer.getDrawVersion());
        }

        public void add(Object obj) {
            if (obj instanceof FLayer) {
                FLayer layer = (FLayer)obj;
                int curIndex = this.layers.size();
                if (this.firstLayerChanged >= curIndex) {
                    if (this.previosList.getLayerCount() > curIndex) {
                        if (this.hasChanged(layer, curIndex)) {
                            this.firstLayerChanged = curIndex;
                        }
                    } else if (this.previosList.getLayerCount() == curIndex) {
                        this.firstLayerChanged = curIndex;
                    }
                }
                this.layers.add(layer);
                this.versions.add(layer.getDrawVersion());
            } else if (!(obj instanceof LayersGroupEvent)) {
                throw new UnsupportedOperationException();
            }
            this.all.add(obj);
        }

        public int size() {
            return this.all.size();
        }

        public int getFirstChangedLayer() {
            if (this.firstLayerChanged > this.layers.size()) {
                this.firstLayerChanged = this.layers.size();
            }
            return this.firstLayerChanged;
        }

        public FLayer getLayer(int pos) {
            return (FLayer)this.layers.get(pos);
        }

        public Object get(int pos) {
            return this.all.get(pos);
        }

        public void drawLayers(BufferedImage image, Graphics2D g, int firstLayerToDraw, int lastLayerToDraw, Cancellable cancel, double scale) throws ReadException {
            LayersGroupEvent event;
            if (firstLayerToDraw > lastLayerToDraw) {
                LOG.debug("Nothing to draw");
                return;
            }
            FLayer firstLayer = (FLayer)this.layers.get(firstLayerToDraw);
            int firstLayerPos = this.all.indexOf(firstLayer);
            if (firstLayerPos > 0) {
                for (int i = firstLayerPos - 1; i < this.all.size(); ++i) {
                    Object group = this.all.get(i);
                    if (!(group instanceof LayersGroupEvent)) continue;
                    LayersGroupEvent event2 = (LayersGroupEvent)group;
                    if (event2.type != "in") break;
                    event2.group.beginDraw(g, DefaultMapContextDrawer.this.viewPort);
                    break;
                }
            }
            FLayer lastLayer = (FLayer)this.layers.get(lastLayerToDraw);
            int lastLayerPos = this.all.indexOf(lastLayer);
            LOG.debug("Drawing from layer {} in position (layers: {}, all: {}) to layer {} in position (layers: {}, all: {})", new Object[]{firstLayer, firstLayerToDraw, firstLayerPos, lastLayer, lastLayerToDraw, lastLayerPos});
            ComposedLayer composed = null;
            for (int pos = firstLayerPos; pos <= lastLayerPos; ++pos) {
                if (cancel.isCanceled()) {
                    return;
                }
                Object layerOrGroup = this.get(pos);
                if (layerOrGroup instanceof LayersGroupEvent) {
                    event = (LayersGroupEvent)layerOrGroup;
                    if (event.type == "in") {
                        event.group.beginDraw(g, DefaultMapContextDrawer.this.viewPort);
                        continue;
                    }
                    event.group.endDraw(g, DefaultMapContextDrawer.this.viewPort);
                    continue;
                }
                FLayer layer = (FLayer)layerOrGroup;
                if (composed != null && composed.canAdd(layer)) {
                    this.addToComposedLayer(composed, layer);
                    continue;
                }
                if (composed != null) {
                    LOG.debug("Drawing composed layer {} ", (Object)composed);
                    this.draw(composed, image, g, cancel, scale);
                    composed = null;
                }
                if ((composed = layer.newComposedLayer()) == null) {
                    LOG.debug("Drawing layer {} ", (Object)layer);
                    this.draw(layer, image, g, cancel, scale);
                    continue;
                }
                this.addToComposedLayer(composed, layer);
            }
            if (composed != null) {
                this.draw(composed, image, g, cancel, scale);
            }
            for (int i = lastLayerPos + 1; i < this.all.size(); ++i) {
                Object group = this.all.get(i);
                if (!(group instanceof LayersGroupEvent)) continue;
                event = (LayersGroupEvent)group;
                if (event.type != "Out") break;
                event.group.endDraw(g, DefaultMapContextDrawer.this.viewPort);
                break;
            }
        }

        private void addToComposedLayer(ComposedLayer composed, FLayer layer) throws ReadException {
            try {
                LOG.debug("Adding layer {} to composed layer ", (Object)layer, (Object)composed);
                composed.add(layer);
            }
            catch (Exception e) {
                throw new ReadException("DefalutMapContexDrawer exception", (Throwable)e);
            }
        }

        private void draw(Object layerOrComposed, BufferedImage image, Graphics2D g, Cancellable cancel, double scale) throws ReadException {
            ILabelable labelable = null;
            ILabelable tmp = null;
            if (layerOrComposed instanceof ILabelable && (tmp = (ILabelable)layerOrComposed).isLabeled() && tmp.getLabelingStrategy() != null && tmp.getLabelingStrategy().shouldDrawLabels(scale)) {
                labelable = tmp;
            }
            if (layerOrComposed instanceof FLayer) {
                int afterDrawEventType;
                int beforeDrawEventType;
                if (layerOrComposed instanceof GraphicLayer) {
                    beforeDrawEventType = 103;
                    afterDrawEventType = 104;
                } else {
                    beforeDrawEventType = 101;
                    afterDrawEventType = 102;
                }
                FLayer layer = (FLayer)layerOrComposed;
                this.drawLayer(layer, image, g, cancel, scale, beforeDrawEventType, afterDrawEventType);
            } else {
                ComposedLayer composed = (ComposedLayer)layerOrComposed;
                composed.draw(image, g, DefaultMapContextDrawer.this.viewPort, cancel, scale);
            }
            if (labelable != null) {
                labelable.drawLabels(image, g, DefaultMapContextDrawer.this.viewPort, cancel, scale, DefaultMapContextDrawer.this.mapContext.getViewPort().getDPI());
            }
        }

        protected void drawLayer(FLayer layer, BufferedImage image, Graphics2D g, Cancellable cancel, double scale, int beforeDrawEventType, int afterDrawEventType) throws ReadException {
            LayerDrawEvent event = new LayerDrawEvent(layer, g, DefaultMapContextDrawer.this.viewPort, beforeDrawEventType);
            DefaultMapContextDrawer.this.mapContext.fireLayerDrawingEvent(event);
            layer.draw(image, g, DefaultMapContextDrawer.this.viewPort, cancel, scale);
            event = new LayerDrawEvent(layer, g, DefaultMapContextDrawer.this.viewPort, afterDrawEventType);
            DefaultMapContextDrawer.this.mapContext.fireLayerDrawingEvent(event);
        }
    }

    public class CachedImage {
        private BufferedImage partialDrawnImage;
        private BufferedImage fullDrawnImage;
        private long lastMapContextVersion;
        private long lastViewPortVersion;
        private int lastDrawnLayerPosition;

        public void setPartialDrawnImage(BufferedImage partialDrawnImage, MapContext mapContext, ViewPort viewPort, int lastDrawnLayerPosition) {
            this.partialDrawnImage = CompatLocator.getGraphicsUtils().copyBufferedImage(partialDrawnImage);
            this.lastDrawnLayerPosition = lastDrawnLayerPosition;
            this.updateVersions(mapContext, viewPort);
        }

        public void updateVersions(MapContext mapContext, ViewPort viewPort) {
            this.lastMapContextVersion = mapContext.getDrawVersion();
            this.lastViewPortVersion = viewPort.getDrawVersion();
        }

        public void setFullDrawnImage(BufferedImage fullDrawnImage) {
            this.fullDrawnImage = CompatLocator.getGraphicsUtils().copyBufferedImage(fullDrawnImage);
        }

        public BufferedImage getPartialDrawnImage() {
            return this.partialDrawnImage;
        }

        public BufferedImage getFullDrawnImage() {
            return this.fullDrawnImage;
        }

        public long getMapContextVersion() {
            return this.lastMapContextVersion;
        }

        public int getLastDrawnLayerPosition() {
            return this.lastDrawnLayerPosition;
        }

        public boolean isValidFullDrawnImage(MapContext context) {
            return this.fullDrawnImage != null && !this.hasChangedMapContextDrawVersion();
        }

        public boolean hasChangedMapContextDrawVersion() {
            return DefaultMapContextDrawer.this.mapContext.getDrawVersion() != this.lastMapContextVersion;
        }

        public boolean hasChangedViewPortDrawVersion() {
            return DefaultMapContextDrawer.this.viewPort.getDrawVersion() != this.lastViewPortVersion;
        }

        public boolean isValidPartialDrawnImage(MapContext context, DrawList drawList) {
            if (!this.hasChangedMapContextDrawVersion()) {
                return true;
            }
            if (this.partialDrawnImage == null || this.hasChangedViewPortDrawVersion()) {
                return false;
            }
            if (drawList.size() < this.lastDrawnLayerPosition + 1) {
                return false;
            }
            return drawList.getFirstChangedLayer() > this.lastDrawnLayerPosition;
        }
    }
}

