/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.tools.ToolsLocator;

public class DefaultLayerInformationBuilder
implements LayerInformationBuilder {
    private String backgroundColor = "\"#FFFFFF\"";
    private String backgroundColorTitle = "\"#FBFFE1\"";
    private String backgroundColorPropertyLabel = "\"#D6D6D6\"";
    private String backgroundColorPropertyValue1 = "\"#FEEDD6\"";
    private String backgroundColorPropertyValue2 = "\"#EAEAEA\"";
    private int propertyCount = 0;
    private final List<LayerInformationBuilder.Element> elements = new ArrayList<LayerInformationBuilder.Element>();

    @Override
    public DefaultLayerInformationBuilder backgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    @Override
    public DefaultLayerInformationBuilder backgroundColorTitle(String color) {
        this.backgroundColorTitle = color;
        return this;
    }

    @Override
    public DefaultLayerInformationBuilder backgroundColorPropertyLabel(String color) {
        this.backgroundColorPropertyLabel = color;
        return this;
    }

    @Override
    public DefaultLayerInformationBuilder backgroundColorPropertyValue1(String color) {
        this.backgroundColorPropertyValue1 = color;
        return this;
    }

    @Override
    public DefaultLayerInformationBuilder backgroundColorPropertyValue2(String color) {
        this.backgroundColorPropertyValue2 = color;
        return this;
    }

    @Override
    public LayerInformationBuilder.TitleElement title() {
        DefaultTitleElement element = new DefaultTitleElement();
        this.elements.add(element);
        return element;
    }

    @Override
    public LayerInformationBuilder.PropertyElement property() {
        DefaultPropertyElement element = new DefaultPropertyElement();
        this.elements.add(element);
        return element;
    }

    @Override
    public LayerInformationBuilder.TextElement text() {
        DefaultTextElement element = new DefaultTextElement();
        this.elements.add(element);
        return element;
    }

    @Override
    public LayerInformationBuilder.EnvelopeElement envelope() {
        DefaultEnvelopeElement element = new DefaultEnvelopeElement();
        this.elements.add(element);
        return element;
    }

    @Override
    public LayerInformationBuilder.RawElement raw() {
        DefaultRawElement element = new DefaultRawElement();
        this.elements.add(element);
        return element;
    }

    @Override
    public String build() {
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        html.append("<body bgcolor=").append(this.backgroundColor).append(" topmargin=\"0\" marginheight=\"0\">\n");
        html.append("<table cellpadding=\"0\" cellspacing=\"0\" align=\"center\" width=\"100%\">");
        boolean first = true;
        for (LayerInformationBuilder.Element element : this.elements) {
            if (element instanceof LayerInformationBuilder.TitleElement) {
                if (first) {
                    first = false;
                } else {
                    html.append("<tr>\n<td><br></td>\n<td></td></tr>\n");
                }
            }
            html.append(element.build());
        }
        html.append("</table>");
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    public String toString() {
        return this.build();
    }

    private class DefaultEnvelopeElement
    implements LayerInformationBuilder.EnvelopeElement {
        private Envelope value;

        private DefaultEnvelopeElement() {
        }

        @Override
        public DefaultEnvelopeElement value(Envelope value) {
            this.value = value;
            return this;
        }

        @Override
        public String build() {
            if (this.value == null) {
                return new DefaultTextElement().value("None", new Object[0]).build();
            }
            if (this.value.isEmpty()) {
                return new DefaultTextElement().value("EMPTY", new Object[0]).build();
            }
            DefaultPropertyElement p1 = new DefaultPropertyElement();
            p1.labelkey("_upper_left_corner");
            p1.value("%+f, %+f", this.value.getMinimum(0), this.value.getMaximum(1));
            p1.monospace();
            DefaultPropertyElement p2 = new DefaultPropertyElement();
            p2.labelkey("_upper_right_corner");
            p2.value("%+f, %+f", this.value.getMaximum(0), this.value.getMaximum(1));
            p2.monospace();
            DefaultPropertyElement p3 = new DefaultPropertyElement();
            p3.labelkey("_lower_right_corner");
            p3.value("%+f, %+f", this.value.getMaximum(0), this.value.getMinimum(1));
            p3.monospace();
            DefaultPropertyElement p4 = new DefaultPropertyElement();
            p4.labelkey("_lower_left_corner");
            p4.value("%+f, %+f", this.value.getMinimum(0), this.value.getMinimum(1));
            p4.monospace();
            return p1.build() + p2.build() + p3.build() + p4.build();
        }
    }

    private class DefaultPropertyElement
    extends DefaultTextElement
    implements LayerInformationBuilder.PropertyElement {
        private String label;
        private boolean monospace;

        private DefaultPropertyElement() {
            this.monospace = false;
        }

        @Override
        public DefaultPropertyElement label(String label) {
            this.label = StringEscapeUtils.escapeHtml3((String)label);
            return this;
        }

        @Override
        public LayerInformationBuilder.PropertyElement labelkey(String labelkey) {
            return this.label(ToolsLocator.getI18nManager().getTranslation(labelkey));
        }

        @Override
        public LayerInformationBuilder.PropertyElement value(IProjection proj) {
            if (this.label == null) {
                this.labelkey("_CRS");
            }
            if (proj == null) {
                return this.value("", new Object[0]);
            }
            return this.value(proj.getAbrev(), new Object[0]);
        }

        @Override
        public String build() {
            String color = DefaultLayerInformationBuilder.this.propertyCount++ % 2 == 0 ? DefaultLayerInformationBuilder.this.backgroundColorPropertyValue1 : DefaultLayerInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            if (!StringUtils.isEmpty((CharSequence)this.label)) {
                content = content + "<td nowrap bgcolor=" + DefaultLayerInformationBuilder.this.backgroundColorPropertyLabel + "align=\"right\" width=\"140\"><font face=\"Arial\" size=\"3\">" + this.label + ":&nbsp;</font></td>\n";
            }
            content = this.monospace ? content + "<td bgcolor=" + color + "align=\"left\"><font face=\"Monospaced\" size=\"3\">" + this.value.replace("\\n", "<br>\n") + "</font></td>" : content + "<td bgcolor=" + color + "align=\"left\"><font face=\"Arial\" size=\"3\">" + this.value.replace("\\n", "<br>\n") + "</font></td>";
            content = content + "</tr>\n";
            return content;
        }

        @Override
        public LayerInformationBuilder.PropertyElement value(String format, Object ... args) {
            return (LayerInformationBuilder.PropertyElement)super.value(format, args);
        }

        @Override
        public LayerInformationBuilder.PropertyElement value(Envelope env) {
            return (LayerInformationBuilder.PropertyElement)super.value(env);
        }

        @Override
        public LayerInformationBuilder.PropertyElement value(Geometry geom) {
            return (LayerInformationBuilder.PropertyElement)super.value(geom);
        }

        @Override
        public LayerInformationBuilder.PropertyElement asWKT(IProjection proj) {
            return (LayerInformationBuilder.PropertyElement)super.asWKT(proj);
        }

        @Override
        public LayerInformationBuilder.PropertyElement asWKT(Envelope env) {
            return (LayerInformationBuilder.PropertyElement)super.asWKT(env);
        }

        @Override
        public LayerInformationBuilder.PropertyElement asWKT(Geometry geom) {
            return (LayerInformationBuilder.PropertyElement)super.asWKT(geom);
        }

        @Override
        public LayerInformationBuilder.PropertyElement monospace() {
            this.monospace = true;
            return this;
        }
    }

    private class DefaultTextElement
    extends DefaultRawElement
    implements LayerInformationBuilder.TextElement {
        private DefaultTextElement() {
        }

        @Override
        public LayerInformationBuilder.TextElement value(String format, Object ... args) {
            this.value = args == null ? StringEscapeUtils.escapeHtml3((String)format) : StringEscapeUtils.escapeHtml3((String)String.format(format, args));
            return this;
        }

        @Override
        public LayerInformationBuilder.TextElement value(IProjection proj) {
            return (LayerInformationBuilder.TextElement)super.value(proj);
        }

        @Override
        public LayerInformationBuilder.TextElement value(Envelope env) {
            return (LayerInformationBuilder.TextElement)super.value(env);
        }

        @Override
        public LayerInformationBuilder.TextElement value(Geometry geom) {
            return (LayerInformationBuilder.TextElement)super.value(geom);
        }

        @Override
        public LayerInformationBuilder.TextElement asWKT(IProjection proj) {
            return (LayerInformationBuilder.TextElement)super.asWKT(proj);
        }

        @Override
        public LayerInformationBuilder.TextElement asWKT(Envelope env) {
            return (LayerInformationBuilder.TextElement)super.asWKT(env);
        }

        @Override
        public LayerInformationBuilder.TextElement asWKT(Geometry geom) {
            return (LayerInformationBuilder.TextElement)super.asWKT(geom);
        }

        @Override
        public String build() {
            String color = DefaultLayerInformationBuilder.this.propertyCount++ % 2 == 0 ? DefaultLayerInformationBuilder.this.backgroundColorPropertyValue1 : DefaultLayerInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            content = content + "<td bgcolor=" + color + "align=\"left\" colspan=\"2\"><font face=\"Arial\" size=\"3\">" + this.value.replace("\n", "<br>\n") + "</font></td>\n";
            content = content + "</tr>\n";
            return content;
        }
    }

    private class DefaultRawElement
    implements LayerInformationBuilder.RawElement {
        protected String value;

        private DefaultRawElement() {
        }

        @Override
        public LayerInformationBuilder.RawElement value(String format, Object ... args) {
            this.value = args == null ? format : String.format(format, args);
            return this;
        }

        @Override
        public LayerInformationBuilder.RawElement value(Envelope env) {
            return this.asWKT(env);
        }

        @Override
        public LayerInformationBuilder.RawElement value(Geometry geom) {
            return this.asWKT(geom);
        }

        @Override
        public LayerInformationBuilder.RawElement value(IProjection proj) {
            if (proj == null) {
                return this.value("", new Object[0]);
            }
            return this.value(proj.getAbrev(), new Object[0]);
        }

        @Override
        public LayerInformationBuilder.RawElement asWKT(IProjection proj) {
            if (proj == null) {
                return this.value("", new Object[0]);
            }
            String s = proj.export("wkt");
            if (s == null) {
                s = proj.export("wkt_esri");
            }
            if (s == null) {
                s = proj.export("proj4");
            }
            if (s == null) {
                s = proj.getAbrev();
            }
            if (s != null) {
                s = s.replaceAll("\\[", "[\n  ");
                s = s.replaceAll("]", "\n]");
            }
            return this.value(s, new Object[0]);
        }

        @Override
        public LayerInformationBuilder.RawElement asWKT(Envelope env) {
            if (env == null) {
                return this.value("", new Object[0]);
            }
            return this.asWKT(env.getGeometry());
        }

        @Override
        public LayerInformationBuilder.RawElement asWKT(Geometry geom) {
            String s = "";
            try {
                s = geom.convertToWKT();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.value(s, new Object[0]);
        }

        @Override
        public String build() {
            String color = DefaultLayerInformationBuilder.this.propertyCount++ % 2 == 0 ? DefaultLayerInformationBuilder.this.backgroundColorPropertyValue1 : DefaultLayerInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            content = content + "<td bgcolor=" + color + "align=\"left\" colspan=\"2\"><font face=\"Arial\" size=\"3\"><div>" + this.value.replace("\\n", "<br>\n") + "</div></font></td>\n";
            content = content + "</tr>\n";
            return content;
        }
    }

    private class DefaultTitleElement
    implements LayerInformationBuilder.TitleElement {
        private String label;

        private DefaultTitleElement() {
        }

        @Override
        public DefaultTitleElement label(String label) {
            this.label = StringEscapeUtils.escapeHtml3((String)label);
            return this;
        }

        @Override
        public LayerInformationBuilder.TitleElement labelkey(String labelkey) {
            return this.label(ToolsLocator.getI18nManager().getTranslation(labelkey));
        }

        @Override
        public String build() {
            DefaultLayerInformationBuilder.this.propertyCount = 0;
            return "<tr valign=\"middle\" ><td bgcolor=" + DefaultLayerInformationBuilder.this.backgroundColorTitle + " align=\"center\" colspan=\"2\"><font face=\"Arial\" size=\"3\"><b> " + this.label + "</b></font></td>" + "</tr>";
        }
    }
}

