/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.merge;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;

public class MergeParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JComboBox fieldsCombo = null;
    private JCheckBox allLayers = null;
    private final String[] columnNames = new String[]{GeoProcessLocator.getGeoProcessManager().getTranslation("Selected"), GeoProcessLocator.getGeoProcessManager().getTranslation("Layer")};
    private final int[] columnWidths = new int[]{35, 334};
    private TableContainer table = null;
    private ObjectAndDescription[] layerList = null;
    private AlgorithmOutputPanel algorithmOutputPanel = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanelPol;
    private OutputChannelSelectionPanel outputChannelSelectionPanelLine;
    private OutputChannelSelectionPanel outputChannelSelectionPanelPoint;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 8, 5);
        this.add(this.getAllLayersCheck(), gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 12, 0);
        gbc.weighty = 1.0;
        this.add((Component)this.getCheckBoxTable(), gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 8, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add(this.getFieldsComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("use_fields_from_layer"), this.getFieldsCombo()), gbc);
        gbc.gridy = 3;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
        this.initTable();
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new GridBagLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out_pol = ooSet.getOutput("RESULT_POL");
                Output out_line = ooSet.getOutput("RESULT_LINE");
                Output out_point = ooSet.getOutput("RESULT_POINT");
                this.outputChannelSelectionPanelPol = new OutputChannelSelectionPanel(out_pol, this.m_Algorithm.getParameters());
                this.outputChannelSelectionPanelLine = new OutputChannelSelectionPanel(out_line, this.m_Algorithm.getParameters());
                this.outputChannelSelectionPanelPoint = new OutputChannelSelectionPanel(out_point, this.m_Algorithm.getParameters());
                String label = GeoProcessLocator.getGeoProcessManager().getTranslation("Merge");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 2;
                gbc.insets = new Insets(0, 0, 4, 0);
                gbc.weightx = 1.0;
                gbc.gridx = 0;
                gbc.gridy = 0;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Polygon") + "]               "), gbc);
                gbc.gridx = 0;
                gbc.gridy = 1;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Line") + "]               "), gbc);
                gbc.gridx = 0;
                gbc.gridy = 2;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Point") + "]               "), gbc);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.gridx = 1;
                gbc.gridy = 0;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelPol, gbc);
                gbc.gridx = 1;
                gbc.gridy = 1;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelLine, gbc);
                gbc.gridx = 1;
                gbc.gridy = 2;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelPoint, gbc);
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.algorithmOutputPanel == null) {
            this.algorithmOutputPanel = new AlgorithmOutputPanel();
        }
        return this.algorithmOutputPanel;
    }

    public JPanel getFieldsComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 0, 4, 0);
        JLabel label = new JLabel(text);
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 0, 4, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getFieldsCombo() {
        if (this.fieldsCombo == null) {
            this.fieldsCombo = new JComboBox();
            ObjectAndDescription[] fieldList = this.getLayerList();
            this.fieldsCombo.removeAllItems();
            for (int i = 0; i < fieldList.length; ++i) {
                this.fieldsCombo.addItem(fieldList[i]);
            }
        }
        return this.fieldsCombo;
    }

    public JCheckBox getAllLayersCheck() {
        if (this.allLayers == null) {
            this.allLayers = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("select_all_layers"));
            this.allLayers.addActionListener(this);
        }
        return this.allLayers;
    }

    public TableContainer getCheckBoxTable() {
        if (this.table == null) {
            this.table = new TableContainer(this.columnNames, this.columnWidths, null);
            this.table.setModel("CheckBoxModel");
            this.table.setControlVisible(false);
            this.table.initialize();
        }
        return this.table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getAllLayersCheck()) {
            try {
                for (int i = 0; i < this.getCheckBoxTable().getRowCount(); ++i) {
                    if (this.getAllLayersCheck().isSelected()) {
                        this.getCheckBoxTable().getModel().setValueAt(new Boolean(true), i, 0);
                        continue;
                    }
                    this.getCheckBoxTable().getModel().setValueAt(new Boolean(false), i, 0);
                }
            }
            catch (NotInitializeException e1) {
                Sextante.addErrorToLog((Throwable)e1);
            }
        }
    }

    private void initTable() {
        try {
            this.getCheckBoxTable().removeAllRows();
            ObjectAndDescription[] layerList = this.getLayerList();
            for (int i = 0; i < layerList.length; ++i) {
                this.addTableRow(layerList[i].getDescription());
            }
        }
        catch (NotInitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addTableRow(String layerName) throws NotInitializeException {
        Object[] row = new Object[]{new Boolean(false), layerName};
        this.getCheckBoxTable().addRow(row);
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("LAYERS").setParameterValue(this.getSelectedLayerList());
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output outPol = ooSet.getOutput("RESULT_POL");
            Output outLine = ooSet.getOutput("RESULT_LINE");
            Output outPoint = ooSet.getOutput("RESULT_POINT");
            outPol.setOutputChannel(this.outputChannelSelectionPanelPol.getOutputChannel());
            outLine.setOutputChannel(this.outputChannelSelectionPanelLine.getOutputChannel());
            outPoint.setOutputChannel(this.outputChannelSelectionPanelPoint.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        if (this.layerList == null) {
            IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
            this.layerList = new ObjectAndDescription[layers.length];
            for (int i = 0; i < layers.length; ++i) {
                this.layerList[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
            }
        }
        return this.layerList;
    }

    private ArrayList<IVectorLayer> getSelectedLayerList() {
        ObjectAndDescription[] layerList = this.getLayerList();
        ArrayList<IVectorLayer> vLayer = new ArrayList<IVectorLayer>();
        for (int i = 0; i < layerList.length; ++i) {
            Boolean check = (Boolean)this.getCheckBoxTable().getModel().getValueAt(i, 0);
            if (!check.booleanValue()) continue;
            vLayer.add((IVectorLayer)layerList[i].getObject());
        }
        return vLayer;
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.getFieldsCombo().getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.getFieldsCombo().getSelectedItem()).getObject();
        }
        return null;
    }
}

