/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.OceanTheme;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.SubstanceDropShadowBorder;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstancePaneBorder;
import org.jvnet.substance.SubstanceToolBarBorder;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceTheme
extends OceanTheme {
    private ColorUIResource INACTIVE_TEXT;
    private ColorUIResource CONTROL;
    private ColorUIResource CONTROL_SHADOW;
    private ColorUIResource CONTROL_DARK_SHADOW;
    private ColorUIResource PRIMARY_CONTROL_SHADOW;
    private ColorUIResource PRIMARY_CONTROL_DARK_SHADOW;
    private ColorSchemeEnum colorSchemeEnum;

    protected SubstanceTheme(ColorSchemeEnum colorSchemeEnum) {
        this.colorSchemeEnum = colorSchemeEnum;
        this.INACTIVE_TEXT = new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor());
        this.CONTROL = new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getExtraLightColor());
        this.CONTROL_SHADOW = new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor());
        this.CONTROL_DARK_SHADOW = new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getDarkColor());
        this.PRIMARY_CONTROL_SHADOW = new ColorUIResource(this.colorSchemeEnum.getColorScheme().getMidColor());
        this.PRIMARY_CONTROL_DARK_SHADOW = new ColorUIResource(this.colorSchemeEnum.getColorScheme().getDarkColor());
    }

    public ColorSchemeEnum getColorSchemeEnum() {
        return this.colorSchemeEnum;
    }

    public String getThemeName() {
        return this.colorSchemeEnum.name();
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        Icon menuArrowIcon = SubstanceImageCreator.getArrowIcon(7, 5, 3);
        Icon sliderHorIcon = SubstanceIconFactory.getSliderHorizontalIcon();
        Icon sliderVerIcon = SubstanceIconFactory.getSliderVerticalIcon();
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new SubstanceDefaultListCellRenderer.SubstanceUIResource();
            }
        };
        Object[] defaults = new Object[]{"control", new ColorUIResource(this.getControl()), "MenuBarUI", "org.jvnet.substance.SubstanceMenuBarUI", "Button.disabledText", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getDarkColor()), "RootPane.border", new SubstancePaneBorder(), "InternalFrame.border", new SubstancePaneBorder(), "ProgressBar.border", new SubstanceDropShadowBorder(0), "List.focusCellHighlightBorder", new SubstanceBorder(), "TextField.border", new SubstanceDropShadowBorder(), "FormattedTextField.border", new SubstanceDropShadowBorder(), "Spinner.border", new SubstanceBorder(), "PasswordField.border", new SubstanceDropShadowBorder(), "TextArea.border", new SubstanceDropShadowBorder(), "TextPane.border", new SubstanceDropShadowBorder(), "TabbedPane.selectHighlight", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getMidColor()), "TabbedPane.contentAreaColor", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getUltraLightColor()), "TabbedPane.borderHightlightColor", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getMidColor()), "TabbedPane.shadow", this.colorSchemeEnum.getColorScheme().getExtraLightColor(), "TabbedPane.darkShadow", this.colorSchemeEnum.getColorScheme().getLightColor(), "TextField.background", table.getColor("window"), "Slider.horizontalThumbIcon", sliderHorIcon, "Slider.verticalThumbIcon", sliderVerIcon, "Menu.arrowIcon", menuArrowIcon, "CheckBoxMenuItem.checkIcon", new IconUIResource(SubstanceIconFactory.getCheckBoxMenuItemIcon()), "RadioButtonMenuItem.checkIcon", new IconUIResource(SubstanceIconFactory.getRadioButtonMenuItemIcon()), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "Menu.borderPainted", Boolean.FALSE, "MenuItem.borderPainted", Boolean.FALSE, "Menu.selectionForeground", new ColorUIResource(Color.black), "Menu.disabledForeground", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor()), "MenuItem.selectionForeground", new ColorUIResource(Color.black), "MenuItem.disabledForeground", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor()), "RadioButtonMenuItem.selectionForeground", new ColorUIResource(Color.black), "RadioButtonMenuItem.disabledForeground", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getMidColor()), "CheckBoxMenuItem.selectionForeground", new ColorUIResource(Color.black), "CheckBoxMenuItem.disabledForeground", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor()), "TableHeader.cellBorder", null, "ToggleButton.disabledText", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getDarkColor()), "List.cellRenderer", listCellRendererActiveValue, "ToolTip.border", new SubstanceDropShadowBorder(0), "ToolTip.borderInactive", new SubstanceDropShadowBorder(0), "ToolTip.backgroundInactive", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getExtraLightColor()), "ToolTip.foregroundInactive", new ColorUIResource(ColorSchemeEnum.METALLIC.getColorScheme().getMidColor()), "Spinner.editorBorderPainted", Boolean.FALSE, "ToolBar.border", new SubstanceToolBarBorder(), "ToolBar.background", new ColorUIResource(this.getControl()), "MenuBar.background", new ColorUIResource(this.getControl()), "Menu.background", new ColorUIResource(this.getControl()), "MenuItem.background", new ColorUIResource(this.getControl()), "PopupMenu.background", new ColorUIResource(this.getControl()), "CheckBoxMenuItem.background", new ColorUIResource(this.getControl()), "RadioButtonMenuItem.background", new ColorUIResource(this.getControl()), "OptionPane.background", new ColorUIResource(this.getControl()), "ColorChooser.background", new ColorUIResource(this.getControl()), "Dialog.background", new ColorUIResource(this.getControl()), "Panel.background", new ColorUIResource(this.getControl()), "Separator.background", new ColorUIResource(this.getControl()), "ScrollPane.background", new ColorUIResource(this.getControl()), "Viewport.background", new ColorUIResource(this.getControl()), "SplitPane.background", new ColorUIResource(this.getControl()), "TabbedPane.background", new ColorUIResource(this.getControl()), "RootPane.background", new ColorUIResource(this.getControl()), "Slider.highlight", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getLightColor()), "Slider.altTrackColor", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getLightColor()), "Slider.darkShadow", new ColorUIResource(this.colorSchemeEnum.getColorScheme().getMidColor()), "Tree.closedIcon", new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceImageCreator.TreeIcon.CLOSED))), "Tree.collapsedIcon", new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(true))), "Tree.expandedIcon", new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(false))), "Tree.leafIcon", new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeLeafIcon())), "Tree.openIcon", new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceImageCreator.TreeIcon.OPENED))), "FileView.directoryIcon", new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceImageCreator.TreeIcon.CLOSED)), "FileChooser.upFolderIcon", new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceImageCreator.TreeIcon.UP)), "FileChooser.newFolderIcon", new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceImageCreator.TreeIcon.NONE)), "FileChooser.homeFolderIcon", new ImageIcon(SubstanceImageCreator.getHomeIcon()), "FileView.fileIcon", new ImageIcon(SubstanceImageCreator.getTreeLeafIcon()), "FileView.computerIcon", new ImageIcon(SubstanceImageCreator.getComputerIcon()), "FileView.hardDriveIcon", new ImageIcon(SubstanceImageCreator.getDiskIcon()), "FileView.floppyDriveIcon", new ImageIcon(SubstanceImageCreator.getFloppyIcon()), "InternalFrame.closeIcon", SubstanceImageCreator.getCloseIcon(this.colorSchemeEnum), "InternalFrame.paletteCloseIcon", SubstanceImageCreator.getCloseIcon(this.colorSchemeEnum), "InternalFrame.iconifyIcon", SubstanceImageCreator.getMinimizeIcon(this.colorSchemeEnum), "InternalFrame.minimizeIcon", SubstanceImageCreator.getRestoreIcon(this.colorSchemeEnum), "InternalFrame.maximizeIcon", SubstanceImageCreator.getMaximizeIcon(this.colorSchemeEnum)};
        table.putDefaults(defaults);
    }

    public ColorUIResource getInactiveSystemTextColor() {
        return this.INACTIVE_TEXT;
    }

    public ColorUIResource getControlDarkShadow() {
        return this.CONTROL_DARK_SHADOW;
    }

    public ColorUIResource getControl() {
        return this.CONTROL;
    }

    public ColorUIResource getControlShadow() {
        return this.CONTROL_SHADOW;
    }

    public ColorUIResource getPrimaryControlDarkShadow() {
        return this.PRIMARY_CONTROL_DARK_SHADOW;
    }

    public ColorUIResource getPrimaryControlShadow() {
        return this.PRIMARY_CONTROL_SHADOW;
    }
}

