/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dxf;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.tools.dynobject.DelegatedDynObject;

public class DXFOpenStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "DXFStoreParameters";
    static final String FILE_PARAMTER_NAME = "File";
    static final String CRS_PARAMTER_NAME = "CRS";
    private DelegatedDynObject parameters;

    public DXFOpenStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected DXFOpenStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, "DXF");
    }

    public DXFOpenStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public void setCRS(String srs) {
        this.setDynValue(CRS_PARAMTER_NAME, srs);
    }

    public void setCRS(IProjection srs) {
        this.setDynValue(CRS_PARAMTER_NAME, srs);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue(CRS_PARAMTER_NAME);
    }

    public String getFileName() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getPath();
    }

    public boolean isValid() {
        if (this.getCRS() == null) {
            return false;
        }
        return this.getFileName() != null;
    }

    public File getFile() {
        return (File)this.getDynValue(FILE_PARAMTER_NAME);
    }

    public void setFile(File file) {
        String wktEsri;
        this.setDynValue(FILE_PARAMTER_NAME, file);
        if (this.getCRS() == null && (wktEsri = this.loadPrj(file)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    public void setFile(String file) {
        String wktEsri;
        this.setDynValue(FILE_PARAMTER_NAME, file);
        File dxfFile = (File)this.getDynValue(FILE_PARAMTER_NAME);
        if (this.getCRS() == null && (wktEsri = this.loadPrj(dxfFile)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    private String loadPrj(File dxfFile) {
        File prjFile = new File(FilenameUtils.removeExtension((String)dxfFile.getAbsolutePath()) + ".prj");
        if (prjFile.exists()) {
            try {
                return FileUtils.readFileToString((File)prjFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

