/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.exception.ServerExplorerAddException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.ZipResourcesStorage;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.FilteredIterator;

public class DefaultFilesystemServerExplorer
extends AbstractDataServerExplorer
implements FilesystemServerExplorerProviderServices,
FilesystemFileFilter {
    private File root;
    private File current;
    private List<FilesystemServerExplorerProvider> serverProviders;

    public DefaultFilesystemServerExplorer(FilesystemServerExplorerParameters parameters, DataServerExplorerProviderServices services) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
        if (this.getFSParameters().getRoot() != null) {
            this.root = new File(this.getFSParameters().getRoot());
        }
        if (this.getFSParameters().getInitialpath() != null) {
            this.current = new File(this.getFSParameters().getInitialpath());
        }
        if ((this.root != null || this.current != null) && this.current == null) {
            this.current = new File(this.getFSParameters().getRoot());
        }
    }

    private FilesystemServerExplorerParameters getFSParameters() {
        return (FilesystemServerExplorerParameters)this.getParameters();
    }

    protected void doDispose() throws BaseException {
        this.root = null;
        super.doDispose();
    }

    public List list(int mode) throws DataException {
        String[] allfiles;
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (!this.current.exists()) {
            throw new FileNotFoundException(this.current);
        }
        if (!this.current.isDirectory()) {
            throw new IllegalArgumentException(this.getProviderName() + ": Path not a directory '" + this.current + "'");
        }
        ArrayList<DataStoreParameters> files = new ArrayList<DataStoreParameters>();
        List providers = this.getProviders(mode);
        block0: for (String f : allfiles = this.current.list()) {
            File file = new File(this.root, f);
            for (FilesystemServerExplorerProvider provider : providers) {
                if (!provider.accept(file)) continue;
                DataStoreParameters dsp = this.createStoreParameters(file);
                if (dsp == null) continue block0;
                files.add(dsp);
                continue block0;
            }
        }
        return files;
    }

    public List list() throws DataException {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (!this.current.exists()) {
            throw new FileNotFoundException(this.current);
        }
        if (!this.current.isDirectory()) {
            throw new IllegalArgumentException(this.getProviderName() + ": Path not a directory '" + this.current + "'");
        }
        String[] files = this.current.list();
        ArrayList<DataStoreParameters> list = new ArrayList<DataStoreParameters>();
        for (int i = 0; i < files.length; ++i) {
            File theFile = new File(this.root, files[i]);
            DataStoreParameters dsp = this.createStoreParameters(theFile);
            if (dsp == null) continue;
            list.add(dsp);
        }
        return list;
    }

    @Override
    public void setCurrentPath(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path);
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getPath() + " is not a directory");
        }
        if (!this.isFromRoot(path)) {
            throw new IllegalArgumentException(path.getPath() + " is not from root");
        }
        this.current = path;
    }

    @Override
    public File getCurrentPath() {
        return this.current;
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    public void remove(DataStoreParameters dsp) throws RemoveException {
        String providerName = dsp.getDataStoreName();
        try {
            this.checkIsMine(dsp);
            FilesystemServerExplorerProvider provider = this.getProvider(providerName);
            provider.remove(dsp);
        }
        catch (DataException e) {
            throw new RemoveException(this.getProviderName(), (Throwable)e);
        }
    }

    public boolean add(String providerName, NewDataStoreParameters ndsp, boolean overwrite) throws DataException {
        try {
            this.checkIsMine((DataStoreParameters)ndsp);
            FilesystemServerExplorerProvider provider = this.getProvider(providerName);
            ndsp.validate();
            provider.create(ndsp, overwrite);
            if (ndsp instanceof NewFeatureStoreParameters) {
                DataManager dataManager = DALLocator.getDataManager();
                ResourcesStorage resources = this.getResourcesStorage((DataStoreParameters)ndsp);
                dataManager.writeDALResource(resources, (FeatureType)((NewFeatureStoreParameters)ndsp).getDefaultFeatureType());
            }
            return true;
        }
        catch (DataException | ValidateDataParametersException e) {
            throw new ServerExplorerAddException(this.getProviderName(), e);
        }
    }

    public boolean canAdd() {
        return this.root.canWrite();
    }

    public String getProviderName() {
        return "FilesystemExplorer";
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        FilesystemServerExplorerProvider provider = this.getProvider(storeName);
        if (provider == null) {
            throw new IllegalArgumentException("Not registered in this explorer");
        }
        NewDataStoreParameters nParams = provider.getCreateParameters();
        return nParams;
    }

    public boolean canAdd(String storeName) throws DataException {
        if (storeName == null) {
            return false;
        }
        FilesystemServerExplorerProvider provider = this.getProvider(storeName);
        if (provider == null) {
            throw new IllegalArgumentException("Not registered in this explorer");
        }
        return provider.canCreate();
    }

    private FilesystemServerExplorerProvider getProvider(String providerName) throws InitializeException, ProviderNotRegisteredException {
        for (FilesystemServerExplorerProvider provider : this.getProviders(0)) {
            if (!provider.getDataStoreProviderName().equals(providerName)) continue;
            return provider;
        }
        return null;
    }

    private DataManagerProviderServices getManager() {
        return (DataManagerProviderServices)DALLocator.getDataManager();
    }

    @Override
    public DataStoreParameters createStoreParameters(File file, String providerName) throws DataException {
        return this.getParametersFor(file, providerName, true);
    }

    @Override
    public DataStoreParameters createStoreParameters(File file) throws DataException {
        return this.getParametersFor(file, null, true);
    }

    public DataStoreParameters getParametersFor(File file, String providerName, boolean checksExist) throws DataException {
        if (checksExist) {
            if (!file.exists()) {
                return null;
            }
            if (!file.isFile()) {
                return null;
            }
            if (!file.canRead()) {
                return null;
            }
            if (file.isHidden()) {
                return null;
            }
        }
        if (providerName == null) {
            providerName = this.getProviderName(file);
        }
        if (providerName != null) {
            DataStoreParameters params = this.getManager().createStoreParameters(providerName);
            ((FilesystemStoreParameters)params).setFile(file);
            try {
                params.validate();
            }
            catch (Throwable th) {
                LOGGER.debug("Can't validate parameters for file '" + Objects.toString(file) + "'.", th);
            }
            return params;
        }
        return null;
    }

    @Override
    public List<String> getProviderNameList(File file) {
        Iterator<FilesystemServerExplorerProvider> filters = this.getFilters();
        ArrayList<String> list = new ArrayList<String>();
        while (filters.hasNext()) {
            FilesystemFileFilter filter = filters.next();
            if (!filter.accept(file)) continue;
            list.add(filter.getDataStoreProviderName());
        }
        return list;
    }

    @Override
    public String getProviderName(File file) {
        Iterator<FilesystemServerExplorerProvider> filters = this.getFilters();
        while (filters.hasNext()) {
            FilesystemFileFilter filter = filters.next();
            if (!filter.accept(file)) continue;
            return filter.getDataStoreProviderName();
        }
        return null;
    }

    public List getDataStoreProviderNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator<FilesystemServerExplorerProvider> filters = this.getFilters();
        while (filters.hasNext()) {
            FilesystemFileFilter filter = filters.next();
            names.add(filter.getDataStoreProviderName());
        }
        return new ArrayList(names);
    }

    private void checkIsMine(DataStoreParameters dsp) throws IllegalArgumentException, DataException {
        if (!(dsp instanceof FilesystemStoreParameters)) {
            throw new IllegalArgumentException("not instance of FilesystemStoreParameters");
        }
        Iterator<FilesystemServerExplorerProvider> filters = this.getFilters();
        File file = ((FilesystemStoreParameters)dsp).getFile();
        if (!this.isFromRoot(file)) {
            throw new IllegalArgumentException("worng explorer");
        }
        while (filters.hasNext()) {
            FilesystemFileFilter filter = filters.next();
            if (!dsp.getDataStoreName().equals(filter.getDataStoreProviderName())) continue;
            return;
        }
        throw new IllegalArgumentException("worng explorer");
    }

    private boolean isFromRoot(File file) {
        if (this.root == null) {
            return true;
        }
        return file.getAbsolutePath().startsWith(this.root.getAbsolutePath());
    }

    public List<FilesystemServerExplorerProvider> getProviders() {
        if (this.serverProviders == null) {
            Iterator iter = DALFileLocator.getFilesystemServerExplorerManager().getRegisteredProviders();
            this.serverProviders = new ArrayList<FilesystemServerExplorerProvider>();
            while (iter.hasNext()) {
                FilesystemServerExplorerProvider provider;
                FilesystemServerExplorerProviderFactory factory;
                ExtensionPoint.Extension ext = (ExtensionPoint.Extension)iter.next();
                try {
                    factory = (FilesystemServerExplorerProviderFactory)ext.create();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    provider = factory.createProvider();
                }
                catch (InitializeException e) {
                    throw new RuntimeException(e);
                }
                provider.initialize(this);
                this.serverProviders.add(provider);
            }
        }
        return this.serverProviders;
    }

    public List getProviders(int mode) {
        ArrayList<FilesystemServerExplorerProvider> providers = new ArrayList<FilesystemServerExplorerProvider>();
        List<FilesystemServerExplorerProvider> allProviders = this.getProviders();
        for (FilesystemServerExplorerProvider provider : allProviders) {
            if (!provider.isMode(mode)) continue;
            provider.initialize(this);
            providers.add(provider);
        }
        return providers;
    }

    @Override
    public Iterator getFilters(int mode) {
        Iterator it = this.getProviders(mode).iterator();
        return new FilteredIterator(it, (Predicate)new Predicate<FilesystemServerExplorerProvider>(){

            @Override
            public boolean test(FilesystemServerExplorerProvider p) {
                FilesystemServerExplorerProviderFactory factory;
                if (p instanceof AbstractFilesystemServerExplorerProvider && (factory = ((AbstractFilesystemServerExplorerProvider)p).getFactory()) != null) {
                    return !factory.isHidden();
                }
                return true;
            }
        });
    }

    @Override
    public Iterator<FilesystemServerExplorerProvider> getFilters() {
        Iterator<FilesystemServerExplorerProvider> it = this.getProviders().iterator();
        return new FilteredIterator(it, (Predicate)new Predicate<FilesystemServerExplorerProvider>(){

            @Override
            public boolean test(FilesystemServerExplorerProvider p) {
                FilesystemServerExplorerProviderFactory factory;
                if (p instanceof AbstractFilesystemServerExplorerProvider && (factory = ((AbstractFilesystemServerExplorerProvider)p).getFactory()) != null) {
                    return !factory.isHidden();
                }
                return true;
            }
        });
    }

    @Override
    public FilesystemFileFilter getFilter(int mode, final String description) {
        final ArrayList filters = new ArrayList();
        Iterator it = this.getFilters(mode);
        while (it.hasNext()) {
            filters.add(it.next());
        }
        FilesystemFileFilter filter = new FilesystemFileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < filters.size(); ++i) {
                    if (!((FilesystemFileFilter)filters.get(i)).accept(f)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getDataStoreProviderName() {
                return null;
            }
        };
        return filter;
    }

    @Override
    public FilesystemFileFilter getGenericFilter() {
        return this;
    }

    @Override
    public String getDataStoreProviderName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "All supporteds";
    }

    @Override
    public boolean accept(File pathname) {
        try {
            return this.createStoreParameters(pathname) != null;
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
    }

    public DataStore open(File file) throws DataException, ValidateDataParametersException {
        DataManager manager = DALLocator.getDataManager();
        String providerName = this.getProviderName(file);
        NewDataStoreParameters params = this.getAddParameters(file);
        return manager.openStore(providerName, (DataStoreParameters)params);
    }

    @Override
    public NewDataStoreParameters getAddParameters(File file) throws DataException {
        DataStoreParameters params = this.getParametersFor(file, null, false);
        NewDataStoreParameters newParams = this.getAddParameters(params.getDataStoreName());
        ((FilesystemStoreParameters)newParams).setFile(((FilesystemStoreParameters)params).getFile());
        return newParams;
    }

    @Deprecated
    public File getResourcePath(DataStore dataStore, String resourceName) throws DataException {
        try {
            ResourcesStorage theResourceStorage = this.getResourcesStorage(dataStore);
            if (theResourceStorage == null) {
                return null;
            }
            FilesResourcesStorage.FileResource res = (FilesResourcesStorage.FileResource)theResourceStorage.getResource(resourceName);
            if (res == null) {
                return null;
            }
            return res.getFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getResourcePathName(DataStoreParameters parameters) {
        FilesystemServerExplorerProvider provider;
        try {
            provider = this.getProvider(parameters.getProviderName());
        }
        catch (Exception ex) {
            return null;
        }
        if (provider == null) {
            return null;
        }
        String pathName = provider.getResourceRootPathName(parameters);
        if (pathName == null) {
            return null;
        }
        pathName = FilenameUtils.removeExtension((String)pathName);
        return pathName;
    }

    public ResourcesStorage getResourcesStorage(DataStoreParameters parameters) {
        FilesResourcesStorage theResourcesStorage;
        String pathName = this.getResourcePathName(parameters);
        if (ZipResourcesStorage.existsStorage((String)pathName)) {
            String resourceName = FilenameUtils.getBaseName((String)pathName);
            theResourcesStorage = new ZipResourcesStorage(pathName, resourceName);
        } else {
            theResourcesStorage = new FilesResourcesStorage(pathName);
        }
        return theResourcesStorage;
    }

    public ResourcesStorage getResourcesStorage(DataStore dataStore) {
        ResourcesStorage theResourcesStorage;
        if (dataStore.getChildren().isEmpty()) {
            theResourcesStorage = this.getResourcesStorage(dataStore.getParameters());
        } else {
            String pathName = this.getResourcePathName(dataStore.getParameters());
            theResourcesStorage = new ZipResourcesStorage(pathName, dataStore.getName());
        }
        return theResourcesStorage;
    }

    public DataStoreParameters get(String name) throws DataException {
        File theFile = new File(this.current, name);
        DataStoreParameters dsp = this.createStoreParameters(theFile);
        return dsp;
    }

    public boolean exists(DataStoreParameters parameters) throws DataException {
        if (!(parameters instanceof FilesystemStoreParameters)) {
            return false;
        }
        File f = ((FilesystemStoreParameters)parameters).getFile();
        return f.exists();
    }
}

