/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl;

import java.util.Date;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.Chronology;
import org.gvsig.timesupport.EditableRelativeInstant;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.impl.DefaultChronology;
import org.gvsig.timesupport.impl.DefaultEditableRelativeInstant;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class DefaultRelativeInstant
implements RelativeInstant {
    private DateTime jodaDateTime = null;
    private Chronology chronology = null;

    DefaultRelativeInstant(long instant, Chronology chronology) {
        this.jodaDateTime = new DateTime(instant, ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInstant(Chronology chronology) {
        this.jodaDateTime = new DateTime(((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInstant(Chronology chronology, DateTime dateTime) {
        this.jodaDateTime = dateTime;
        this.chronology = chronology;
    }

    DefaultRelativeInstant(Chronology chronology, Period period) {
        this.jodaDateTime = new DateTime(period.getYears(), period.getMonths(), period.getDays(), period.getHours(), period.getMinutes(), period.getSeconds(), period.getMillis(), ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInstant(Chronology chronology, AbsoluteInstant absoluteInstant) {
        this.jodaDateTime = new DateTime(absoluteInstant.getYears(), absoluteInstant.getMonths(), absoluteInstant.getDays(), absoluteInstant.getHours(), absoluteInstant.getMinutes(), absoluteInstant.getSeconds(), absoluteInstant.getMillis(), ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInstant(Date date, Chronology chronology) {
        this.jodaDateTime = new DateTime((Object)date, ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    DefaultRelativeInstant(DateTime jodaDateTime, Chronology chronology) {
        this.jodaDateTime = jodaDateTime;
        this.chronology = chronology;
    }

    DefaultRelativeInstant(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        this.jodaDateTime = new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ((DefaultChronology)chronology).getJodaType());
        this.chronology = chronology;
    }

    public int getHourOfDay() {
        return this.jodaDateTime.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.jodaDateTime.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.jodaDateTime.getSecondOfMinute();
    }

    public int getMinuteOfDay() {
        return this.jodaDateTime.getMinuteOfDay();
    }

    public int getSecondOfDay() {
        return this.jodaDateTime.getSecondOfDay();
    }

    public EditableRelativeInstant getEditableCopy() {
        return new DefaultEditableRelativeInstant(this.jodaDateTime.toMutableDateTime(), this.chronology);
    }

    public long toMillis() {
        return this.jodaDateTime.getMillis();
    }

    public String toString(String pattern) {
        return this.jodaDateTime.toString(pattern);
    }

    public String toString() {
        return this.jodaDateTime.toString();
    }

    public Date toDate() {
        return this.jodaDateTime.toDate();
    }

    public boolean isEqual(Instant instant) {
        return this.jodaDateTime.isEqual((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean isAfter(Instant instant) {
        return this.jodaDateTime.isAfter((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean isBefore(Instant instant) {
        return this.jodaDateTime.isBefore((ReadableInstant)((DefaultRelativeInstant)instant).getJodaType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultRelativeInstant)) {
            return false;
        }
        return ((DefaultRelativeInstant)obj).getJodaType().equals((Object)this.jodaDateTime);
    }

    public int getMillisOfSecond() {
        return this.jodaDateTime.getMillisOfSecond();
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public int getYear() {
        return this.jodaDateTime.getYear();
    }

    public int getMonthOfYear() {
        return this.jodaDateTime.getMonthOfYear();
    }

    public int getWeekOfWeekyear() {
        return this.jodaDateTime.getWeekOfWeekyear();
    }

    public int getDayOfWeek() {
        return this.jodaDateTime.getDayOfWeek();
    }

    public int getDayOfMonth() {
        return this.jodaDateTime.getDayOfMonth();
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultRelativeInstant(this.chronology, new DateTime((Object)this.jodaDateTime));
    }

    public boolean intersects(Time time) {
        if (time.isRelative()) {
            if (time.isInterval()) {
                return ((RelativeInterval)time).toDurationMillis() == 0L && ((RelativeInterval)time).getStart().equals(this);
            }
            return this.equals(time);
        }
        return true;
    }

    public boolean isRelative() {
        return true;
    }

    public final boolean isAbsolute() {
        return false;
    }

    public final boolean isInterval() {
        return false;
    }

    public boolean isInstant() {
        return true;
    }

    public int compareTo(Instant instant) {
        return this.getJodaType().compareTo((Object)((DefaultRelativeInstant)instant).getJodaType());
    }

    DateTime getJodaType() {
        return this.jodaDateTime;
    }
}

