/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInstantType;
import org.gvsig.timesupport.AbsoluteInstantTypeNotRegisteredException;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.AbsoluteIntervalType;
import org.gvsig.timesupport.AbsoluteIntervalTypeNotRegisteredException;
import org.gvsig.timesupport.Chronology;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.animation.TimeAnimation;
import org.gvsig.timesupport.impl.DefaultAbsoluteInstant;
import org.gvsig.timesupport.impl.DefaultAbsoluteInstantType;
import org.gvsig.timesupport.impl.DefaultAbsoluteInterval;
import org.gvsig.timesupport.impl.DefaultRelativeInstant;
import org.gvsig.timesupport.impl.DefaultRelativeInterval;
import org.gvsig.timesupport.impl.animation.TimeAnimationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeSupportManager
implements TimeSupportManager {
    private Logger LOG = LoggerFactory.getLogger(DefaultTimeSupportManager.class);
    private Map absoluteInstantTypes = new HashMap();
    private Map chronologyes = new HashMap();
    private Map absoluteIntervalTypes = new HashMap();
    private Chronology defaultChronology = null;
    private List relativeInstantPatterns = new ArrayList();

    public void registerAbsoluteInstantType(AbsoluteInstantType absoluteInstantType) {
        this.absoluteInstantTypes.put(absoluteInstantType.getType(), absoluteInstantType);
    }

    public AbsoluteInstantType getAbsoluteInstantType(int type) throws AbsoluteInstantTypeNotRegisteredException {
        if (this.absoluteInstantTypes.containsKey(type)) {
            return (AbsoluteInstantType)this.absoluteInstantTypes.get(type);
        }
        throw new AbsoluteInstantTypeNotRegisteredException(type);
    }

    public void registerAbsoluteIntervalType(AbsoluteIntervalType absoluteIntervalType) {
        this.absoluteIntervalTypes.put(absoluteIntervalType.getType(), absoluteIntervalType);
    }

    public AbsoluteIntervalType getAbsoluteIntervalType(int type) throws AbsoluteIntervalTypeNotRegisteredException {
        if (this.absoluteIntervalTypes.containsKey(type)) {
            return (AbsoluteIntervalType)this.absoluteIntervalTypes.get(type);
        }
        throw new AbsoluteIntervalTypeNotRegisteredException(type);
    }

    public void registerChronology(Chronology chronology) {
        this.chronologyes.put(chronology.getType(), chronology);
    }

    public Chronology getChronology(int chronology) {
        if (this.chronologyes.containsKey(chronology)) {
            return (Chronology)this.chronologyes.get(chronology);
        }
        return null;
    }

    public void setDefaultChronology(int chronology) {
        this.defaultChronology = this.getChronology(chronology).withUTC();
    }

    public RelativeInstant createRelativeInstant(long instant) {
        return new DefaultRelativeInstant(instant, this.defaultChronology);
    }

    public RelativeInstant createRelativeInstant(Date date) {
        return new DefaultRelativeInstant(date, this.defaultChronology);
    }

    public AbsoluteInstant createAbsoluteInstant() {
        return new DefaultAbsoluteInstant(this.defaultChronology);
    }

    public RelativeInstant createRelativeInstant(long instant, Chronology chronology) {
        return new DefaultRelativeInstant(instant, chronology);
    }

    public RelativeInstant createRelativeInstant(Date date, Chronology chronology) {
        return new DefaultRelativeInstant(date, chronology);
    }

    public RelativeInstant createRelativeInstant(Chronology chronology) {
        return new DefaultRelativeInstant(chronology);
    }

    public RelativeInstant createRelativeInstant(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new DefaultRelativeInstant(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, this.defaultChronology);
    }

    public RelativeInstant createRelativeInstant(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        return new DefaultRelativeInstant(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, chronology);
    }

    public RelativeInstant createRelativeInstant(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, int chronology) {
        return new DefaultRelativeInstant(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, this.getChronology(chronology));
    }

    public AbsoluteInstant createAbsoluteInstant(int type, int value) throws AbsoluteInstantTypeNotRegisteredException {
        return new DefaultAbsoluteInstant((DefaultAbsoluteInstantType)this.getAbsoluteInstantType(type), value, this.defaultChronology);
    }

    public AbsoluteInstant createAbsoluteInstant(int[] types, int[] values) throws AbsoluteInstantTypeNotRegisteredException {
        return this.createAbsoluteInstant(types, values, this.defaultChronology);
    }

    public AbsoluteInstant createAbsoluteInstant(int type, int value, Chronology chronology) throws AbsoluteInstantTypeNotRegisteredException {
        return new DefaultAbsoluteInstant((DefaultAbsoluteInstantType)this.getAbsoluteInstantType(type), value, chronology);
    }

    public AbsoluteInstant createAbsoluteInstant(int[] types, int[] values, Chronology chronology) throws AbsoluteInstantTypeNotRegisteredException {
        DefaultAbsoluteInstantType[] dateTimeFieldTypes = new DefaultAbsoluteInstantType[types.length];
        for (int i = 0; i < types.length; ++i) {
            dateTimeFieldTypes[i] = (DefaultAbsoluteInstantType)this.getAbsoluteInstantType(types[i]);
        }
        return new DefaultAbsoluteInstant(dateTimeFieldTypes, values, chronology);
    }

    public AbsoluteInstant createAbsoluteInstant(Chronology chronology) {
        return new DefaultAbsoluteInstant(chronology);
    }

    public RelativeInterval createRelativeInterval(long startInstant, long endInstant) {
        return new DefaultRelativeInterval(startInstant, endInstant, this.defaultChronology);
    }

    public RelativeInterval createRelativeInterval(RelativeInstant startDateTime, RelativeInstant endDateTime) {
        return new DefaultRelativeInterval(startDateTime, endDateTime, this.defaultChronology);
    }

    public RelativeInterval createRelativeInterval(long startInstant, long endInstant, Chronology chronology) {
        return new DefaultRelativeInterval(startInstant, endInstant, chronology);
    }

    public RelativeInterval createRelativeInterval(RelativeInstant startDateTime, RelativeInstant endDateTime, Chronology chronology) {
        return new DefaultRelativeInterval(startDateTime, endDateTime, chronology);
    }

    public AbsoluteInterval createAbsoluteInterval(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) throws AbsoluteIntervalTypeNotRegisteredException {
        return new DefaultAbsoluteInterval(years, months, weeks, days, hours, minutes, seconds, millis, this.defaultChronology);
    }

    public AbsoluteInterval createAbsoluteInterval(AbsoluteInstant startPartial, int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) throws AbsoluteIntervalTypeNotRegisteredException {
        return new DefaultAbsoluteInterval(startPartial, years, months, weeks, days, hours, minutes, seconds, millis, this.defaultChronology);
    }

    public AbsoluteInterval createAbsoluteInterval(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, Chronology chronology) throws AbsoluteIntervalTypeNotRegisteredException {
        return new DefaultAbsoluteInterval(years, months, weeks, days, hours, minutes, seconds, millis, chronology);
    }

    public AbsoluteInterval createAbsoluteInterval(AbsoluteInstant startPartial, int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, Chronology chronology) throws AbsoluteIntervalTypeNotRegisteredException {
        return new DefaultAbsoluteInterval(startPartial, years, months, weeks, days, hours, minutes, seconds, millis, chronology);
    }

    public AbsoluteInterval createAbsoluteInterval(AbsoluteInstant startPartial, AbsoluteInstant endPartial) {
        return new DefaultAbsoluteInterval(startPartial, endPartial, this.defaultChronology);
    }

    public AbsoluteInterval createAbsoluteInterval(RelativeInstant startPartial, RelativeInstant endPartial) {
        return new DefaultAbsoluteInterval(startPartial, endPartial, this.defaultChronology);
    }

    public AbsoluteInterval createAbsoluteInterval(AbsoluteInstant startInstant, AbsoluteInstant endInstant, Chronology chronology) throws AbsoluteIntervalTypeNotRegisteredException {
        return new DefaultAbsoluteInterval(startInstant, endInstant, chronology);
    }

    public void addRelativeInstantPattern(String relativeInstantPattern) {
        this.relativeInstantPatterns.add(relativeInstantPattern);
    }

    public RelativeInstant parseRelativeInstant(String relativeInstantString) {
        for (int i = 0; i < this.relativeInstantPatterns.size(); ++i) {
            try {
                Date date = new SimpleDateFormat((String)this.relativeInstantPatterns.get(i)).parse(relativeInstantString);
                if (date == null) continue;
                return this.createRelativeInstant(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public TimeAnimation createTimeAnimation(TimeAnimation.TimeAnimationRenderer renderer) {
        return new TimeAnimationImpl(renderer);
    }
}

