/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom;

import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.text.DMSNumberFormat;
import org.gvsig.tools.util.ToolsUtilLocator;

public class GeometryUtils {
    public static final int ANGLE_TURN_CLOCKWISE = -1;
    public static final int ANGLE_TURN_COUNTERCLOCKWISE = 1;
    public static final int ANGLE_TURN_NONE = 0;

    private GeometryUtils() {
    }

    public static GeometryType getGeometryType(int geometryType, int geometrySubType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.getGeometryType(geometryType, geometrySubType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isSubtype(int geomTypeParent, int geomTypeChild) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(geomTypeParent, geomTypeChild);
    }

    public static boolean canAggregate(int geomTypeParent, int geomTypeChild) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.canAggregate(geomTypeParent, geomTypeChild);
    }

    public static Envelope createEnvelope(int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createEnvelope(subType);
        }
        catch (CreateEnvelopeException ex) {
            return null;
        }
    }

    public static Envelope createEnvelope(double minX, double minY, double maxX, double maxY, int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createEnvelope(minX, minY, maxX, maxY, subType);
        }
        catch (CreateEnvelopeException ex) {
            return null;
        }
    }

    public static Line createLine(int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createLine(subType);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static MultiLine createMultiLine(int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createMultiLine(subType);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static Polygon createPolygon(int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createPolygon(subType);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static MultiPolygon createMultiPolygon(int subType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createMultiPolygon(subType);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static Point createPoint(double x, double y) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createPoint(x, y, 0);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static Point createPoint(double x, double y, double z) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            Point p = geomManager.createPoint(x, y, 1);
            p.setCoordinateAt(2, z);
            return p;
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static Point createPoint(double x, double y, double z, double m) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            Point p = geomManager.createPoint(x, y, 3);
            p.setCoordinateAt(2, z);
            p.setCoordinateAt(p.getDimension() - 1, m);
            return p;
        }
        catch (CreateGeometryException ex) {
            return null;
        }
    }

    public static Point createPoint(Point center, double radius, double angle) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return GeometryUtils.createPoint(center.getX() + radius * Math.cos(angle), center.getY() + radius * Math.sin(angle));
    }

    public static Geometry createFrom(Object data) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createFrom(data);
        }
        catch (GeometryException ex) {
            return null;
        }
    }

    public static Geometry createFrom(String wkt, String srs) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createFrom(wkt, srs);
        }
        catch (GeometryException ex) {
            return null;
        }
    }

    public static Geometry createFrom(String wkt, IProjection srs) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createFrom(wkt, srs);
        }
        catch (GeometryException ex) {
            return null;
        }
    }

    public static Geometry createFrom(String wkt) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createFrom(wkt);
        }
        catch (GeometryException ex) {
            return null;
        }
    }

    public static Object convertTo(Geometry geom, String format) {
        try {
            return geom.convertTo(format, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String toWKT(Geometry geom) {
        try {
            return geom.convertToWKT();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] toWKB(Geometry geom) {
        try {
            return geom.convertToWKB();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] toEWKB(Geometry geom) {
        try {
            return geom.convertToEWKB();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean intersects(Geometry geom1, Geometry geom2) {
        try {
            return geom1.intersects(geom2);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getGeometryTypeName(int type) {
        switch (type) {
            case 0: {
                return "Geometry";
            }
            case 1: {
                return "Point";
            }
            case 2: {
                return "Curve";
            }
            case 3: {
                return "Surface";
            }
            case 4: {
                return "Solid";
            }
            case 6: {
                return "Aggregate";
            }
            case 7: {
                return "Multipoint";
            }
            case 8: {
                return "Multicurve";
            }
            case 9: {
                return "Multisurface";
            }
            case 10: {
                return "Multisolid";
            }
            case 11: {
                return "Circle";
            }
            case 12: {
                return "Arc";
            }
            case 13: {
                return "Ellipse";
            }
            case 14: {
                return "Spline";
            }
            case 15: {
                return "Ellipticarc";
            }
            case 17: {
                return "Complex";
            }
            case 18: {
                return "Line";
            }
            case 19: {
                return "Polygon";
            }
            case 20: {
                return "Ring";
            }
            case 21: {
                return "Multiline";
            }
            case 22: {
                return "Multipolygon";
            }
            case 23: {
                return "Circumference";
            }
            case 24: {
                return "Periellipse";
            }
            case 25: {
                return "Filledspline";
            }
        }
        return "Geometry";
    }

    public static String getGeometrySubtypeName(int subtype) {
        switch (subtype) {
            case 0: {
                return "2D";
            }
            case 1: {
                return "3D";
            }
            case 2: {
                return "2DM";
            }
            case 3: {
                return "3DM";
            }
        }
        return "Unknown";
    }

    public static int getGeometryType(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return -1;
        }
        switch (typeName.toLowerCase()) {
            case "geometry": {
                return 0;
            }
            case "point": {
                return 1;
            }
            case "curve": {
                return 2;
            }
            case "surface": {
                return 3;
            }
            case "solid": {
                return 4;
            }
            case "aggregate": {
                return 6;
            }
            case "multipoint": {
                return 7;
            }
            case "multicurve": {
                return 8;
            }
            case "multisurface": {
                return 9;
            }
            case "multisolid": {
                return 10;
            }
            case "circle": {
                return 11;
            }
            case "arc": {
                return 12;
            }
            case "ellipse": {
                return 13;
            }
            case "spline": {
                return 14;
            }
            case "ellipticarc": {
                return 15;
            }
            case "complex": {
                return 17;
            }
            case "line": {
                return 18;
            }
            case "polygon": {
                return 19;
            }
            case "ring": {
                return 20;
            }
            case "multiline": {
                return 21;
            }
            case "multipolygon": {
                return 22;
            }
            case "circumference": {
                return 23;
            }
            case "periellipse": {
                return 24;
            }
            case "filledspline": {
                return 25;
            }
        }
        return -1;
    }

    public static int getGeometrySubtype(String subtype) {
        if (StringUtils.isBlank((CharSequence)subtype)) {
            return 4;
        }
        switch (subtype.toUpperCase()) {
            case "GEOM2D": 
            case "2D": {
                return 0;
            }
            case "GEOM3D": 
            case "3D": {
                return 1;
            }
            case "GEOM2DM": 
            case "2DM": {
                return 2;
            }
            case "GEOM3DM": 
            case "3DM": {
                return 3;
            }
        }
        return 4;
    }

    public static Circle createCircle(Point center, double radius, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Circle circle = (Circle)geomManager.create(11, subtype);
        circle.setPoints(center, radius);
        return circle;
    }

    public static Circle createCircle(Point firstPoint, Point secondPoint, Point thirdPoint, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Circle circle = (Circle)geomManager.create(11, subtype);
        circle.setPoints(firstPoint, secondPoint, thirdPoint);
        return circle;
    }

    public static Circle createCircle(Point firstPoint, Point secondPoint, Point thirdPoint, Point fourthPoint, Point fifthPoint, int subtype) throws CreateGeometryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D line1 = euclideanManager.createLine2D(firstPoint.getX(), firstPoint.getY(), secondPoint.getX(), secondPoint.getY());
        EuclideanLine2D line2 = euclideanManager.createLine2D(thirdPoint.getX(), thirdPoint.getY(), fourthPoint.getX(), fourthPoint.getY());
        return GeometryUtils.createCircle(line1, line2, fifthPoint, subtype);
    }

    public static Circle createCircle(EuclideanLine2D line1, EuclideanLine2D line2, Point point, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        try {
            Point2D intersection;
            EuclideanLine2D bisector;
            if (line1.isParallel(line2)) {
                if (Objects.equals(line1.getYIntercept(), line2.getYIntercept()) || Objects.equals(Math.abs(line1.getYIntercept()), 0.0) && Objects.equals(Math.abs(line2.getYIntercept()), 0.0)) {
                    EuclideanLine2D perpendicular = line1.getPerpendicular(point.getX(), point.getY());
                    Point2D intersection2 = line1.getIntersection(perpendicular);
                    return GeometryUtils.createCircle(point, point.distance(geomManager.createPoint(intersection2.getX(), intersection2.getY(), subtype)), subtype);
                }
                if (Double.isInfinite(line1.getSlope())) {
                    Point center = GeometryUtils.createPoint(-(line2.getC() + line1.getC()) / 2.0, point.getY(), (double)subtype);
                    double radius = line1.getDistance(center.getX(), center.getY());
                    return GeometryUtils.createCircle(center, radius, subtype);
                }
                bisector = euclideanManager.createLine2D(line1.getA(), line1.getB(), (line2.getC() + line1.getC()) / 2.0);
            } else {
                EuclideanLine2D[] bisectors = line1.getBisectors(line2);
                double distance1 = bisectors[0].getDistance(point.getX(), point.getY());
                double distance2 = bisectors[1].getDistance(point.getX(), point.getY());
                bisector = bisectors[0];
                if (distance1 > distance2) {
                    bisector = bisectors[1];
                }
            }
            if (Double.isInfinite(bisector.getSlope())) {
                intersection = line1.getIntersection(line2);
                Point center = GeometryUtils.createPoint(intersection.getX(), point.getY(), (double)subtype);
                Double radius = line1.getDistance(center.getX(), center.getY());
                return GeometryUtils.createCircle(center, radius, subtype);
            }
            if (bisector.getSlope() == 0.0) {
                if (line1.isParallel(line2)) {
                    Point center = GeometryUtils.createPoint(point.getX(), bisector.getYIntercept(), (double)subtype);
                    Double radius = line1.getDistance(center.getX(), center.getY());
                    return GeometryUtils.createCircle(center, radius, subtype);
                }
                intersection = line1.getIntersection(line2);
                Point center = GeometryUtils.createPoint(point.getX(), intersection.getY(), (double)subtype);
                Double radius = line1.getDistance(center.getX(), center.getY());
                return GeometryUtils.createCircle(center, radius, subtype);
            }
            EuclideanLine2D perpendicular = bisector.getPerpendicular(point.getX(), point.getY());
            intersection = bisector.getIntersection(perpendicular);
            Double radius = line1.getDistance(intersection.getX(), intersection.getY());
            return GeometryUtils.createCircle(geomManager.createPoint(intersection.getX(), intersection.getY(), subtype), radius, subtype);
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
            throw new CreateGeometryException(11, subtype, (Throwable)ex);
        }
    }

    public static Circle createCircle(Geometry geometry1, Geometry geometry2, double radius, Point firstPoint, Point secondPoint, int subtype) throws CreateGeometryException {
        try {
            Geometry buffer1 = geometry1.buffer(radius);
            MultiLine lines1 = buffer1.toLines();
            Geometry buffer2 = geometry2.buffer(radius);
            MultiLine lines2 = buffer2.toLines();
            Geometry intersection = lines1.intersection(lines2);
            Point center = null;
            if (intersection != null) {
                MultiPoint points = intersection.toPoints();
                double distance = Double.POSITIVE_INFINITY;
                for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                    Point point = points.getPointAt(i);
                    double pointDistance = point.distance(firstPoint) + point.distance(secondPoint);
                    if (!(pointDistance < distance)) continue;
                    center = point;
                    distance = pointDistance;
                }
            }
            if (center == null) {
                return null;
            }
            return GeometryUtils.createCircle(center, radius, subtype);
        }
        catch (GeometryException | GeometryOperationException | GeometryOperationNotSupportedException ex) {
            throw new CreateGeometryException(11, subtype, (Throwable)ex);
        }
    }

    public static Arc createArc(Point center, double radius, double startAngle, double angleExt, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Arc arc = (Arc)geomManager.create(12, subtype);
        arc.setPoints(center, radius, startAngle, angleExt);
        return arc;
    }

    public static Arc createArc(Point start, Point middle, Point end, int subtype) throws BaseException {
        Arc arc = (Arc)GeometryLocator.getGeometryManager().create(12, subtype);
        arc.setPoints(start, middle, end);
        return arc;
    }

    public static Arc createEllipse(Point firstPointAxisA, Point secondPointAxisA, double halfLengthAxisB, int subtype) throws CreateGeometryException {
        try {
            double lengthAxisA = secondPointAxisA.distance(firstPointAxisA);
            Point origen = GeometryUtils.createPoint(0.0, 0.0, (double)subtype);
            Arc ellipse = GeometryUtils.createArc(origen, lengthAxisA / 2.0, 0.0, Math.PI * 2, subtype);
            ellipse.scale(origen, 1.0, halfLengthAxisB * 2.0 / lengthAxisA);
            EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
            EuclideanLine2D axisA = euclideanManager.createLine2D(firstPointAxisA.getX(), firstPointAxisA.getY(), secondPointAxisA.getX(), secondPointAxisA.getY());
            double angle = axisA.getAngle();
            ellipse.rotate(angle, 0.0, 0.0);
            Point centerOfEllipse = GeometryUtils.getMidPoint(firstPointAxisA, secondPointAxisA, subtype);
            ellipse.move(centerOfEllipse.getX(), centerOfEllipse.getY());
            return ellipse;
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
            throw new CreateGeometryException(12, subtype, (Throwable)e);
        }
    }

    public static Ellipse createFilledEllipse(Point firstPointAxisA, Point secondPointAxisA, double halfLengthAxisB, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Ellipse ellipse = (Ellipse)geomManager.create(13, subtype);
        ellipse.setPoints(firstPointAxisA, secondPointAxisA, halfLengthAxisB);
        return ellipse;
    }

    public static Point getCenter(Point a, Point b, Point c, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Point2D center = euclideanManager.getCenter(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
        return geomManager.createPoint(center.getX(), center.getY(), subtype);
    }

    public static Point getMidPoint(Point a, Point b, int subtype) throws CreateGeometryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Point2D p = euclideanManager.getMidPoint(a.getX(), a.getY(), b.getX(), b.getY());
        return GeometryUtils.createPoint(p.getX(), p.getY(), (double)subtype);
    }

    public static Line createLine(double x1, double y1, double x2, double y2, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Line line = (Line)geomManager.create(2, subtype);
        line.addVertex(x1, y1);
        line.addVertex(x2, y2);
        return line;
    }

    public static Line createLine(Point p1, Point p2, int subtype) throws CreateGeometryException {
        return GeometryUtils.createLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), subtype);
    }

    public static Spline createSpline(List<Point> points, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Spline spline = (Spline)geomManager.create(14, subtype);
        points.forEach(point -> spline.addVertex((Point)point));
        return spline;
    }

    public static double calculateAngle(Point vertex, Point p1, Point p2) {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        return euclideanManager.calculateAngle(vertex.getX(), vertex.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double calculateAngle(Point vertex, Point p) {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        return euclideanManager.calculateAngle(vertex.getX(), vertex.getY(), p.getX(), p.getY());
    }

    public static boolean areThreePointsInLine(Point a, Point b, Point c) {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        return euclideanManager.areThreePointsInLine(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
    }

    public static String formatCoordinate(String fmt, double coordinate) {
        return GeometryUtils.formatCoordinate(fmt, null, coordinate);
    }

    public static String formatCoordinate(String fmt, String NS, double coordinate) {
        double value = Math.abs(coordinate);
        int deg = (int)value;
        double min = (value - (double)deg) * 60.0;
        double secs = (min - (double)((int)min)) * 60.0;
        String r = fmt;
        r = r.replace("%-", coordinate < 0.0 ? "-" : "");
        r = r.replace("%+", coordinate < 0.0 ? "-" : "+");
        r = StringUtils.isBlank((CharSequence)NS) || value == 0.0 ? r.replace("%N", "") : r.replace("%N", coordinate > 0.0 ? NS.substring(0, 1) : NS.substring(1, 2));
        r = GeometryUtils.formatCoordinate_replace(r, "s", "f", secs);
        r = GeometryUtils.formatCoordinate_replace(r, "d", "d", deg);
        r = GeometryUtils.formatCoordinate_replace(r, "m", "d", (int)min);
        r = GeometryUtils.formatCoordinate_replace(r, "D", "f", value);
        return r;
    }

    public static String formatAngle(String fmt, double angle) {
        double value = Math.abs(angle);
        int deg = (int)value;
        double min = (value - (double)deg) * 60.0;
        double secs = (min - (double)((int)min)) * 60.0;
        String r = fmt;
        r = r.replace("%-", angle < 0.0 ? "-" : "");
        r = r.replace("%+", angle < 0.0 ? "-" : "+");
        r = GeometryUtils.formatCoordinate_replace(r, "s", "f", secs);
        r = GeometryUtils.formatCoordinate_replace(r, "d", "d", deg);
        r = GeometryUtils.formatCoordinate_replace(r, "m", "d", (int)min);
        r = GeometryUtils.formatCoordinate_replace(r, "M", "f", min);
        r = GeometryUtils.formatCoordinate_replace(r, "D", "f", value);
        return r;
    }

    private static String formatCoordinate_replace(String fmt, String source_conversion, String target_conversion, Object value) {
        String s = fmt;
        Pattern p = Pattern.compile("%([-+#0,(]?+[0-9]*[.]*[0-9]*)" + source_conversion);
        Matcher macher = p.matcher(s);
        if (macher.find()) {
            String mod = macher.group(1);
            if (StringUtils.isBlank((CharSequence)mod)) {
                s = value instanceof Double ? fmt.replace("%" + source_conversion, String.format(Locale.ENGLISH, "%.3f", value)) : fmt.replace("%" + source_conversion, String.valueOf(value));
            } else {
                String x = String.format(Locale.ENGLISH, "%" + mod + target_conversion, value);
                s = macher.replaceAll(x);
            }
            return s;
        }
        return s;
    }

    public static double parseCoordinate(String source) {
        DMSNumberFormat parser = new DMSNumberFormat(false);
        try {
            return parser.parse(source);
        }
        catch (ParseException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(ex);
        }
    }

    public static double getCoefDirection(Point center, Point point1, Point point2) {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        return euclideanManager.getCoefDirection(center.getX(), center.getY(), point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public static Point calculateLambdaPoint(Point p1, Point p2, double lambda) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        GeometryType geomType = p1.getGeometryType();
        int subtype = geomType.getSubType();
        int dimension = geomType.getDimension();
        double[] coords = new double[dimension];
        Point p = geomManager.createPoint(0.0, 0.0, subtype);
        double distance = p1.distance(p2);
        for (int d = 0; d < dimension; ++d) {
            p.setCoordinateAt(d, p1.getCoordinateAt(d) + (p2.getCoordinateAt(d) - p1.getCoordinateAt(d)) * lambda);
        }
        return p;
    }

    public static boolean overlaps(Geometry polygon, Geometry polygon2, double theTolerance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (polygon != null && polygon2 != null) {
            if (theTolerance > 0.0) {
                Geometry buffer1 = polygon.buffer(-theTolerance);
                if (buffer1 != null) {
                    return buffer1.overlaps(polygon2);
                }
                Geometry buffer2 = polygon2.buffer(-theTolerance);
                if (buffer2 != null) {
                    return polygon.overlaps(buffer2);
                }
            } else {
                return polygon.overlaps(polygon2);
            }
        }
        return false;
    }

    public static int angleGetTurn(double ang1, double ang2) {
        double crossproduct = Math.sin(ang2 - ang1);
        if (crossproduct > 0.0) {
            return 1;
        }
        if (crossproduct < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double angleDiff(double ang1, double ang2) {
        double delAngle = ang1 < ang2 ? ang2 - ang1 : ang1 - ang2;
        if (delAngle > Math.PI) {
            delAngle = Math.PI * 2 - delAngle;
        }
        return delAngle;
    }

    public static final List<Geometry> extractFrom(String s, IProjection proj) {
        try {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            Geometry geom = GeometryUtils.createFrom(s, proj);
            if (geom != null) {
                if (geom.getProjection() == null) {
                    geom.setProjection(proj);
                }
                return Collections.singletonList(geom);
            }
            JsonObject json = Json.createObject((String)s);
            if (json == null && (json = Json.createArray((String)s)) == null) {
                return null;
            }
            return GeometryUtils.extractFrom((JsonValue)json, proj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final List<Geometry> extractFrom(JsonValue json, IProjection proj) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        if (GeometryUtils.extractFrom(json, proj, geoms) && !geoms.isEmpty()) {
            return geoms;
        }
        return null;
    }

    private static boolean extractFrom(JsonValue json, IProjection proj, List<Geometry> geoms) {
        try {
            if (json == null) {
                return false;
            }
            if (json instanceof JsonObject) {
                boolean x = false;
                for (JsonValue value : ((JsonObject)json).values()) {
                    if (!GeometryUtils.extractFrom(value, proj, geoms)) continue;
                    x = true;
                }
                return x;
            }
            if (json instanceof JsonArray) {
                boolean x = false;
                for (JsonValue value : (JsonArray)json) {
                    if (!GeometryUtils.extractFrom(value, proj, geoms)) continue;
                    x = true;
                }
                return x;
            }
            Object x = Json.toObject((JsonValue)json);
            if (x == null) {
                return false;
            }
            if (x instanceof Geometry) {
                Geometry geom = (Geometry)x;
                if (geom.getProjection() == null) {
                    geom.setProjection(proj);
                }
                geoms.add(geom);
                return true;
            }
            String s = Objects.toString(x, null);
            if (StringUtils.isBlank((CharSequence)s)) {
                return false;
            }
            Geometry geom = GeometryUtils.createFrom(s, proj);
            if (geom != null) {
                if (geom.getProjection() == null) {
                    geom.setProjection(proj);
                }
                geoms.add(geom);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final Geometry toAggregate(List<Geometry> geoms, StringBuilder warnings) {
        if (geoms == null || geoms.isEmpty()) {
            return null;
        }
        try {
            int firsttype;
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Geometry first = geoms.get(0);
            int type = firsttype = first.getType();
            if (manager.isSubtype(3, type)) {
                type = 22;
            } else if (manager.isSubtype(2, type)) {
                type = 21;
            } else if (manager.isSubtype(1, type)) {
                type = 7;
            } else if (manager.isSubtype(9, type)) {
                type = 22;
            } else if (manager.isSubtype(8, type)) {
                type = 21;
            } else if (manager.isSubtype(7, type)) {
                type = 7;
            } else {
                if (warnings != null) {
                    warnings.append("The geometry type is not supported.");
                    warnings.append("\n");
                }
                return null;
            }
            int firstsubtype = first.getGeometryType().getSubType();
            MultiPrimitive multi = (MultiPrimitive)manager.create(type, firstsubtype);
            if (first.getProjection() != null) {
                multi.setProjection(first.getProjection());
            }
            for (Geometry geom : geoms) {
                if (firsttype != geom.getType()) {
                    if (warnings != null) {
                        warnings.append("You cannot mix geometries of different types.");
                        warnings.append("\n");
                    }
                    return null;
                }
                if (first.getProjection() != null && geom.getProjection() != null && !first.getProjection().equals(geom.getProjection())) {
                    if (warnings != null) {
                        warnings.append("You cannot mix geometries with different projections.");
                        warnings.append("\n");
                    }
                    return null;
                }
                multi.addPrimitives(geom);
            }
            return multi;
        }
        catch (Exception e) {
            if (warnings != null) {
                warnings.append("Can't aggregate geometries.");
                warnings.append("\n(");
                warnings.append(e.getLocalizedMessage());
                warnings.append(")\n");
            }
            return null;
        }
    }
}

